/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractview;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.actions.STCollapseAllTreeAction;
import org.eclipse.linuxtools.dataviewers.actions.STCollapseSelectionAction;
import org.eclipse.linuxtools.dataviewers.actions.STCopyAction;
import org.eclipse.linuxtools.dataviewers.actions.STDataViewersSortAction;
import org.eclipse.linuxtools.dataviewers.actions.STExpandAllTreeAction;
import org.eclipse.linuxtools.dataviewers.actions.STExpandSelectionAction;
import org.eclipse.linuxtools.dataviewers.actions.STExportToCSVAction;
import org.eclipse.linuxtools.dataviewers.actions.STHideShowColAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSTDataView
extends ViewPart {
    private AbstractSTViewer stViewer = null;
    private IAction sortAction = null;
    private IAction preferencesAction = null;
    private IAction hideShowColAction = null;
    private IAction expandAllAction = null;
    private IAction collapseAllAction = null;
    private IAction expandSelectionAction = null;
    private IAction collapseSelectionAction = null;
    private IAction exportToCSVAction = null;
    private IAction copyToAction = null;

    protected abstract void createTitle(Composite var1);

    protected abstract AbstractSTViewer createAbstractSTViewer(Composite var1);

    protected abstract void contributeToToolbar(IToolBarManager var1);

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        this.createTitle(parent);
        this.stViewer = this.createAbstractSTViewer(parent);
        this.createActions();
        MenuManager mgr = this.initContextMenu();
        Menu menu = mgr.createContextMenu((Control)parent);
        this.stViewer.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.stViewer.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.stViewer.getViewer());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
    }

    protected void createActions() {
        this.expandAllAction = this.createExpandAllAction();
        this.collapseAllAction = this.createCollapseAllAction();
        this.sortAction = new STDataViewersSortAction(this.getSTViewer());
        this.hideShowColAction = new STHideShowColAction(this.getSTViewer());
        this.exportToCSVAction = this.createExportToCSVAction();
        this.expandSelectionAction = this.createExpandSelectionAction();
        this.collapseSelectionAction = this.createCollapseSelectionAction();
        this.copyToAction = new STCopyAction(this.getSTViewer());
    }

    protected IAction createExportToCSVAction() {
        return new STExportToCSVAction(this.getSTViewer());
    }

    private IAction createCollapseSelectionAction() {
        AbstractSTViewer abstractSTViewer = this.getSTViewer();
        if (abstractSTViewer instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)abstractSTViewer;
            return new STCollapseSelectionAction(stTreeViewer);
        }
        return null;
    }

    private IAction createExpandSelectionAction() {
        AbstractSTViewer abstractSTViewer = this.getSTViewer();
        if (abstractSTViewer instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)abstractSTViewer;
            return new STExpandSelectionAction(stTreeViewer);
        }
        return null;
    }

    private IAction createCollapseAllAction() {
        AbstractSTViewer abstractSTViewer = this.getSTViewer();
        if (abstractSTViewer instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)abstractSTViewer;
            return new STCollapseAllTreeAction(stTreeViewer);
        }
        return null;
    }

    private IAction createExpandAllAction() {
        AbstractSTViewer abstractSTViewer = this.getSTViewer();
        if (abstractSTViewer instanceof AbstractSTTreeViewer) {
            AbstractSTTreeViewer stTreeViewer = (AbstractSTTreeViewer)abstractSTViewer;
            return new STExpandAllTreeAction(stTreeViewer);
        }
        return null;
    }

    private MenuManager initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(mgr1 -> {
            this.getSTViewer().getViewer().cancelEditing();
            this.fillContextMenu(mgr1);
        });
        return mgr;
    }

    private void initToolBar(IToolBarManager manager) {
        if (this.expandAllAction != null) {
            manager.add(this.expandAllAction);
        }
        if (this.collapseAllAction != null) {
            manager.add(this.collapseAllAction);
        }
        if (this.hideShowColAction != null) {
            manager.add(this.hideShowColAction);
        }
        if (this.exportToCSVAction != null) {
            manager.add(this.exportToCSVAction);
        }
        if (this.sortAction != null) {
            manager.add(this.sortAction);
        }
        this.contributeToToolbar(manager);
        manager.update(true);
    }

    private void initMenu(IMenuManager menu) {
        if (this.preferencesAction != null) {
            menu.add(this.preferencesAction);
        }
    }

    public void setFocus() {
        ColumnViewer viewer = this.getSTViewer().getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    public AbstractSTViewer getSTViewer() {
        return this.stViewer;
    }

    public void setInput(Object input) {
        this.stViewer.getViewer().setInput(input);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Tree tree;
        TreeItem[] selection;
        Control control = this.stViewer.getViewer().getControl();
        if (control instanceof Tree && (selection = (tree = (Tree)control).getSelection()) != null && selection.length > 0) {
            if (this.collapseSelectionAction != null) {
                manager.add(this.collapseSelectionAction);
            }
            if (this.expandSelectionAction != null) {
                manager.add(this.expandSelectionAction);
            }
            manager.add((IContributionItem)new Separator("additions"));
            if (this.copyToAction != null) {
                manager.add(this.copyToAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }
}

