/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralValue;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.packs.core.tree.Leaf;

public class SvdEnumeratedValueDMNode
extends SvdObjectDMNode {
    public SvdEnumeratedValueDMNode(Leaf node) {
        super(node);
    }

    public String getValue() {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            return this.getNode().getProperty("value");
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            String str = this.getNode().getName();
            if ("*".equals(str)) {
                return "";
            }
            return str;
        }
        return "";
    }

    public boolean isDefault() {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            String isDefault = this.getNode().getProperty("isDefault");
            if (isDefault.isEmpty()) {
                return false;
            }
            return "true".equalsIgnoreCase(isDefault);
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return "*".equals(this.getNode().getName());
        }
        return false;
    }

    public boolean isMatchForValue(PeripheralValue value) {
        String val;
        BigInteger bigEnumerationValue;
        block4: {
            bigEnumerationValue = null;
            val = this.getValue();
            if (!val.isEmpty()) break block4;
            return false;
        }
        try {
            bigEnumerationValue = SvdUtils.parseScaledNonNegativeBigInteger(val);
            if (bigEnumerationValue.equals(value.getBigValue())) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toString() {
        String value = this.getValue();
        if (this.isDefault()) {
            value = "default";
        }
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", " + value + ", \"" + this.getDescription() + "\"]";
    }
}

