/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.css;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.css.CSSColors;
import org.eclipse.tm4e.core.internal.theme.css.CSSStyle;
import org.eclipse.tm4e.core.internal.theme.css.RGBColorImpl;
import org.eclipse.tm4e.core.internal.theme.css.util.AbstractDocumentHandler;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SelectorList;

@NonNullByDefault(value={})
public final class CSSDocumentHandler
extends AbstractDocumentHandler {
    private final List<IStyle> styles = new ArrayList<IStyle>();
    private @Nullable CSSStyle currentStyle;

    private static RGB createRGB(LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            String colorName = value.getStringValue();
            RGB color = CSSColors.getByName(value.getStringValue());
            if (color == null) {
                throw new IllegalArgumentException("Unkown CSS color '" + colorName + "'");
            }
            return color;
        }
        RGBColorImpl rgbColor = new RGBColorImpl(value);
        int green = (int)rgbColor.getGreen().getFloatValue((short)1);
        int red = (int)rgbColor.getRed().getFloatValue((short)1);
        int blue = (int)rgbColor.getBlue().getFloatValue((short)1);
        return new RGB(red, green, blue);
    }

    @Override
    public void endSelector(SelectorList selector) throws CSSException {
        this.currentStyle = null;
    }

    @Override
    public void property(String name, LexicalUnit value, boolean arg2) throws CSSException {
        block20: {
            CSSStyle currentStyle = this.currentStyle;
            if (currentStyle == null || name == null || value == null) break block20;
            switch (name) {
                case "color": {
                    currentStyle.setColor(CSSDocumentHandler.createRGB(value));
                    break;
                }
                case "background-color": {
                    currentStyle.setBackgroundColor(CSSDocumentHandler.createRGB(value));
                    break;
                }
                case "font-weight": {
                    currentStyle.setBold(value.getStringValue().toUpperCase().contains("BOLD"));
                    break;
                }
                case "font-style": {
                    currentStyle.setItalic(value.getStringValue().toUpperCase().contains("ITALIC"));
                    break;
                }
                case "text-decoration": {
                    String decoration = value.getStringValue().toUpperCase();
                    if (decoration.contains("UNDERLINE")) {
                        currentStyle.setUnderline(true);
                    }
                    if (!decoration.contains("LINE-THROUGH")) break;
                    currentStyle.setStrikeThrough(true);
                }
            }
        }
    }

    @Override
    public void startSelector(SelectorList selector) throws CSSException {
        this.currentStyle = new CSSStyle(selector);
        this.styles.add(this.currentStyle);
    }

    public List<IStyle> getStyles() {
        return this.styles;
    }
}

