/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    public long handle;
    Tree parent;
    String[] strings;
    Image[] images;
    Font font;
    Font[] cellFont;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int[] cellBackground;
    int[] cellForeground;

    public TreeItem(Tree parent, int style) {
        this(parent, style, -65536L, -65534L, 0L);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, style, -65536L, TreeItem.findPrevious(parent, index), 0L);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, style, parentItem.handle, -65534L, 0L);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, style, parentItem.handle, TreeItem.findPrevious(parentItem, index), 0L);
    }

    TreeItem(Tree parent, int style, long hParent, long hInsertAfter, long hItem) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, hParent, hInsertAfter, hItem);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static long findPrevious(Tree parent, int index) {
        if (parent == null) {
            return 0L;
        }
        if (index < 0) {
            SWT.error(6);
        }
        if (index == 0) {
            return -65535L;
        }
        long hwnd = parent.handle;
        long hFirstItem = OS.SendMessage(hwnd, 4362, 0L, 0L);
        long hItem = parent.findItem(hFirstItem, index - 1);
        if (hItem == 0L) {
            SWT.error(6);
        }
        return hItem;
    }

    static long findPrevious(TreeItem parentItem, int index) {
        if (parentItem == null) {
            return 0L;
        }
        if (index < 0) {
            SWT.error(6);
        }
        if (index == 0) {
            return -65535L;
        }
        Tree parent = parentItem.parent;
        long hwnd = parent.handle;
        long hParent = parentItem.handle;
        long hFirstItem = OS.SendMessage(hwnd, 4362, 4L, hParent);
        long hItem = parent.findItem(hFirstItem, index - 1);
        if (hItem == 0L) {
            SWT.error(6);
        }
        return hItem;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        if ((this.parent.style & 0x20) != 0) {
            long hwnd = this.parent.handle;
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 24;
            tvItem.stateMask = 61440;
            tvItem.state = 4096;
            tvItem.hItem = this.handle;
            OS.SendMessage(hwnd, 4415, 0L, tvItem);
        }
        this.foreground = -1;
        this.background = -1;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        long hwnd = this.parent.handle;
        long hItem = OS.SendMessage(hwnd, 4362, 4L, this.handle);
        if (hItem == 0L) {
            this.error(6);
        }
        if ((hItem = this.parent.findItem(hItem, index)) == 0L) {
            this.error(6);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.parent.clear(hItem, tvItem);
        if (all) {
            hItem = OS.SendMessage(hwnd, 4362, 4L, hItem);
            this.parent.clearAll(hItem, tvItem, all);
        }
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        long hwnd = this.parent.handle;
        long hItem = OS.SendMessage(hwnd, 4362, 4L, this.handle);
        if (hItem == 0L) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.parent.clearAll(hItem, tvItem, all);
    }

    @Override
    void destroyWidget() {
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.parent.releaseItem(this.handle, tvItem, false);
        this.parent.destroyItem(this, this.handle);
        this.releaseHandle();
    }

    long fontHandle(int index) {
        if (this.cellFont != null && this.cellFont[index] != null) {
            return SWTFontProvider.getFontHandle(this.cellFont[index], this.getNativeZoom());
        }
        if (this.font != null) {
            return SWTFontProvider.getFontHandle(this.font, this.getNativeZoom());
        }
        return -1L;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int pixel = this.cellBackground != null ? this.cellBackground[index] : -1;
        return pixel == -1 ? this.getBackground() : Color.win32_new(this.display, pixel);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return Win32DPIUtils.pixelToPoint(this.getBoundsInPixels(), this.getZoom());
    }

    Rectangle getBoundsInPixels() {
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rect = this.getBounds(0, true, false, false);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        return Win32DPIUtils.pixelToPoint(this.getBoundsInPixels(index), this.getZoom());
    }

    Rectangle getBoundsInPixels(int index) {
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rect = this.getBounds(index, true, true, true);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    RECT getBounds(int index, boolean getText, boolean getImage, boolean fullText) {
        return this.getBounds(index, getText, getImage, fullText, false, true, 0L);
    }

    RECT getBounds(int index, boolean getText, boolean getImage, boolean fullText, boolean fullImage, boolean clip, long hDC) {
        int gridWidth;
        if (!getText && !getImage) {
            return new RECT();
        }
        long hwnd = this.parent.handle;
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 17;
            tvItem.hItem = this.handle;
            tvItem.pszText = -1L;
            this.parent.ignoreCustomDraw = true;
            OS.SendMessage(hwnd, 4415, 0L, tvItem);
            this.parent.ignoreCustomDraw = false;
        }
        boolean firstColumn = index == 0;
        int columnCount = 0;
        long hwndHeader = this.parent.hwndHeader;
        if (hwndHeader != 0L) {
            columnCount = this.parent.columnCount;
            firstColumn = index == this.parent.getFirstColumnIndex();
        }
        RECT rect = new RECT();
        if (firstColumn) {
            boolean full = columnCount == 0 && getText && getImage && fullText && fullImage;
            if (!OS.TreeView_GetItemRect(hwnd, this.handle, rect, !full)) {
                return new RECT();
            }
            if (getImage && !fullImage) {
                if (OS.SendMessage(hwnd, 4360, 0L, 0L) != 0L) {
                    Point size = this.parent.getImageSize();
                    rect.left -= size.x + 3;
                    if (!getText) {
                        rect.right = rect.left + size.x;
                    }
                } else if (!getText) {
                    rect.right = rect.left;
                }
            }
            if ((fullText || fullImage || clip) && hwndHeader != 0L) {
                RECT headerRect;
                if (columnCount != 0) {
                    headerRect = this.parent.getColumnRect(index);
                    if (headerRect == null) {
                        return new RECT();
                    }
                } else {
                    headerRect = new RECT();
                    headerRect.right = this.parent.scrollWidth;
                    if (headerRect.right == 0) {
                        headerRect = rect;
                    }
                }
                if (fullText && clip) {
                    rect.right = headerRect.right;
                }
                if (fullImage) {
                    rect.left = headerRect.left;
                }
                if (clip && headerRect.right < rect.right) {
                    rect.right = headerRect.right;
                }
            }
        } else {
            if (index < 0 || index >= columnCount) {
                return new RECT();
            }
            RECT headerRect = this.parent.getColumnRect(index);
            if (headerRect == null) {
                return new RECT();
            }
            if (!OS.TreeView_GetItemRect(hwnd, this.handle, rect, false)) {
                return new RECT();
            }
            rect.left = headerRect.left;
            if (fullText && getImage && clip) {
                rect.right = headerRect.right;
            } else {
                rect.right = headerRect.left;
                Image image = null;
                if (index == 0) {
                    image = this.image;
                } else if (this.images != null) {
                    image = this.images[index];
                }
                if (image != null) {
                    Point size = this.parent.getImageSize();
                    rect.right += size.x;
                }
                if (getText) {
                    if (fullText && clip) {
                        rect.left = rect.right + 3;
                        rect.right = headerRect.right;
                    } else {
                        String string;
                        String string2 = index == 0 ? this.text : (string = this.strings != null ? this.strings[index] : null);
                        if (string != null) {
                            RECT textRect = new RECT();
                            char[] buffer = string.toCharArray();
                            int flags = 3104;
                            long hNewDC = hDC;
                            long hFont = 0L;
                            if (hDC == 0L) {
                                hNewDC = OS.GetDC(hwnd);
                                hFont = this.fontHandle(index);
                                if (hFont == -1L) {
                                    hFont = OS.SendMessage(hwnd, 49, 0L, 0L);
                                }
                                hFont = OS.SelectObject(hNewDC, hFont);
                            }
                            OS.DrawText(hNewDC, buffer, buffer.length, textRect, flags);
                            if (hDC == 0L) {
                                OS.SelectObject(hNewDC, hFont);
                                OS.ReleaseDC(hwnd, hNewDC);
                            }
                            if (getImage) {
                                rect.right += textRect.right - textRect.left + 9;
                            } else {
                                rect.left = rect.right + 3;
                                rect.right = rect.left + (textRect.right - textRect.left) + 3;
                            }
                        }
                    }
                }
                if (clip && headerRect.right < rect.right) {
                    rect.right = headerRect.right;
                }
            }
        }
        int n = gridWidth = this.parent.linesVisible && columnCount != 0 ? this.parent.getGridLineWidthInPixels() : 0;
        if (getText || !getImage) {
            rect.right = Math.max(rect.left, rect.right - gridWidth);
        }
        rect.bottom = Math.max(rect.top, rect.bottom - gridWidth);
        return rect;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        long result = OS.SendMessage(hwnd, 4414, 0L, tvItem);
        return result != 0L && (tvItem.state >> 12 & 1) == 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        long hwnd = this.parent.handle;
        int state = (int)OS.SendMessage(hwnd, 4391, this.handle, 32L);
        return (state & 0x20) != 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int pixel = this.cellForeground != null ? this.cellForeground[index] : -1;
        return pixel == -1 ? this.getForeground() : Color.win32_new(this.display, pixel);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        long result = OS.SendMessage(hwnd, 4414, 0L, tvItem);
        return result != 0L && tvItem.state >> 12 > 2;
    }

    public TreeItem getItem(int index) {
        long hItem;
        long hwnd;
        long hFirstItem;
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((hFirstItem = OS.SendMessage(hwnd = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            this.error(6);
        }
        if ((hItem = this.parent.findItem(hFirstItem, index)) == 0L) {
            this.error(6);
        }
        return this.parent._getItem(hItem);
    }

    public int getItemCount() {
        long hwnd;
        long hItem;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((hItem = OS.SendMessage(hwnd = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            return 0;
        }
        return this.parent.getItemCount(hItem);
    }

    public TreeItem[] getItems() {
        long hwnd;
        long hItem;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((hItem = OS.SendMessage(hwnd = this.parent.handle, 4362, 4L, this.handle)) == 0L) {
            return new TreeItem[0];
        }
        return this.parent.getItems(hItem);
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        return Win32DPIUtils.pixelToPoint(this.getImageBoundsInPixels(index), this.getZoom());
    }

    Rectangle getImageBoundsInPixels(int index) {
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rect = this.getBounds(index, false, true, false);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        long hwnd = this.parent.handle;
        long hItem = OS.SendMessage(hwnd, 4362, 3L, this.handle);
        return hItem != 0L ? this.parent._getItem(hItem) : null;
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        return Win32DPIUtils.pixelToPoint(this.getTextBoundsInPixels(index), this.getZoom());
    }

    Rectangle getTextBoundsInPixels(int index) {
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rect = this.getBounds(index, true, false, true);
        if (index == 0) {
            rect.left += 2;
        }
        rect.left = Math.min(rect.left, rect.right);
        rect.right = rect.right - 3 + 1;
        int width = Math.max(0, rect.right - rect.left);
        int height = Math.max(0, rect.bottom - rect.top);
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public int indexOf(TreeItem item) {
        long hwnd;
        long hItem;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return (hItem = OS.SendMessage(hwnd = this.parent.handle, 4362, 4L, this.handle)) == 0L ? -1 : this.parent.findIndex(hItem, item.handle);
    }

    void redraw() {
        RECT rect;
        boolean full;
        if (this.parent.currentItem == this || !this.parent.getDrawing()) {
            return;
        }
        long hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        boolean bl = full = (this.parent.style & 0x10010000) != 0;
        if (!full) {
            boolean bl2 = full = this.parent.columnCount != 0;
            if (!full && (this.parent.hooks(40) || this.parent.hooks(42))) {
                full = true;
            }
        }
        if (OS.TreeView_GetItemRect(hwnd, this.handle, rect = new RECT(), !full)) {
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    void redraw(int column, boolean drawText, boolean drawImage) {
        if (this.parent.currentItem == this || !this.parent.getDrawing()) {
            return;
        }
        long hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        boolean fullImage = column == 0 && drawText && drawImage;
        RECT rect = this.getBounds(column, drawText, drawImage, true, fullImage, true, 0L);
        OS.InvalidateRect(hwnd, rect, true);
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (destroy) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            this.parent.releaseItems(this.handle, tvItem);
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0L;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        boolean disableRedraw;
        this.checkWidget();
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = OS.SendMessage(hwnd, 4362, 4L, this.handle);
        boolean bl = disableRedraw = this.parent.cachedItemCount > 30;
        if (disableRedraw) {
            this.parent.setRedraw(false);
        }
        try {
            while (tvItem.hItem != 0L) {
                Widget item;
                OS.SendMessage(hwnd, 4414, 0L, tvItem);
                Widget widget = item = tvItem.lParam != -1L ? this.parent.items[(int)tvItem.lParam] : null;
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                } else {
                    this.parent.releaseItem(tvItem.hItem, tvItem, false);
                    this.parent.destroyItem(null, tvItem.hItem);
                }
                tvItem.hItem = OS.SendMessage(hwnd, 4362, 4L, this.handle);
            }
        }
        finally {
            if (disableRedraw) {
                this.parent.setRedraw(true);
            }
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellBackground[i] = -1;
                ++i;
            }
        }
        if (this.cellBackground[index] == pixel) {
            return;
        }
        this.cellBackground[index] = pixel;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(index, true, true);
    }

    public void setChecked(boolean checked) {
        RECT rect;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        OS.SendMessage(hwnd, 4414, 0L, tvItem);
        int state = tvItem.state >> 12;
        if (checked) {
            if ((state & 1) != 0) {
                ++state;
            }
        } else if ((state & 1) == 0) {
            --state;
        }
        if (tvItem.state == (state <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tvItem.state = state;
        OS.SendMessage(hwnd, 4415, 0L, tvItem);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(hwnd) && OS.TreeView_GetItemRect(hwnd, this.handle, rect = new RECT(), false)) {
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    public void setExpanded(boolean expanded) {
        long hNewItem;
        this.checkWidget();
        long hwnd = this.parent.handle;
        if (OS.SendMessage(hwnd, 4362, 4L, this.handle) == 0L) {
            return;
        }
        int state = (int)OS.SendMessage(hwnd, 4391, this.handle, 32L);
        if ((state & 0x20) != 0 == expanded) {
            return;
        }
        RECT oldRect = null;
        RECT[] rects = null;
        SCROLLINFO oldInfo = null;
        int count = 0;
        long hBottomItem = 0L;
        boolean redraw = false;
        boolean noScroll = true;
        long hTopItem = OS.SendMessage(hwnd, 4362, 5L, 0L);
        if (noScroll && hTopItem != 0L) {
            oldInfo = new SCROLLINFO();
            oldInfo.cbSize = SCROLLINFO.sizeof;
            oldInfo.fMask = 23;
            if (!OS.GetScrollInfo(hwnd, 0, oldInfo)) {
                oldInfo = null;
            }
            if (this.parent.getDrawing() && OS.IsWindowVisible(hwnd)) {
                boolean noAnimate = true;
                count = (int)OS.SendMessage(hwnd, 4368, 0L, 0L);
                rects = new RECT[count + 1];
                long hItem = hTopItem;
                int index = 0;
                while (hItem != 0L && (noAnimate || hItem != this.handle) && index < count) {
                    RECT rect = new RECT();
                    if (OS.TreeView_GetItemRect(hwnd, hItem, rect, true)) {
                        rects[index++] = rect;
                    }
                    hItem = OS.SendMessage(hwnd, 4362, 6L, hItem);
                }
                if (noAnimate || hItem != this.handle) {
                    redraw = true;
                    count = index;
                    hBottomItem = hItem;
                    oldRect = new RECT();
                    OS.GetClientRect(hwnd, oldRect);
                    long topHandle = this.parent.topHandle();
                    OS.UpdateWindow(topHandle);
                    OS.DefWindowProc(topHandle, 11, 0L, 0L);
                    if (hwnd != topHandle) {
                        OS.UpdateWindow(hwnd);
                        OS.DefWindowProc(hwnd, 11, 0L, 0L);
                    }
                }
            }
        }
        long hOldItem = OS.SendMessage(hwnd, 4362, 9L, 0L);
        this.parent.ignoreExpand = true;
        OS.SendMessage(hwnd, 4354, (long)(expanded ? 2 : 1), this.handle);
        this.parent.ignoreExpand = false;
        if (noScroll && hTopItem != 0L) {
            boolean collapsed = false;
            if (!expanded) {
                RECT rect = new RECT();
                while (hTopItem != 0L && !OS.TreeView_GetItemRect(hwnd, hTopItem, rect, false)) {
                    hTopItem = OS.SendMessage(hwnd, 4362, 3L, hTopItem);
                    collapsed = true;
                }
            }
            boolean scrolled = true;
            if (hTopItem != 0L) {
                OS.SendMessage(hwnd, 4363, 5L, hTopItem);
                boolean bl = scrolled = hTopItem != OS.SendMessage(hwnd, 4362, 5L, 0L);
            }
            if (!collapsed && !scrolled && oldInfo != null) {
                SCROLLINFO newInfo = new SCROLLINFO();
                newInfo.cbSize = SCROLLINFO.sizeof;
                newInfo.fMask = 23;
                if (OS.GetScrollInfo(hwnd, 0, newInfo) && oldInfo.nPos != newInfo.nPos) {
                    long lParam = OS.MAKELPARAM(4, oldInfo.nPos);
                    OS.SendMessage(hwnd, 276, lParam, 0L);
                }
            }
            if (redraw) {
                boolean fixScroll = false;
                if (!collapsed && !scrolled) {
                    RECT newRect = new RECT();
                    OS.GetClientRect(hwnd, newRect);
                    if (OS.EqualRect(oldRect, newRect)) {
                        long hItem = hTopItem;
                        int index = 0;
                        while (hItem != 0L && index < count) {
                            RECT rect = new RECT();
                            if (OS.TreeView_GetItemRect(hwnd, hItem, rect, true) && !OS.EqualRect(rect, rects[index])) break;
                            hItem = OS.SendMessage(hwnd, 4362, 6L, hItem);
                            ++index;
                        }
                        fixScroll = index == count && hItem == hBottomItem;
                    }
                }
                long topHandle = this.parent.topHandle();
                OS.DefWindowProc(topHandle, 11, 1L, 0L);
                if (hwnd != topHandle) {
                    OS.DefWindowProc(hwnd, 11, 1L, 0L);
                }
                if (fixScroll) {
                    RECT rect;
                    this.parent.updateScrollBar();
                    SCROLLINFO info = new SCROLLINFO();
                    info.cbSize = SCROLLINFO.sizeof;
                    info.fMask = 23;
                    if (OS.GetScrollInfo(hwnd, 1, info)) {
                        OS.SetScrollInfo(hwnd, 1, info, true);
                    }
                    if (this.handle == hBottomItem && OS.TreeView_GetItemRect(hwnd, hBottomItem, rect = new RECT(), false)) {
                        OS.InvalidateRect(hwnd, rect, true);
                    }
                } else {
                    int flags = 1157;
                    OS.RedrawWindow(topHandle, null, 0L, flags);
                }
            }
        }
        if ((hNewItem = OS.SendMessage(hwnd, 4362, 9L, 0L)) != hOldItem) {
            Event event = new Event();
            if (hNewItem != 0L) {
                event.item = this.parent._getItem(hNewItem);
                this.parent.hAnchor = hNewItem;
            }
            this.parent.sendSelectionEvent(13, event, true);
        }
    }

    public void setFont(Font font) {
        Font newFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        Font oldFont = this.font;
        Font font2 = newFont = font == null ? font : Font.win32_new(font, this.getNativeZoom());
        if (oldFont == newFont) {
            return;
        }
        this.font = newFont;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        if (font != null) {
            this.parent.customDraw = true;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            return;
        }
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 17;
        tvItem.hItem = this.handle;
        tvItem.pszText = -1L;
        OS.SendMessage(hwnd, 4415, 0L, tvItem);
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        Font font2 = this.cellFont[index] = font == null ? font : Font.win32_new(font, this.getNativeZoom());
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        if (font != null) {
            this.parent.customDraw = true;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (index == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long hwnd = this.parent.handle;
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 17;
            tvItem.hItem = this.handle;
            tvItem.pszText = -1L;
            OS.SendMessage(hwnd, 4415, 0L, tvItem);
        } else {
            this.redraw(index, true, false);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellForeground[i] = -1;
                ++i;
            }
        }
        if (this.cellForeground[index] == pixel) {
            return;
        }
        this.cellForeground[index] = pixel;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(index, true, false);
    }

    public void setGrayed(boolean grayed) {
        RECT rect;
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        long hwnd = this.parent.handle;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 61440;
        tvItem.hItem = this.handle;
        OS.SendMessage(hwnd, 4414, 0L, tvItem);
        int state = tvItem.state >> 12;
        if (grayed) {
            if (state <= 2) {
                state += 2;
            }
        } else if (state > 2) {
            state -= 2;
        }
        if (tvItem.state == (state <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tvItem.state = state;
        OS.SendMessage(hwnd, 4415, 0L, tvItem);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(hwnd) && OS.TreeView_GetItemRect(hwnd, this.handle, rect = new RECT(), false)) {
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image oldImage = null;
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            oldImage = this.image;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null && index != 0) {
            this.images = new Image[count];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            oldImage = this.images[index];
            this.images[index] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, index);
        if (index == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long hwnd = this.parent.handle;
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 50;
            tvItem.hItem = this.handle;
            tvItem.iSelectedImage = -1;
            tvItem.iImage = -1;
            tvItem.mask |= 1;
            tvItem.pszText = -1L;
            OS.SendMessage(hwnd, 4415, 0L, tvItem);
        } else {
            boolean drawText = image == null && oldImage != null || image != null && oldImage == null;
            this.redraw(index, drawText, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.parent.setItemCount(count, this.handle);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.strings == null && index != 0) {
            this.strings = new String[count];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (index == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            long hwnd = this.parent.handle;
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 17;
            tvItem.hItem = this.handle;
            tvItem.pszText = -1L;
            OS.SendMessage(hwnd, 4415, 0L, tvItem);
        } else {
            this.redraw(index, true, false);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void sort() {
        this.checkWidget();
        if ((this.parent.style & 0x10000000) != 0) {
            return;
        }
        this.parent.sort(this.handle, false);
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    @Override
    void handleDPIChange(Event event, float scalingFactor) {
        Font[] cellFonts;
        super.handleDPIChange(event, scalingFactor);
        if (this.font != null) {
            this.setFont(this.font);
        }
        if ((cellFonts = this.cellFont) != null) {
            int index = 0;
            while (index < cellFonts.length) {
                Font cellFont = cellFonts[index];
                cellFonts[index] = cellFont == null ? null : Font.win32_new(cellFont, this.getNativeZoom());
                ++index;
            }
        }
        TreeItem[] treeItemArray = this.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.notifyListeners(55, event);
            ++n2;
        }
    }
}

