/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;

public class MakefileAnnotationHover
implements IAnnotationHover {
    private IEditorPart fEditor;

    public MakefileAnnotationHover(IEditorPart editor) {
        this.fEditor = editor;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        IDocument document = sourceViewer.getDocument();
        try {
            IRegion info = document.getLineInformation(lineNumber);
            Object line = document.get(info.getOffset(), info.getLength());
            int numberOfLines = document.getNumberOfLines();
            while (line != null && ((String)line).endsWith("\\")) {
                line = ((String)line).substring(0, ((String)line).length() - 1);
                if (++lineNumber >= numberOfLines) continue;
                info = document.getLineInformation(lineNumber);
                String l = document.get(info.getOffset(), info.getLength());
                line = (String)line + "\n" + l;
            }
            if (line != null && ((String)line).indexOf(36) != -1 && ((String)line).length() > 1) {
                IWorkingCopyManager fManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
                IMakefile makefile = fManager.getWorkingCopy(this.fEditor.getEditorInput());
                line = makefile.expandString((String)line);
                return line;
            }
            return line;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

