/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.wikitext.internal.parser.html.DocumentProcessor;
import org.eclipse.mylyn.wikitext.internal.parser.html.Html;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

class WhitespaceCleanupProcessor
extends DocumentProcessor {
    private static final Set<String> CHILD_TAGS = Set.of("li", "th", "tr", "td");

    WhitespaceCleanupProcessor() {
    }

    @Override
    public void process(Document document) {
        Element body = document.body();
        this.moveLeadingOrTrailingSpaceOutOfElements(body);
        this.removeWhitespaceImmeditatelyPrecedingBrTags(body);
    }

    private void moveLeadingOrTrailingSpaceOutOfElements(Element body) {
        HashSet<Element> affectedParents = new HashSet<Element>();
        for (Element element : body.getAllElements()) {
            if (Html.isWhitespacePreserve(element)) continue;
            WhitespaceCleanupProcessor.normalizeTextNodes(element);
            List children = element.childNodes();
            if (!children.isEmpty()) {
                Node lastChild;
                Node node = (Node)children.get(0);
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    String text = textNode.getWholeText();
                    int nonWhitespaceIndex = WhitespaceCleanupProcessor.firstIndexOfNonWhitespace(text);
                    if (nonWhitespaceIndex > 0) {
                        affectedParents.add(textNode.parent());
                        textNode.splitText(nonWhitespaceIndex);
                        textNode.remove();
                        this.computeBeforeTarget(element).before((Node)textNode);
                        affectedParents.add(textNode.parent());
                    } else if (nonWhitespaceIndex == -1) {
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    }
                }
                this.normalizeEmptySpaceBetweenNodes(element);
                children = element.childNodes();
                if (!children.isEmpty() && (lastChild = (Node)children.get(children.size() - 1)) instanceof TextNode) {
                    TextNode textNode = (TextNode)lastChild;
                    String text = textNode.getWholeText();
                    int lastNonWhitespaceIndex = WhitespaceCleanupProcessor.lastIndexOfNonWhitespace(text);
                    if (lastNonWhitespaceIndex < 0) {
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    } else if (lastNonWhitespaceIndex < text.length() - 1) {
                        affectedParents.add(textNode.parent());
                        textNode.splitText(lastNonWhitespaceIndex + 1);
                        textNode = (TextNode)textNode.nextSibling();
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    }
                }
            }
            if (affectedParents.isEmpty()) continue;
            for (Node node : affectedParents) {
                if (!(node instanceof Element)) continue;
                WhitespaceCleanupProcessor.normalizeTextNodes((Element)node);
            }
            affectedParents.clear();
        }
    }

    private void normalizeEmptySpaceBetweenNodes(Element parent) {
        ArrayList children = parent.childNodes();
        if (!children.isEmpty()) {
            children = new ArrayList(children);
            for (Node child : children) {
                Node previousSibling = child.previousSibling();
                Node nextSibling = child.nextSibling();
                if (!(child instanceof TextNode)) continue;
                TextNode textNode = (TextNode)child;
                if (!(previousSibling instanceof Element) || !(nextSibling instanceof Element)) continue;
                Element prevElement = (Element)previousSibling;
                Element nextElement = (Element)nextSibling;
                this.normalizeTextBetweenNodes(textNode, prevElement, nextElement);
            }
        }
    }

    private void normalizeTextBetweenNodes(TextNode textNode, Element prevElement, Element nextElement) {
        String wholeText = StringUtil.normaliseWhitespace((String)textNode.getWholeText()).trim();
        if (wholeText.isEmpty()) {
            boolean isSurroundedByEqualTags;
            boolean bl = isSurroundedByEqualTags = nextElement.tagName().equals(prevElement.tagName()) && CHILD_TAGS.contains(nextElement.tagName());
            if (isSurroundedByEqualTags) {
                textNode.remove();
            }
        }
    }

    private void removeWhitespaceImmeditatelyPrecedingBrTags(Element body) {
        for (Element element : body.getElementsByTag("br")) {
            this.removeWhitespaceBefore(element);
        }
    }

    private void removeWhitespaceBefore(Element element) {
        Node previousSibling = element.previousSibling();
        if (previousSibling instanceof TextNode) {
            TextNode textNode = (TextNode)previousSibling;
            String text = textNode.getWholeText();
            int startOfTrailingWhitespace = WhitespaceCleanupProcessor.lastIndexOfNonWhitespace(text) + 1;
            if (startOfTrailingWhitespace <= 0) {
                textNode.remove();
            } else if (startOfTrailingWhitespace < text.length()) {
                textNode.splitText(startOfTrailingWhitespace);
                textNode.nextSibling().remove();
            }
        }
    }

    private Element computeAfterTarget(Element element) {
        List elementParentChildNodes;
        if (!(element.parent() == null || element.nodeName().equalsIgnoreCase("html") || (elementParentChildNodes = element.parent().childNodes()).size() != 1 && elementParentChildNodes.get(elementParentChildNodes.size() - 1) != element)) {
            return this.computeAfterTarget(element.parent());
        }
        return element;
    }

    private Element computeBeforeTarget(Element element) {
        List elementParentChildNodes;
        if (!(element.parent() == null || element.parent().nodeName().equalsIgnoreCase("html") || (elementParentChildNodes = element.parent().childNodes()).size() != 1 && elementParentChildNodes.get(0) != element)) {
            return this.computeBeforeTarget(element.parent());
        }
        return element;
    }

    private static int lastIndexOfNonWhitespace(String text) {
        int i = text.length() - 1;
        while (i > -1) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            --i;
        }
        return i;
    }

    private static int firstIndexOfNonWhitespace(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

