/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RepositoryExternalizationParticipant
extends AbstractExternalizationParticipant
implements IRepositoryListener {
    private static final String DESCRIPTION = Messages.RepositoryExternalizationParticipant_Task_Repositories;
    private final TaskRepositoryManager repositoryManager;
    private final ExternalizationManager externalizationManager;
    private boolean dirty = false;

    public RepositoryExternalizationParticipant(ExternalizationManager exManager, TaskRepositoryManager manager) {
        this.repositoryManager = manager;
        this.externalizationManager = exManager;
        this.repositoryManager.addListener(this);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.TASKLIST_SCHEDULING_RULE;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSave() {
        RepositoryExternalizationParticipant repositoryExternalizationParticipant = this;
        synchronized (repositoryExternalizationParticipant) {
            this.dirty = true;
        }
        this.externalizationManager.requestSave();
    }

    @Override
    public void load(File sourceFile, IProgressMonitor monitor) throws CoreException {
        this.repositoryManager.readRepositories(sourceFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File targetFile, IProgressMonitor monitor) throws CoreException {
        RepositoryExternalizationParticipant repositoryExternalizationParticipant = this;
        synchronized (repositoryExternalizationParticipant) {
            this.dirty = false;
        }
        this.repositoryManager.saveRepositories(targetFile.getAbsolutePath());
    }

    @Override
    public String getFileName() {
        return "repositories.xml.zip";
    }

    @Override
    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
        this.requestSave();
    }

    public void repositoriesRead() {
    }

    @Override
    public void repositoryAdded(TaskRepository repository) {
        this.requestSave();
    }

    @Override
    public void repositoryRemoved(TaskRepository repository) {
        this.requestSave();
    }

    @Override
    public void repositorySettingsChanged(TaskRepository repository) {
        this.requestSave();
    }
}

