/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.process.internal;

import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.terminal.connector.AbstractSettingsPage;
import org.eclipse.terminal.connector.process.ProcessSettings;
import org.eclipse.terminal.connector.process.internal.Messages;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ProcessSettingsPage
extends AbstractSettingsPage {
    private Text processImageSelectorControl;
    private Button processImageSelectorControlButton;
    private Text processArgumentsControl;
    private Button localEchoSelectorControl;
    private Text processWorkingDirControl;
    private final ProcessSettings settings;

    public ProcessSettingsPage(ProcessSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(panel, 256);
        label.setText(Messages.ProcessSettingsPage_processImagePathSelectorControl_label);
        Composite innerPanel = new Composite(panel, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        innerPanel.setLayout((Layout)layout);
        innerPanel.setLayoutData((Object)new GridData(768));
        this.processImageSelectorControl = new Text(innerPanel, 2052);
        this.processImageSelectorControl.setLayoutData((Object)new GridData(768));
        this.processImageSelectorControlButton = new Button(innerPanel, 8);
        this.processImageSelectorControlButton.setText(Messages.ProcessSettingsPage_processImagePathSelectorControl_button);
        this.processImageSelectorControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessSettingsPage.this.onBrowseButtonSelected(e);
            }
        });
        label = new Label(panel, 256);
        label.setText(Messages.ProcessSettingsPage_processArgumentsControl_label);
        this.processArgumentsControl = new Text(panel, 2052);
        this.processArgumentsControl.setLayoutData((Object)new GridData(768));
        label = new Label(panel, 256);
        label.setText(Messages.ProcessSettingsPage_processWorkingDirControl_label);
        this.processWorkingDirControl = new Text(panel, 2052);
        this.processWorkingDirControl.setLayoutData((Object)new GridData(768));
        this.localEchoSelectorControl = new Button(composite, 32);
        this.localEchoSelectorControl.setText(Messages.ProcessSettingsPage_localEchoSelectorControl_label);
        this.localEchoSelectorControl.setLayoutData((Object)new GridData(768));
        this.localEchoSelectorControl.setSelection(!PTY.isSupported((PTY.Mode)PTY.Mode.CONSOLE));
        this.loadSettings();
    }

    protected void onBrowseButtonSelected(SelectionEvent e) {
        Shell shell = e != null ? e.widget.getDisplay().getActiveShell() : PlatformUI.getWorkbench().getDisplay().getActiveShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText(Messages.ProcessSettingsPage_dialogTitle);
        String selectedFile = this.processImageSelectorControl.getText();
        if (selectedFile != null && selectedFile.trim().length() > 0) {
            String filterFileName;
            Path filePath = new Path(selectedFile);
            Path filterPath = filePath.toFile().isDirectory() ? filePath : filePath.removeLastSegments(1);
            String string = filterFileName = filePath.toFile().isDirectory() || !filePath.toFile().exists() ? null : filePath.lastSegment();
            if (!filterPath.isEmpty()) {
                dialog.setFilterPath(filterPath.toString());
            }
            if (filterFileName != null) {
                dialog.setFileName(filterFileName);
            }
        } else {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
            if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
                dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
        }
        if ((selectedFile = dialog.open()) != null) {
            this.processImageSelectorControl.setText(selectedFile);
        }
    }

    public void saveSettings() {
        this.settings.setImage(this.processImageSelectorControl.getText());
        this.settings.setArguments(this.processArgumentsControl.getText());
        this.settings.setLocalEcho(this.localEchoSelectorControl.getSelection());
        this.settings.setWorkingDir(this.processWorkingDirControl.getText());
        this.settings.setProcess(null);
    }

    public void loadSettings() {
        this.processImageSelectorControl.setText(this.settings.getImage());
        this.processArgumentsControl.setText(this.settings.getArguments());
        this.localEchoSelectorControl.setSelection(this.settings.isLocalEcho());
        this.processWorkingDirControl.setText(this.settings.getWorkingDir());
    }

    public boolean validateSettings() {
        String selectedFile = this.processImageSelectorControl.getText();
        return selectedFile != null && !"".equals(selectedFile.trim()) && new Path(selectedFile).toFile().canRead();
    }
}

