/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete", "event.topics=org/eclipse/e4/ui/LifeCycle/appShutdownStarted"})
public class ApplicationActiveListener
implements EventHandler {
    public static final String TOPIC_APPLICATION_ACTIVE = "org/eclipse/egit/ui/APPLICATION_ACTIVE";
    private volatile WindowTracker listener;

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if (topic == null) {
            return;
        }
        switch (topic) {
            case "org/eclipse/e4/ui/LifeCycle/appStartupComplete": {
                if (this.listener != null) break;
                this.listener = new WindowTracker();
                this.listener.update();
                PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.listener);
                break;
            }
            case "org/eclipse/e4/ui/LifeCycle/appShutdownStarted": {
                this.shutDown();
                break;
            }
        }
    }

    @Deactivate
    void shutDown() {
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.listener);
            this.listener = null;
        }
    }

    private static class WindowTracker
    implements IWindowListener {
        private boolean isActive;

        private WindowTracker() {
        }

        void update() {
            Display display;
            if (PlatformUI.isWorkbenchRunning() && (display = PlatformUI.getWorkbench().getDisplay()) != null && !display.isDisposed()) {
                try {
                    display.asyncExec(() -> {
                        boolean wasActive = this.isActive;
                        boolean bl = this.isActive = !display.isDisposed() && display.getActiveShell() != null;
                        if (wasActive != this.isActive) {
                            this.notify(this.isActive);
                        }
                    });
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
            }
        }

        private void notify(boolean active) {
            IEventBroker broker;
            if (PlatformUI.isWorkbenchRunning() && (broker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class)) != null) {
                broker.post(ApplicationActiveListener.TOPIC_APPLICATION_ACTIVE, (Object)active);
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            this.update();
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            this.update();
        }

        public void windowClosed(IWorkbenchWindow window) {
            this.update();
        }

        public void windowOpened(IWorkbenchWindow window) {
            this.update();
        }
    }
}

