/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyPreBuild;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class DefaultGCCDependencyCalculatorPreBuildCommands
implements IManagedDependencyPreBuild {
    private static final String EMPTY_STRING = "";
    IPath source;
    IResource resource;
    IBuildObject buildContext;
    ITool tool;
    IPath topBuildDirectory;
    IProject project;
    IPath sourceLocation;
    IPath outputLocation;
    boolean needExplicitRuleForFile;
    Boolean genericCommands = null;

    public DefaultGCCDependencyCalculatorPreBuildCommands(IPath source, IResource resource, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this.source = source;
        this.resource = resource;
        this.buildContext = buildContext;
        this.tool = tool;
        this.topBuildDirectory = topBuildDirectory;
        if (buildContext instanceof IConfiguration) {
            IConfiguration config = (IConfiguration)buildContext;
            this.project = (IProject)config.getOwner();
        } else if (buildContext instanceof IResourceInfo) {
            IResourceInfo resInfo = (IResourceInfo)buildContext;
            this.project = (IProject)resInfo.getParent().getOwner();
        }
        this.sourceLocation = source.isAbsolute() ? source : this.project.getLocation().append(source);
        this.outputLocation = this.project.getLocation().append(topBuildDirectory).append(this.getDependencyFiles()[0]);
        boolean resourceNameRequiresExplicitRule = true;
        if (resource != null) {
            resourceNameRequiresExplicitRule = resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(this.sourceLocation.toString()) || !resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(resource.getProjectRelativePath().toString());
        }
        boolean bl = this.needExplicitRuleForFile = resourceNameRequiresExplicitRule || BuildMacroProvider.getReferencedExplitFileMacros(tool).length > 0 || BuildMacroProvider.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(this.sourceLocation, this.outputLocation, null, tool)).length > 0;
        if (this.needExplicitRuleForFile) {
            this.genericCommands = false;
        }
    }

    public DefaultGCCDependencyCalculatorPreBuildCommands(IPath source, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this(source, null, buildContext, tool, topBuildDirectory);
    }

    @Override
    public boolean areCommandsGeneric() {
        if (this.genericCommands != null) {
            return this.genericCommands;
        }
        if (this.buildContext instanceof IConfiguration || this.buildContext instanceof IFolderInfo) {
            this.genericCommands = true;
            return true;
        }
        this.genericCommands = false;
        return false;
    }

    @Override
    public String getBuildStepName() {
        return "GCC_DEPENDS";
    }

    @Override
    public String[] getDependencyCommands() {
        String[] commands = new String[1];
        String depCmd = EMPTY_STRING;
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        String cmd = this.tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = !this.needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool)) : provider.resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException resolvedCommand) {
            // empty catch block
        }
        IManagedCommandLineInfo cmdLInfo = null;
        Vector<Object> options = new Vector<Object>();
        options.add("-w");
        options.add("-MM");
        options.add("-MP");
        if (this.buildContext instanceof IResourceConfiguration || this.needExplicitRuleForFile) {
            IPath outPath = this.getDependencyFiles()[0];
            optTxt = "-MT\"";
            optTxt = (String)optTxt + GnuMakefileGenerator.escapeWhitespaces(outPath.toString()) + "\"";
            options.add(optTxt);
            optTxt = "-MT\"";
            optTxt = (String)optTxt + GnuMakefileGenerator.escapeWhitespaces(outPath.removeFileExtension().toString());
            String outExt = this.tool.getOutputExtension(this.source.getFileExtension());
            if (outExt != null) {
                optTxt = (String)optTxt + "." + outExt;
            }
            optTxt = (String)optTxt + "\"";
            options.add(optTxt);
        } else {
            options.add("-MT\"$@\"");
            optTxt = "-MT\"$(@:%.d=%.o)\"";
            options.add(optTxt);
        }
        try {
            String[] allFlags;
            String[] stringArray = allFlags = this.tool.getToolCommandFlags(this.sourceLocation, this.outputLocation);
            int n = allFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                if (flag.startsWith("-I") || flag.startsWith("-D") || flag.startsWith("-U")) {
                    options.add(flag);
                }
                ++n2;
            }
        }
        catch (BuildException allFlags) {
            // empty catch block
        }
        IManagedCommandLineGenerator cmdLGen = this.tool.getCommandLineGenerator();
        String[] flags = options.toArray(new String[options.size()]);
        String[] inputs = new String[]{"$<"};
        cmdLInfo = cmdLGen.generateCommandLineInfo(this.tool, cmd, flags, "-MF", EMPTY_STRING, "$@", inputs, this.tool.getCommandLinePattern());
        if (cmdLInfo != null) {
            depCmd = cmdLInfo.getCommandLine();
            try {
                String resolvedCommand = !this.needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(depCmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool)) : provider.resolveValue(depCmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    depCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
        }
        commands[0] = depCmd;
        return commands;
    }

    @Override
    public IPath[] getDependencyFiles() {
        IPath depFilePath = this.source.removeFileExtension().addFileExtension("d");
        if (!depFilePath.isAbsolute() && this.topBuildDirectory.isPrefixOf(depFilePath)) {
            depFilePath = depFilePath.removeFirstSegments(1);
        }
        IPath[] paths = new IPath[]{depFilePath};
        return paths;
    }

    @Override
    public IBuildObject getBuildContext() {
        return this.buildContext;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public ITool getTool() {
        return this.tool;
    }

    @Override
    public IPath getTopBuildDirectory() {
        return this.topBuildDirectory;
    }
}

