/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.activity.core;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.ui.IndexReference;
import org.eclipse.mylyn.tasks.activity.core.ActivityEvent;
import org.eclipse.mylyn.tasks.activity.core.ActivityScope;
import org.eclipse.mylyn.tasks.activity.core.TaskActivityScope;
import org.eclipse.mylyn.tasks.activity.core.spi.ActivityProvider;
import org.eclipse.mylyn.tasks.activity.core.spi.IActivitySession;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;

public class TaskActivityProvider
extends ActivityProvider {
    private static final String UNKNOWN = "Unknown";
    private IActivitySession session;

    @Override
    public void open(IActivitySession session) {
        this.session = session;
    }

    @Override
    public void query(ActivityScope scope, IProgressMonitor monitor) throws CoreException {
        ITask scopeTask;
        String url;
        if (scope instanceof TaskActivityScope && (url = (scopeTask = ((TaskActivityScope)scope).getTask()).getUrl()) != null) {
            GetAssociatedTasks collector = new GetAssociatedTasks(this.session);
            IndexReference reference = new IndexReference();
            try {
                TaskListIndex taskListIndex = reference.index();
                taskListIndex.find(NLS.bind((String)"content:\"{0}\"", (Object)url), (TaskListIndex.TaskCollector)collector, 50);
            }
            finally {
                reference.dispose();
            }
        }
    }

    @Override
    public void close() {
    }

    private static class GetAssociatedTasks
    extends TaskListIndex.TaskCollector {
        private final IActivitySession session;

        public GetAssociatedTasks(IActivitySession session) {
            this.session = session;
        }

        public void collect(ITask task) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("author", this.getAuthor(task));
            attrMap.put("taskId", this.getTaskId(task));
            ActivityEvent activityEvent = new ActivityEvent(task.getHandleIdentifier(), task.getConnectorKind(), task.getSummary(), task.getCreationDate(), attrMap);
            this.session.fireActivityEvent(activityEvent);
        }

        private String getTaskId(ITask task) {
            if (task.getTaskId() == null) {
                return TaskActivityProvider.UNKNOWN;
            }
            return task.getTaskId();
        }

        private String getAuthor(ITask task) {
            if (task.getOwner() == null) {
                return TaskActivityProvider.UNKNOWN;
            }
            return task.getOwner();
        }
    }
}

