/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class BreakpointListener
implements IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private final IEditorPart editor;
    private final IAnnotationModel model;

    public BreakpointListener(IEditorPart editor, IAnnotationModel model) {
        this.editor = editor;
        this.model = model;
    }

    public void modelChanged(AnnotationModelEvent event) {
        if (!ContextCore.getContextManager().isContextActive()) {
            return;
        }
        IInteractionContext context = ContextCore.getContextManager().getActiveContext();
        if (context == null) {
            return;
        }
        Annotation[] annotationArray = event.getAddedAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.getType().equals("org.eclipse.debug.core.breakpoint")) {
                try {
                    ITypeRoot root = EditorUtility.getEditorInputJavaElement((IEditorPart)this.editor, (boolean)true);
                    Position position = this.model.getPosition(a);
                    IJavaElement element = root.getElementAt(position.offset);
                    AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)element);
                    String handleIdentifier = bridge.getHandleIdentifier((Object)element);
                    if (handleIdentifier != null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                            IInteractionElement iInteractionElement = ContextCore.getContextManager().processInteractionEvent(new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), handleIdentifier, this.editor.getSite().getId()));
                        });
                    }
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", e.getMessage(), (Throwable)e));
                }
            }
            ++n2;
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }
}

