/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.language.settings.providers;

import java.io.IOException;
import java.net.URL;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.internal.core.ICConsole;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.language.settings.providers.LanguageSettingsProvidersImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ScannerDiscoveryGlobalConsole
implements ICConsole {
    private MessageConsole console;

    public void start(IProject project) {
        Assert.isTrue((project == null ? 1 : 0) != 0);
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new ConsoleOutputStreamAdapter(this.console.newMessageStream());
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new ConsoleOutputStreamAdapter(this.console.newMessageStream());
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new ConsoleOutputStreamAdapter(this.console.newMessageStream());
    }

    public void init(String consoleId, String name, URL defaultIconUrl) {
        IConsole[] allConsoles;
        this.console = null;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = allConsoles = consoleManager.getConsoles();
        int n = allConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole con = iConsoleArray[n2];
            if (name.equals(con.getName()) && con instanceof MessageConsole) {
                this.console = (MessageConsole)con;
                this.console.clearConsole();
                break;
            }
            ++n2;
        }
        if (this.console == null) {
            URL iconUrl = LanguageSettingsProvidersImages.getImageUrl((String)consoleId);
            if (iconUrl == null) {
                iconUrl = defaultIconUrl;
            }
            ImageDescriptor imageDescriptor = iconUrl != null ? CDTSharedImages.getImageDescriptor((String)iconUrl.toString()) : ImageDescriptor.getMissingImageDescriptor();
            this.console = new MessageConsole(name, imageDescriptor);
            this.console.activate();
            consoleManager.addConsoles(new IConsole[]{this.console});
        }
    }

    private class ConsoleOutputStreamAdapter
    extends ConsoleOutputStream {
        private MessageConsoleStream fConsoleStream;

        public ConsoleOutputStreamAdapter(MessageConsoleStream stream) {
            this.fConsoleStream = stream;
        }

        public void write(int arg0) throws IOException {
            this.fConsoleStream.write(arg0);
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.fConsoleStream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.fConsoleStream.flush();
        }

        public void close() throws IOException {
            this.fConsoleStream.close();
        }
    }
}

