/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.core.RubyPlugin;

public class RubyASTUtil {
    private RubyASTUtil() {
    }

    public static String resolveClassName(ASTNode node) {
        String className = "";
        if (node instanceof Reference) {
            className = ((Reference)node).getStringRepresentation();
        } else if (node instanceof RubyColonExpression) {
            RubyColonExpression rcExp = (RubyColonExpression)node;
            if (rcExp.getLeft() != null) {
                className = RubyASTUtil.resolveClassName(rcExp.getLeft());
                className = String.valueOf(className) + "::";
            }
            className = String.valueOf(className) + rcExp.getName();
        }
        return className;
    }

    private static boolean collectColonExpression(RubyColonExpression value, StringBuffer sb) {
        ASTNode left = value.getLeft();
        if (left instanceof RubyColonExpression) {
            if (!RubyASTUtil.collectColonExpression((RubyColonExpression)left, sb)) {
                return false;
            }
        } else if (left instanceof ConstantReference) {
            sb.append(((ConstantReference)left).getName());
        } else if (left != null) {
            String msg = "Unexpected node in colon-expression " + left.getClass().getName();
            RubyPlugin.log(msg);
            return false;
        }
        if (sb.length() != 0) {
            sb.append("::");
        }
        sb.append(value.getName());
        return true;
    }

    public static String resolveReference(ASTNode value) {
        StringBuffer sb;
        if (value instanceof ConstantReference) {
            return ((ConstantReference)value).getName();
        }
        if (value instanceof RubyColonExpression && RubyASTUtil.collectColonExpression((RubyColonExpression)value, sb = new StringBuffer())) {
            return sb.toString();
        }
        return null;
    }

    public static String resolveReferenceSimpleName(ASTNode value) {
        if (value instanceof ConstantReference) {
            return ((ConstantReference)value).getName();
        }
        if (value instanceof RubyColonExpression) {
            return ((RubyColonExpression)value).getName();
        }
        return null;
    }
}

