/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import org.eclipse.dltk.internal.javascript.core.manipulation.JavascriptManipulationPlugin;
import org.eclipse.dltk.javascript.core.dom.ArrayAccessExpression;
import org.eclipse.dltk.javascript.core.dom.ArrayLiteral;
import org.eclipse.dltk.javascript.core.dom.AttributeIdentifier;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.BooleanLiteral;
import org.eclipse.dltk.javascript.core.dom.BreakStatement;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.CaseClause;
import org.eclipse.dltk.javascript.core.dom.CatchClause;
import org.eclipse.dltk.javascript.core.dom.Comment;
import org.eclipse.dltk.javascript.core.dom.ConditionalExpression;
import org.eclipse.dltk.javascript.core.dom.ConstStatement;
import org.eclipse.dltk.javascript.core.dom.ContinueStatement;
import org.eclipse.dltk.javascript.core.dom.DefaultClause;
import org.eclipse.dltk.javascript.core.dom.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.core.dom.DescendantAccessExpression;
import org.eclipse.dltk.javascript.core.dom.DoStatement;
import org.eclipse.dltk.javascript.core.dom.Elision;
import org.eclipse.dltk.javascript.core.dom.EmptyStatement;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionSelector;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.FilterExpression;
import org.eclipse.dltk.javascript.core.dom.FinallyClause;
import org.eclipse.dltk.javascript.core.dom.ForEachInStatement;
import org.eclipse.dltk.javascript.core.dom.ForInStatement;
import org.eclipse.dltk.javascript.core.dom.ForStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.GetterAssignment;
import org.eclipse.dltk.javascript.core.dom.IArrayElement;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.Label;
import org.eclipse.dltk.javascript.core.dom.LabeledStatement;
import org.eclipse.dltk.javascript.core.dom.NewExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.NullLiteral;
import org.eclipse.dltk.javascript.core.dom.NumericLiteral;
import org.eclipse.dltk.javascript.core.dom.ObjectLiteral;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.ParenthesizedExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAccessExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAssignment;
import org.eclipse.dltk.javascript.core.dom.QualifiedIdentifier;
import org.eclipse.dltk.javascript.core.dom.RegularExpressionLiteral;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.SetterAssignment;
import org.eclipse.dltk.javascript.core.dom.SimplePropertyAssignment;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.StringLiteral;
import org.eclipse.dltk.javascript.core.dom.SwitchElement;
import org.eclipse.dltk.javascript.core.dom.SwitchStatement;
import org.eclipse.dltk.javascript.core.dom.ThisExpression;
import org.eclipse.dltk.javascript.core.dom.ThrowStatement;
import org.eclipse.dltk.javascript.core.dom.TryStatement;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.UnaryOperator;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.WhileStatement;
import org.eclipse.dltk.javascript.core.dom.WildcardIdentifier;
import org.eclipse.dltk.javascript.core.dom.WithStatement;
import org.eclipse.dltk.javascript.core.dom.XmlExpressionFragment;
import org.eclipse.dltk.javascript.core.dom.XmlFragment;
import org.eclipse.dltk.javascript.core.dom.XmlInitializer;
import org.eclipse.dltk.javascript.core.dom.XmlTextFragment;
import org.eclipse.dltk.javascript.core.dom.rewrite.RewriteAnalyzer;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class Generator
extends DomSwitch<StringBuilder> {
    private final StringBuilder sb = new StringBuilder();
    private final ChangeDescription cd;
    private final String text;
    private final String lineDelimiter;
    private String nlStr;

    public Generator(ChangeDescription cd, String text, int pos, String lineDelimiter) {
        this.cd = cd;
        this.text = text;
        this.lineDelimiter = lineDelimiter;
        int end = pos;
        int st = pos - 1;
        while (st >= 0) {
            try {
                char c = text.charAt(st);
                if (c == '\n' || c == '\r') break;
                if (c != ' ' && c != '\t') {
                    end = st;
                }
            }
            catch (RuntimeException e) {
                System.err.println("OK");
            }
            --st;
        }
        this.nlStr = String.valueOf(lineDelimiter) + text.substring(st + 1, end);
    }

    public StringBuilder generate(Node node) {
        if (node.getBegin() != -1 && this.cd != null) {
            RewriteAnalyzer ra = new RewriteAnalyzer(this.cd, this.text, this.lineDelimiter);
            ra.rewrite(node);
            Document doc = new Document(this.text.substring(node.getBegin(), node.getEnd()));
            try {
                TextEdit edit = ra.getEdit();
                if (edit.hasChildren()) {
                    edit.moveTree(-node.getBegin());
                }
                edit.apply((IDocument)doc);
                String res = doc.get();
                if (res.contains(this.lineDelimiter)) {
                    int end = node.getBegin();
                    int st = node.getBegin() - 1;
                    while (st >= 0) {
                        char c = this.text.charAt(st);
                        if (c == '\n' || c == '\r') break;
                        if (c != ' ' && c != '\t') {
                            end = st;
                        }
                        --st;
                    }
                    String nl = String.valueOf(this.lineDelimiter) + this.text.substring(st + 1, end);
                    this.sb.append(res.replace(nl, this.nlStr));
                } else {
                    this.sb.append(res);
                }
            }
            catch (BadLocationException e) {
                JavascriptManipulationPlugin.log(e);
            }
            return this.sb;
        }
        this.doSwitch(node);
        return this.sb;
    }

    public Generator append(String s) {
        this.sb.append(s);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    private void indent() {
        this.nlStr = String.valueOf(this.nlStr) + '\t';
    }

    private void unindent() {
        this.nlStr = this.nlStr.substring(0, this.nlStr.length() - 1);
    }

    public String getIndentation() {
        return this.nlStr;
    }

    public void newLine() {
        this.sb.append(this.nlStr);
    }

    @Override
    public StringBuilder caseIdentifier(Identifier object) {
        return this.sb.append(object.getName());
    }

    @Override
    public StringBuilder caseVariableReference(VariableReference object) {
        return this.sb.append(object.getVariable().getName());
    }

    @Override
    public StringBuilder caseLabel(Label object) {
        return this.sb.append(object.getName());
    }

    @Override
    public StringBuilder caseNullLiteral(NullLiteral object) {
        return this.sb.append("null");
    }

    @Override
    public StringBuilder caseBooleanLiteral(BooleanLiteral object) {
        return this.sb.append(object.getText());
    }

    @Override
    public StringBuilder caseNumericLiteral(NumericLiteral object) {
        return this.sb.append(object.getText());
    }

    @Override
    public StringBuilder caseStringLiteral(StringLiteral object) {
        return this.sb.append(object.getText());
    }

    @Override
    public StringBuilder caseRegularExpressionLiteral(RegularExpressionLiteral object) {
        return this.sb.append(object.getText());
    }

    @Override
    public StringBuilder caseThisExpression(ThisExpression object) {
        return this.sb.append("this");
    }

    @Override
    public StringBuilder caseArrayLiteral(ArrayLiteral object) {
        this.sb.append('[');
        boolean first = true;
        for (IArrayElement elem : object.getElements()) {
            if (!first) {
                this.sb.append(',');
            }
            this.generate(elem);
            first = false;
        }
        return this.sb.append(']');
    }

    @Override
    public StringBuilder caseElision(Elision object) {
        return this.sb;
    }

    @Override
    public StringBuilder caseObjectLiteral(ObjectLiteral object) {
        this.sb.append('{').append(this.nlStr);
        boolean first = true;
        this.indent();
        for (PropertyAssignment pa : object.getProperties()) {
            if (!first) {
                this.sb.append(',').append(this.nlStr);
            }
            this.generate(pa);
            first = false;
        }
        this.unindent();
        return this.sb.append(this.nlStr).append('}');
    }

    @Override
    public StringBuilder caseSimplePropertyAssignment(SimplePropertyAssignment object) {
        this.generate(object.getName());
        this.sb.append(':');
        return this.generate(object.getInitializer());
    }

    private void generateStatements(EList<Statement> list) {
        this.indent();
        int i = 0;
        while (i < list.size()) {
            this.generate((Node)list.get(i));
            if (i == list.size() - 1) {
                this.unindent();
            }
            this.newLine();
            ++i;
        }
    }

    @Override
    public StringBuilder caseGetterAssignment(GetterAssignment object) {
        this.sb.append("get ");
        this.generate(object.getName());
        this.generate(object.getBody());
        return this.sb;
    }

    @Override
    public StringBuilder caseSetterAssignment(SetterAssignment object) {
        this.sb.append("set ");
        this.generate(object.getName());
        this.sb.append('(').append(object.getParameter().getName()).append(") ");
        this.generate(object.getBody());
        return this.sb;
    }

    @Override
    public StringBuilder caseParenthesizedExpression(ParenthesizedExpression object) {
        this.sb.append('(');
        this.generate(object.getEnclosed());
        return this.sb.append(')');
    }

    @Override
    public StringBuilder caseArrayAccessExpression(ArrayAccessExpression object) {
        this.generate(object.getArray());
        this.sb.append('[');
        this.generate(object.getIndex());
        return this.sb.append(']');
    }

    @Override
    public StringBuilder casePropertyAccessExpression(PropertyAccessExpression object) {
        this.generate(object.getObject());
        this.sb.append('.');
        return this.generate(object.getProperty());
    }

    private void generateExpressions(EList<Expression> list) {
        boolean first = true;
        for (Expression expr : list) {
            if (!first) {
                this.sb.append(',');
            }
            this.generate(expr);
            first = false;
        }
    }

    @Override
    public StringBuilder caseNewExpression(NewExpression object) {
        this.sb.append("new ");
        this.generate(object.getConstructor());
        this.sb.append('(');
        this.generateExpressions(object.getArguments());
        return this.sb.append(')');
    }

    @Override
    public StringBuilder caseCallExpression(CallExpression object) {
        this.generate(object.getApplicant());
        this.sb.append('(');
        this.generateExpressions(object.getArguments());
        return this.sb.append(')');
    }

    @Override
    public StringBuilder caseUnaryExpression(UnaryExpression object) {
        UnaryOperator op = object.getOperation();
        boolean postfix = RewriteAnalyzer.isPostfix((Object)op);
        boolean text = RewriteAnalyzer.isTextUnary((Object)op);
        if (!postfix) {
            this.sb.append(object.getOperation().toString());
        }
        if (text) {
            this.sb.append(' ');
        }
        this.generate(object.getArgument());
        if (postfix) {
            this.sb.append(object.getOperation().toString());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseBinaryExpression(BinaryExpression object) {
        this.generate(object.getLeft());
        boolean text = RewriteAnalyzer.isTextBinary((Object)object.getOperation());
        if (text) {
            this.sb.append(' ');
        }
        this.sb.append(object.getOperation().toString());
        if (text) {
            this.sb.append(' ');
        }
        this.generate(object.getRight());
        return this.sb;
    }

    @Override
    public StringBuilder caseConditionalExpression(ConditionalExpression object) {
        this.generate(object.getPredicate());
        this.sb.append('?');
        this.generate(object.getConsequent());
        this.sb.append(':');
        return this.generate(object.getAlternative());
    }

    @Override
    public StringBuilder caseBlockStatement(BlockStatement object) {
        this.indent();
        this.sb.append('{').append(this.nlStr);
        this.unindent();
        this.generateStatements(object.getStatements());
        this.sb.append('}');
        return this.sb;
    }

    @Override
    public StringBuilder caseVariableStatement(VariableStatement object) {
        this.sb.append("var ");
        boolean first = true;
        for (VariableDeclaration decl : object.getDeclarations()) {
            if (!first) {
                this.sb.append(',');
            }
            this.generate(decl);
            first = false;
        }
        this.sb.append(';');
        return this.sb;
    }

    @Override
    public StringBuilder caseConstStatement(ConstStatement object) {
        this.sb.append("const ");
        boolean first = true;
        for (VariableDeclaration decl : object.getDeclarations()) {
            if (!first) {
                this.sb.append(',');
            }
            this.generate(decl);
            first = false;
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseVariableDeclaration(VariableDeclaration object) {
        this.sb.append(object.getIdentifier().getName());
        if (object.getInitializer() != null) {
            this.sb.append('=');
            this.generate(object.getInitializer());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseEmptyStatement(EmptyStatement object) {
        return this.sb.append(';');
    }

    @Override
    public StringBuilder caseExpressionStatement(ExpressionStatement object) {
        return this.generate(object.getExpression());
    }

    @Override
    public StringBuilder caseIfStatement(IfStatement object) {
        this.sb.append("if (");
        this.generate(object.getPredicate());
        this.sb.append(") ");
        this.generate(object.getConsequent());
        if (object.getAlternative() != null) {
            this.sb.append(" else ");
            this.generate(object.getAlternative());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseDoStatement(DoStatement object) {
        this.sb.append("do ");
        this.generate(object.getBody());
        this.sb.append("while (");
        this.generate(object.getCondition());
        return this.sb.append(')');
    }

    @Override
    public StringBuilder caseWhileStatement(WhileStatement object) {
        this.sb.append("while (");
        this.generate(object.getCondition());
        this.sb.append(") ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseForStatement(ForStatement object) {
        this.sb.append("for (");
        if (object.getInitialization() != null) {
            this.generate(object.getInitialization());
        }
        this.sb.append(';');
        if (object.getCondition() != null) {
            this.generate(object.getCondition());
        }
        this.sb.append(';');
        if (object.getIncrement() != null) {
            this.generate(object.getIncrement());
        }
        this.sb.append(") ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseForInStatement(ForInStatement object) {
        this.sb.append("for (");
        this.generate(object.getItem());
        this.sb.append(" in ");
        this.generate(object.getCollection());
        this.sb.append(") ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseForEachInStatement(ForEachInStatement object) {
        this.sb.append("for each(");
        this.generate(object.getItem());
        this.sb.append(" in ");
        this.generate(object.getCollection());
        this.sb.append(") ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseContinueStatement(ContinueStatement object) {
        this.sb.append("continue");
        if (object.getLabel() != null) {
            this.sb.append(' ').append(object.getLabel().getName());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseBreakStatement(BreakStatement object) {
        this.sb.append("break");
        if (object.getLabel() != null) {
            this.sb.append(' ').append(object.getLabel().getName());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseReturnStatement(ReturnStatement object) {
        this.sb.append("return");
        if (object.getExpression() != null) {
            this.sb.append(' ');
            this.generate(object.getExpression());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseWithStatement(WithStatement object) {
        this.sb.append("with (");
        this.generate(object.getExpression());
        this.sb.append(") ");
        return this.generate(object.getStatement());
    }

    @Override
    public StringBuilder caseSwitchStatement(SwitchStatement object) {
        this.sb.append("switch (");
        this.generate(object.getSelector());
        this.sb.append(") {");
        for (SwitchElement se : object.getElements()) {
            this.generate(se);
        }
        return this.sb.append('}');
    }

    @Override
    public StringBuilder caseCaseClause(CaseClause object) {
        this.sb.append("case ");
        this.generate(object.getExpression());
        this.sb.append(':').append(this.nlStr);
        this.generateStatements(object.getStatements());
        return this.sb;
    }

    @Override
    public StringBuilder caseDefaultClause(DefaultClause object) {
        this.sb.append("default:").append(this.nlStr);
        this.generateStatements(object.getStatements());
        return this.sb;
    }

    @Override
    public StringBuilder caseLabeledStatement(LabeledStatement object) {
        this.sb.append(object.getLabel().getName()).append(": ");
        return this.generate(object.getStatement());
    }

    @Override
    public StringBuilder caseThrowStatement(ThrowStatement object) {
        this.sb.append("throw ");
        return this.generate(object.getException());
    }

    @Override
    public StringBuilder caseTryStatement(TryStatement object) {
        this.sb.append("try ");
        this.generate(object.getBody());
        for (CatchClause cc : object.getCatches()) {
            this.sb.append(' ');
            this.generate(cc);
        }
        if (object.getFinallyClause() != null) {
            this.sb.append(' ');
            this.generate(object.getFinallyClause());
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseCatchClause(CatchClause object) {
        this.sb.append("catch (");
        this.generate(object.getException());
        if (object.getFilter() != null) {
            this.sb.append(" if ");
            this.generate(object.getFilter());
        }
        this.sb.append(") ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseFinallyClause(FinallyClause object) {
        this.sb.append("finally ");
        return this.generate(object.getBody());
    }

    @Override
    public StringBuilder caseFunctionExpression(FunctionExpression object) {
        if (object.getDocumentation() != null) {
            this.sb.append(object.getDocumentation().getText());
        }
        this.sb.append("function ");
        if (object.getIdentifier() != null) {
            this.sb.append(object.getIdentifier().getName());
        }
        this.sb.append('(');
        boolean first = true;
        for (Parameter prm : object.getParameters()) {
            if (!first) {
                this.sb.append(',');
            }
            this.generate(prm);
            first = false;
        }
        this.sb.append(')');
        this.sb.append(' ');
        this.generate(object.getBody());
        return this.sb;
    }

    @Override
    public StringBuilder caseSource(Source object) {
        this.generateStatements(object.getStatements());
        return this.sb;
    }

    @Override
    public StringBuilder caseXmlInitializer(XmlInitializer object) {
        for (XmlFragment fragment : object.getFragments()) {
            this.generate(fragment);
        }
        return this.sb;
    }

    @Override
    public StringBuilder caseAttributeIdentifier(AttributeIdentifier object) {
        this.sb.append('@');
        return this.generate(object.getSelector());
    }

    @Override
    public StringBuilder caseQualifiedIdentifier(QualifiedIdentifier object) {
        this.generate(object.getNamespace());
        this.sb.append("::");
        return this.generate(object.getMember());
    }

    @Override
    public StringBuilder caseWildcardIdentifier(WildcardIdentifier object) {
        return this.sb.append('*');
    }

    @Override
    public StringBuilder caseExpressionSelector(ExpressionSelector object) {
        this.sb.append('[');
        this.generate(object.getIndex());
        return this.sb.append(']');
    }

    @Override
    public StringBuilder caseXmlTextFragment(XmlTextFragment object) {
        return this.sb.append(object.getText());
    }

    @Override
    public StringBuilder caseXmlExpressionFragment(XmlExpressionFragment object) {
        this.sb.append('{');
        this.generate(object.getExpression());
        return this.sb.append('}');
    }

    @Override
    public StringBuilder caseDescendantAccessExpression(DescendantAccessExpression object) {
        this.generate(object.getObject());
        this.sb.append("..");
        return this.generate(object.getProperty());
    }

    @Override
    public StringBuilder caseFilterExpression(FilterExpression object) {
        this.generate(object.getObject());
        this.sb.append(".(");
        this.generate(object.getFilter());
        return this.sb.append(')');
    }

    @Override
    public StringBuilder caseDefaultXmlNamespaceStatement(DefaultXmlNamespaceStatement object) {
        this.sb.append("default xml namespace = ");
        return this.generate(object.getExpression());
    }

    @Override
    public StringBuilder caseParameter(Parameter object) {
        this.sb.append(object.getName().getName());
        return this.sb;
    }

    @Override
    public StringBuilder caseComment(Comment object) {
        return this.sb.append(object.getText());
    }
}

