/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.eclipse.dltk.console.IScriptConsoleIO;
import org.eclipse.dltk.console.InterpreterResponse;
import org.eclipse.dltk.console.ScriptConsoleXmlHelper;
import org.eclipse.dltk.console.ShellResponse;
import org.eclipse.dltk.core.DLTKCore;

public class ScriptConsoleIO
implements IScriptConsoleIO {
    private static final String INTERPRETER = "interpreter";
    private static final String SHELL = "shell";
    private final InputStream input;
    private final OutputStream output;
    private final String id;

    protected static void logInterpreterResponse(String response) {
    }

    protected static void logShellResponse(String response) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readFixed(int len, InputStream input) throws IOException {
        byte[] buffer = new byte[len];
        int from = 0;
        try {
            while (true) {
                int n;
                if (from >= buffer.length) {
                    return new String(buffer, 0, from, "UTF-8");
                }
                try {
                    n = input.read(buffer, from, buffer.length - from);
                }
                catch (SocketTimeoutException sxcn) {
                    n = input.read(buffer, from, buffer.length - from);
                }
                if (n == -1) {
                    return null;
                }
                from += n;
            }
        }
        catch (SocketTimeoutException sxcn) {
            if (!DLTKCore.DEBUG) return new String(buffer, 0, from, "UTF-8");
            sxcn.printStackTrace();
        }
        return new String(buffer, 0, from, "UTF-8");
    }

    protected static int readLength(InputStream input) throws IOException {
        try {
            String readFixed = ScriptConsoleIO.readFixed(10, input);
            return Integer.parseInt(readFixed);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected static String readResponse(InputStream input) throws IOException {
        int len = ScriptConsoleIO.readLength(input);
        if (len == -1) {
            return null;
        }
        String xml = ScriptConsoleIO.readFixed(len, input);
        if (xml == null) {
            return null;
        }
        return xml;
    }

    public ScriptConsoleIO(InputStream input, OutputStream output) throws IOException {
        if (input == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.output = output;
        this.id = ScriptConsoleXmlHelper.parseInfoXml(ScriptConsoleIO.readResponse(input));
    }

    @Override
    public InputStream getInitialResponseStream() {
        return new InputStream(){
            boolean finished = false;

            @Override
            public int read() throws IOException {
                if (this.finished) {
                    return -1;
                }
                byte[] b = new byte[1];
                int read = ScriptConsoleIO.this.input.read(b, 0, 1);
                if (read == -1 || b[0] == 0) {
                    this.finished = true;
                    return -1;
                }
                return b[0];
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ShellResponse execShell(String command, String[] args) throws IOException {
        this.output.write("shell\n".getBytes("UTF-8"));
        this.output.write((String.valueOf(command) + "\n").getBytes("UTF-8"));
        int i = 0;
        while (i < args.length) {
            this.output.write((String.valueOf(args[i]) + "\n").getBytes("UTF-8"));
            ++i;
        }
        this.output.flush();
        String response = ScriptConsoleIO.readResponse(this.input);
        ScriptConsoleIO.logShellResponse(response);
        return ScriptConsoleXmlHelper.parseShellXml(response);
    }

    @Override
    public InterpreterResponse execInterpreter(String command) throws IOException {
        this.output.write("interpreter\n".getBytes("UTF-8"));
        this.output.write((String.valueOf(command) + "\n").getBytes("UTF-8"));
        this.output.flush();
        String response = ScriptConsoleIO.readResponse(this.input);
        ScriptConsoleIO.logInterpreterResponse(response);
        return ScriptConsoleXmlHelper.parseInterpreterXml(response);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.output.close();
    }
}

