/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.Serializable;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public byte[] bytes;
    public int begin;
    public int realSize;
    int hash;
    boolean validHash = false;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final double FACTOR = 1.5;

    public ByteList() {
        this(4);
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
        this.realSize = 0;
    }

    public ByteList(byte[] wrap) {
        this(wrap, true);
    }

    public ByteList(byte[] wrap, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        this.bytes = copy ? (byte[])wrap.clone() : wrap;
        this.realSize = wrap.length;
    }

    public ByteList(ByteList wrap) {
        this(wrap.bytes, wrap.begin, wrap.realSize);
    }

    public ByteList(byte[] wrap, int index, int len) {
        this(wrap, index, len, true);
    }

    public ByteList(byte[] wrap, int index, int len, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        if (copy || index != 0) {
            this.bytes = new byte[len];
            System.arraycopy(wrap, index, this.bytes, 0, len);
        } else {
            this.bytes = wrap;
        }
        this.realSize = len;
    }

    public ByteList(ByteList wrap, int index, int len) {
        this(wrap.bytes, wrap.begin + index, len);
    }

    private ByteList(boolean flag) {
    }

    public void delete(int start, int len) {
        this.realSize -= len;
        System.arraycopy(this.bytes, start + len, this.bytes, start, this.realSize);
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.realSize++] = b;
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList dup = new ByteList(false);
        dup.bytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, dup.bytes, 0, this.realSize);
        dup.realSize = this.realSize;
        dup.begin = 0;
        dup.validHash = this.validHash;
        dup.hash = this.hash;
        dup.stringValue = this.stringValue;
        return dup;
    }

    public ByteList makeShared(int index, int len) {
        ByteList shared = new ByteList(false);
        shared.bytes = this.bytes;
        shared.realSize = len;
        shared.begin = this.begin + index;
        return shared;
    }

    public void view(int index, int len) {
        this.realSize = len;
        this.begin += index;
    }

    public void unshare() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        this.bytes = newBytes;
        this.begin = 0;
    }

    public void invalidate() {
        this.validHash = false;
        this.stringValue = null;
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = b;
        ++this.realSize;
    }

    public void append(byte[] moreBytes) {
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, moreBytes.begin, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index, int len) {
        this.append(moreBytes.bytes, moreBytes.begin + index, len);
    }

    public void append(byte[] moreBytes, int start, int len) {
        this.grow(len);
        System.arraycopy(moreBytes, start, this.bytes, this.realSize, len);
        this.realSize += len;
    }

    @Override
    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int get(int index) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.begin + index];
    }

    public void set(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[this.begin + index] = (byte)b;
    }

    public void replace(byte[] newBytes) {
        if (newBytes == null) {
            throw new NullPointerException("Invalid argument: replacing with null array");
        }
        this.bytes = newBytes;
        this.realSize = newBytes.length;
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index, int count) {
        this.grow(count - len);
        int newSize = this.realSize + count - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count, this.realSize - (len + beg));
        System.arraycopy(nbytes, index, this.bytes, beg, count);
        this.realSize = newSize;
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index, int count) {
        if (len - beg > this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafeReplace(beg, len, nbytes, index, count);
    }

    public void insert(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.grow(1);
        System.arraycopy(this.bytes, index, this.bytes, index + 1, this.realSize - index);
        this.bytes[index] = (byte)b;
        ++this.realSize;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos += this.begin;
        while (pos < size && buf[pos] != b) {
            ++pos;
        }
        return pos < size ? pos - this.begin : -1;
    }

    public int indexOf(ByteList find) {
        return this.indexOf(find, 0);
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(ByteList find, int pos) {
        len = find.realSize;
        if (len == 0) {
            return -1;
        }
        first = find.bytes[find.begin];
        buf = this.bytes;
        max = this.realSize - len + 1;
        ** GOTO lbl19
        {
            ++pos;
            do {
                if (pos < max && buf[this.begin + pos] != first) continue block0;
                if (pos == max) {
                    return -1;
                }
                index = len;
                while (--index >= 0 && buf[this.begin + index + pos] == find.bytes[find.begin + index]) {
                }
                if (index < 0) {
                    return pos;
                }
                ++pos;
lbl19:
                // 2 sources

            } while (pos < max);
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.realSize - 1);
    }

    public int lastIndexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos = (pos += this.begin) >= size ? size : ++pos;
        while (--pos >= this.begin && buf[pos] != b) {
        }
        return pos - this.begin;
    }

    public int lastIndexOf(ByteList find) {
        return this.lastIndexOf(find, this.realSize - 1);
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(ByteList find, int pos) {
        len = find.realSize;
        if (len == 0) {
            return -1;
        }
        first = find.bytes[find.begin];
        buf = this.bytes;
        pos = Math.min(pos, this.realSize - len);
        ** GOTO lbl19
        {
            --pos;
            do {
                if (pos >= 0 && buf[this.begin + pos] != first) continue block0;
                if (pos < 0) {
                    return -1;
                }
                index = len;
                while (--index >= 0 && buf[this.begin + index + pos] == find.bytes[find.begin + index]) {
                }
                if (index < 0) {
                    return pos;
                }
                --pos;
lbl19:
                // 2 sources

            } while (pos >= 0);
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        if (this.validHash && other.validHash && this.hash != other.hash) {
            return false;
        }
        int last = this.realSize;
        if (last == other.realSize) {
            byte[] buf = this.bytes;
            int first = -1;
            while (--last > first && buf[this.begin + last] == other.bytes[other.begin + last] && ++first < last && buf[this.begin + first] == other.bytes[other.begin + first]) {
            }
            return first >= last;
        }
        return false;
    }

    public boolean sample_equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            int size = this.realSize;
            if (size == b.realSize) {
                byte[] buf = this.bytes;
                int first = -1;
                int last = size + 1 & 0xFFFFFFFE;
                while ((last -= 2) >= 0 && buf[this.begin + last] == b.bytes[b.begin + last] && (first += 2) < size && buf[this.begin + first] == b.bytes[b.begin + first]) {
                }
                return last < 0 || first == size;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this || this.bytes == other.bytes) {
            return 0;
        }
        int size = this.realSize;
        int len = Math.min(size, other.realSize);
        int offset = -1;
        while (++offset < len && this.bytes[this.begin + offset] == other.bytes[other.begin + offset]) {
        }
        if (offset < len) {
            return (this.bytes[this.begin + offset] & 0xFF) > (other.bytes[other.begin + offset] & 0xFF) ? 1 : -1;
        }
        return size == other.realSize ? 0 : (size == len ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (this.bytes.length < newSize) {
            byte[] newBytes = new byte[(int)((double)newSize * 1.5)];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
            this.bytes = newBytes;
        }
    }

    public int hashCode() {
        if (this.validHash) {
            return this.hash;
        }
        int key = 0;
        int index = this.begin;
        int end = this.begin + this.realSize;
        while (index < end) {
            key = (key << 16) + (key << 6) - key + this.bytes[index++];
        }
        key += key >> 5;
        this.validHash = true;
        this.hash = key;
        return this.hash;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = new String(ByteList.plain(this.bytes, this.begin, this.realSize));
        }
        return this.stringValue;
    }

    public static ByteList create(CharSequence s) {
        return new ByteList(ByteList.plain(s), false);
    }

    public static byte[] plain(CharSequence s) {
        if (s instanceof String) {
            try {
                return ((String)s).getBytes("ISO8859-1");
            }
            catch (Exception exception) {}
        }
        byte[] bytes = new byte[s.length()];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)s.charAt(i);
            ++i;
        }
        return bytes;
    }

    public static byte[] plain(char[] s) {
        byte[] bytes = new byte[s.length];
        int i = 0;
        while (i < s.length) {
            bytes[i] = (byte)s[i];
            ++i;
        }
        return bytes;
    }

    public static char[] plain(byte[] b, int start, int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(b[start + i] & 0xFF);
            ++i;
        }
        return chars;
    }

    public static char[] plain(byte[] b) {
        char[] chars = new char[b.length];
        int i = 0;
        while (i < b.length) {
            chars[i] = (char)(b[i] & 0xFF);
            ++i;
        }
        return chars;
    }

    @Override
    public char charAt(int ix) {
        return (char)(this.bytes[this.begin + ix] & 0xFF);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new ByteList(this, start, end - start);
    }
}

