/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal.nodes;

import java.util.List;
import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRequireNode;

public class FormatterRootNode
extends FormatterBlockNode {
    public FormatterRootNode(IFormatterDocument document) {
        super(document);
    }

    protected void acceptNodes(List<IFormatterNode> nodes, IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean wasRequire = false;
        for (IFormatterNode node : nodes) {
            context.enter(node);
            if (node instanceof FormatterRequireNode) {
                if (wasRequire) {
                    context.setBlankLines(0);
                }
            } else if (wasRequire && (node instanceof IFormatterContainerNode || !FormatterUtils.isEmptyText((IFormatterNode)node))) {
                context.setBlankLines(this.getInt("line.file.require.after"));
                wasRequire = false;
            }
            node.accept(context, visitor);
            context.leave(node);
            if (!(node instanceof FormatterRequireNode)) continue;
            wasRequire = true;
        }
    }
}

