/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

public class WhileNode
extends Node {
    static final long serialVersionUID = -5355364190446060873L;
    protected final Node conditionNode;
    protected final Node bodyNode;
    private final boolean evaluateAtStart;
    private final ISourcePositionHolder keyword;
    private final ISourcePositionHolder end;

    public ISourcePositionHolder getEnd() {
        return this.end;
    }

    public ISourcePositionHolder getKeyword() {
        return this.keyword;
    }

    public WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode, ISourcePositionHolder keyword, ISourcePositionHolder end) {
        this(position, conditionNode, bodyNode, true, keyword, end);
    }

    protected WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart, ISourcePositionHolder keyword, ISourcePositionHolder end) {
        super(position, 94);
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evalAtStart;
        this.keyword = keyword;
        this.end = end;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }

    public List childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }

    public boolean isBlock() {
        return true;
    }

    public static class Inline
    extends WhileNode {
        public Inline(ISourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart, ISourcePositionHolder keyword) {
            super(position, conditionNode, bodyNode, evalAtStart, keyword, null);
        }

        public boolean isBlock() {
            return false;
        }

        public List childNodes() {
            return Node.createList(this.bodyNode, this.conditionNode);
        }
    }
}

