/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptSpawnpoint
extends ScriptLineBreakpoint
implements IScriptSpawnpoint {
    private static final String[] UPDATABLE_ATTRS = new String[]{"lineNumber", "org.eclipse.debug.core.enabled"};

    @Override
    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptSpawnpointMarker";
    }

    public ScriptSpawnpoint() {
    }

    public ScriptSpawnpoint(final String debugModelId, final IResource resource, final IPath path, final int lineNumber, final int charStart, final int charEnd, final boolean register) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ScriptSpawnpoint.this.setMarker(resource.createMarker(ScriptSpawnpoint.this.getMarkerId()));
                HashMap attributes = new HashMap();
                ScriptSpawnpoint.this.addScriptBreakpointAttributes(attributes, debugModelId, true);
                ScriptSpawnpoint.this.addLineBreakpointAttributes(attributes, path, lineNumber, charStart, charEnd);
                ScriptSpawnpoint.this.ensureMarker().setAttributes(attributes);
                ScriptSpawnpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    @Override
    public String[] getUpdatableAttributes() {
        return UPDATABLE_ATTRS;
    }
}

