/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.launchConfigurations.CommonScriptLaunchTab;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListener;
import org.eclipse.dltk.debug.ui.messages.ScriptLaunchMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IInterpreterComboBlockContext;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpreterDescriptor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptLaunchConfigurationConstants;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class InterpreterTab
extends CommonScriptLaunchTab {
    protected AbstractInterpreterComboBlock fInterpreterBlock;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected boolean fUseDynamicArea = true;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;
    protected boolean fIsInitializing = false;
    private final IMainLaunchConfigurationTab fMainTab;
    private IPropertyChangeListener fCheckListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            InterpreterTab.this.handleSelectedInterpreterChanged();
        }
    };
    protected static final String EMPTY_STRING = "";
    private IMainLaunchConfigurationTabListener mainListener = null;
    private final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

    public InterpreterTab(IMainLaunchConfigurationTab mainTab) {
        this.fMainTab = mainTab;
    }

    protected IMainLaunchConfigurationTab getMainTab() {
        return this.fMainTab;
    }

    public void dispose() {
        super.dispose();
        this.registry.dispose();
        if (this.fInterpreterBlock != null) {
            this.fInterpreterBlock.removePropertyChangeListener(this.fCheckListener);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topComp = new Composite(parent, 0);
        this.setControl((Control)topComp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        topComp.setFont(font);
        this.fInterpreterBlock = this.createInterpreterBlock(this.createInterpreterBlockHost());
        if (this.mainListener == null) {
            this.mainListener = new MainListener();
            this.getMainTab().addListener(this.mainListener);
        }
        this.fInterpreterBlock.setDefaultInterpreterDescriptor(this.getDefaultInterpreterDescriptor());
        this.fInterpreterBlock.setSpecificInterpreterDescriptor(this.getSpecificInterpreterDescriptor());
        this.fInterpreterBlock.createControl(topComp);
        Control control = this.fInterpreterBlock.getControl();
        this.fInterpreterBlock.addPropertyChangeListener(this.fCheckListener);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        Composite dynTabComp = new Composite(topComp, 0);
        dynTabComp.setFont(font);
        this.setDynamicTabHolder(dynTabComp);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void refreshInterpreters() {
        this.fInterpreterBlock.refreshInterpreters();
    }

    private IInterpreterComboBlockContext createInterpreterBlockHost() {
        return new IInterpreterComboBlockContext(){

            public int getMode() {
                return 1;
            }

            public IEnvironment getEnvironment() {
                IScriptProject project = InterpreterTab.this.getScriptProject();
                if (project != null) {
                    return EnvironmentManager.getEnvironment((IModelElement)project);
                }
                return EnvironmentManager.getLocalEnvironment();
            }

            public String getNatureId() {
                return InterpreterTab.this.fMainTab.getNatureID();
            }
        };
    }

    protected AbstractInterpreterComboBlock createInterpreterBlock(IInterpreterComboBlockContext context) {
        return new AbstractInterpreterComboBlock(context);
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fIsInitializing = true;
        this.getControl().setRedraw(false);
        this.setLaunchConfiguration(configuration);
        this.updateInterpreterFromConfig(configuration);
        this.fInterpreterBlock.setDefaultInterpreterDescriptor(this.getDefaultInterpreterDescriptor());
        this.fInterpreterBlock.refreshInterpreters();
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(configuration);
        }
        this.getControl().setRedraw(true);
        this.fIsInitializing = false;
    }

    protected final String getNature() {
        return this.fMainTab.getNatureID();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nature", this.getNature());
        if (this.fInterpreterBlock.isDefaultInterpreter()) {
            configuration.setAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        } else {
            IPath containerPath = this.fInterpreterBlock.getInterpreterPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, portablePath);
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab == null) {
            configuration.setAttribute("interpreterTypeSpecificAttrs", null);
        } else {
            dynamicTab.performApply(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IStatus status = this.fInterpreterBlock.getStatus();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public String getName() {
        return ScriptLaunchMessages.InterpreterTab__Interp_1;
    }

    public Image getImage() {
        return this.registry.get(DLTKPluginImages.DESC_OBJS_NATIVE_LIB_PATH_ATTRIB);
    }

    protected void updateInterpreterFromConfig(ILaunchConfiguration config) {
        try {
            String path = config.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
            if (path != null) {
                this.fInterpreterBlock.setPath(Path.fromPortableString((String)path));
                return;
            }
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
        }
        this.fInterpreterBlock.setUseDefaultInterpreter();
    }

    protected void handleSelectedInterpreterChanged() {
        this.loadDynamicInterpreterArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (!this.fIsInitializing && wc != null) {
                wc.setAttribute("interpreterTypeSpecificAttrs", null);
            }
        } else {
            if (wc == null) {
                try {
                    wc = this.getLaunchConfiguration().isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration()).getOriginal().getWorkingCopy() : this.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException e) {
                    DLTKDebugUIPlugin.errorDialog(ScriptLaunchMessages.InterpreterTab_Unable_to_initialize_defaults_for_selected_InterpreterEnvironment_1, e);
                    return;
                }
            }
            if (!this.fIsInitializing) {
                this.getDynamicTab().setDefaults(wc);
                this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void selectInterpreter(String typeID, String InterpreterName) {
        if (typeID == null) {
            this.fInterpreterBlock.setUseDefaultInterpreter();
        } else {
            this.fInterpreterBlock.setPath(ScriptRuntime.newInterpreterContainerPath((String)typeID, (String)InterpreterName));
        }
    }

    protected ILaunchConfigurationTab getTabForCurrentInterpreter() {
        IInterpreterInstall Interpreter;
        IPath path = this.fInterpreterBlock.getInterpreterPath();
        if (path != null && (Interpreter = this.fInterpreterBlock.getInterpreter()) != null) {
            String InterpreterInstallTypeID = Interpreter.getInterpreterInstallType().getId();
            return DLTKDebugUIPlugin.getDefault().getInterpreterInstallTypePage(InterpreterInstallTypeID);
        }
        return null;
    }

    protected void loadDynamicInterpreterArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.isUseDynamicInterpreterArea()) {
            this.setDynamicTab(this.getTabForCurrentInterpreter());
            if (this.getDynamicTab() == null) {
                return;
            }
            this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.getDynamicTab().createControl(this.getDynamicTabHolder());
            this.getDynamicTabHolder().layout();
        }
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    public void setInterpreterSpecificArgumentsVisible(boolean visible) {
        this.fUseDynamicArea = visible;
    }

    protected boolean isUseDynamicInterpreterArea() {
        return this.fUseDynamicArea;
    }

    protected InterpreterDescriptor getDefaultInterpreterDescriptor() {
        return new InterpreterDescriptor(){

            public String getDescription() {
                IScriptProject project = InterpreterTab.this.getScriptProject();
                String name = ScriptLaunchMessages.InterpreterTab_7;
                if (!this.isValid(project)) {
                    IInterpreterInstall interpreter = this.getWorkspaceInterpreter(project);
                    if (interpreter != null) {
                        name = interpreter.getName();
                    }
                    return NLS.bind((String)ScriptLaunchMessages.InterpreterTab_8, (Object)name);
                }
                IInterpreterInstall interpreter = this.getProjectInterpreter(project);
                if (interpreter != null) {
                    name = interpreter.getName();
                }
                return NLS.bind((String)ScriptLaunchMessages.InterpreterTab_9, (Object)name);
            }

            private boolean isValid(IScriptProject project) {
                return project != null && project.getProject().isAccessible();
            }

            private IInterpreterInstall getProjectInterpreter(IScriptProject project) {
                try {
                    return ScriptRuntime.getInterpreterInstall((IScriptProject)project);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }

            private IInterpreterInstall getWorkspaceInterpreter(IScriptProject project) {
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                return ScriptRuntime.getDefaultInterpreterInstall((String)InterpreterTab.this.getNature(), (IEnvironment)environment);
            }

            public IInterpreterInstall getInterpreter() {
                IScriptProject project = InterpreterTab.this.getScriptProject();
                if (!this.isValid(project)) {
                    return this.getWorkspaceInterpreter(project);
                }
                return this.getProjectInterpreter(project);
            }
        };
    }

    protected InterpreterDescriptor getSpecificInterpreterDescriptor() {
        return null;
    }

    protected IScriptProject getScriptProject() {
        return this.fMainTab.getProject();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fInterpreterBlock.refresh();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private class MainListener
    implements IMainLaunchConfigurationTabListener {
        private MainListener() {
        }

        public void projectChanged(IProject project) {
            InterpreterTab.this.refreshInterpreters();
        }

        public void interactiveChanged(boolean state) {
        }
    }
}

