/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ITypeHierarchyBuilder;
import org.eclipse.dltk.utils.NatureExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHierarchyBuilders
extends NatureExtensionManager<ITypeHierarchyBuilder> {
    private static TypeHierarchyBuilders INSTANCE = null;

    private static synchronized TypeHierarchyBuilders get() {
        if (INSTANCE == null) {
            INSTANCE = new TypeHierarchyBuilders();
        }
        return INSTANCE;
    }

    public TypeHierarchyBuilders() {
        super("org.eclipse.dltk.core.typeHierarchy", ITypeHierarchyBuilder.class);
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, ITypeHierarchy.Mode mode, IProgressMonitor monitor) {
        ITypeHierarchyBuilder[] builders;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null && (builders = (ITypeHierarchyBuilder[])TypeHierarchyBuilders.get().getInstances(toolkit.getNatureId())) != null) {
            ITypeHierarchyBuilder[] iTypeHierarchyBuilderArray = builders;
            int n = builders.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeHierarchyBuilder builder = iTypeHierarchyBuilderArray[n2];
                ITypeHierarchy hierarchy = builder.build(type, mode, monitor);
                if (hierarchy != null) {
                    return hierarchy;
                }
                ++n2;
            }
        }
        return null;
    }
}

