/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatterControlManager
implements IFormatterControlManager,
IStatusChangeListener {
    private final IPreferenceDelegate<String> delegate;
    private final ControlBindingManager<String> bindingManager;
    private final IStatusChangeListener listener;
    private final Map<Control, Label> labelAssociations = new HashMap<Control, Label>();
    private final ListenerList initListeners = new ListenerList();
    private boolean initialization;

    public FormatterControlManager(IPreferenceDelegate<String> delegate, IStatusChangeListener listener) {
        this.delegate = delegate;
        this.bindingManager = new ControlBindingManager<String>(delegate, this);
        this.listener = listener;
    }

    @Override
    public Button createCheckbox(Composite parent, String key, String text) {
        return this.createCheckbox(parent, key, text, 1);
    }

    @Override
    public Button createCheckbox(Composite parent, String key, String text, int hspan) {
        Button button = SWTFactory.createCheckButton(parent, text, null, false, hspan);
        this.bindingManager.bindControl(button, key, null);
        return button;
    }

    @Override
    public Combo createCombo(Composite parent, String key, String label, String[] items) {
        Label labelControl = SWTFactory.createLabel(parent, label, 1);
        Combo combo = SWTFactory.createCombo(parent, 2056, 1, items);
        this.bindingManager.bindControl(combo, key);
        this.registerAssociatedLabel((Control)combo, labelControl);
        return combo;
    }

    @Override
    public Combo createCombo(Composite parent, String key, String label, String[] itemValues, String[] itemLabels) {
        Label labelControl = SWTFactory.createLabel(parent, label, 1);
        Combo combo = SWTFactory.createCombo(parent, 2056, 1, itemLabels);
        this.bindingManager.bindControl(combo, key, itemValues);
        this.registerAssociatedLabel((Control)combo, labelControl);
        return combo;
    }

    @Override
    public Text createNumber(Composite parent, String key, String label) {
        Label labelControl = SWTFactory.createLabel(parent, label, 1);
        Text text = SWTFactory.createText(parent, 2048, 1, "");
        this.bindingManager.bindControl(text, key, FieldValidators.POSITIVE_NUMBER_VALIDATOR);
        this.registerAssociatedLabel((Control)text, labelControl);
        return text;
    }

    private void registerAssociatedLabel(Control control, Label label) {
        this.labelAssociations.put(control, label);
    }

    @Override
    public void enableControl(Control control, boolean enabled) {
        control.setEnabled(enabled);
        Label label = this.labelAssociations.get(control);
        if (label != null) {
            label.setEnabled(enabled);
        }
    }

    @Override
    public void addInitializeListener(IFormatterControlManager.IInitializeListener listener) {
        this.initListeners.add((Object)listener);
    }

    @Override
    public void removeInitializeListener(IFormatterControlManager.IInitializeListener listener) {
        this.initListeners.remove((Object)listener);
    }

    public void initialize() {
        this.initialization = true;
        try {
            this.bindingManager.initialize();
            Object[] listeners = this.initListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IFormatterControlManager.IInitializeListener)listeners[i]).initialize();
                ++i;
            }
        }
        finally {
            this.initialization = false;
        }
        this.listener.statusChanged(this.bindingManager.getStatus());
    }

    @Override
    public void statusChanged(IStatus status) {
        if (!this.initialization) {
            this.listener.statusChanged(status);
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return this.delegate.getBoolean(key);
    }

    @Override
    public String getString(String key) {
        return this.delegate.getString(key);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.delegate.setBoolean(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.delegate.setString(key, value);
    }
}

