/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup.containers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class BuildpathContainerSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = "org.eclipse.dltk.launching.sourceContainer.buildpathContainer";
    private String libraryPath;

    public BuildpathContainerSourceContainer(String location) {
        this.libraryPath = location;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        if (name.indexOf(this.libraryPath) == -1) {
            return new Object[0];
        }
        try {
            IProject project;
            IScriptProject prj;
            IDLTKSearchScope scope;
            HandleFactory fac;
            Openable op;
            ILaunchConfiguration configuration = this.getDirector().getLaunchConfiguration();
            String projectName = configuration.getAttribute("project", null);
            if (projectName != null && (op = (fac = new HandleFactory()).createOpenable(name, scope = SearchEngine.createSearchScope((IModelElement)(prj = DLTKCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))))))) != null && op.exists() && op instanceof IStorage) {
                return new Object[]{op};
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new Object[0];
    }

    public String getName() {
        return this.libraryPath;
    }

    public ISourceContainerType getType() {
        return null;
    }
}

