/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.DbFactory;
import org.eclipse.dltk.core.index.sql.File;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.SqlIndex;
import org.eclipse.dltk.core.index2.AbstractIndexer;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.index.sql.SqlSearchEngine;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlIndexer
extends AbstractIndexer {
    private Connection connection;
    private File file;
    private String natureId;
    private IElementDao elementDao = DbFactory.getInstance().getElementDao();

    public void addDeclaration(IIndexingRequestor.DeclarationInfo info) {
        try {
            this.elementDao.insert(this.connection, info.elementType, info.flags, info.offset, info.length, info.nameOffset, info.nameLength, info.elementName, info.metadata, info.doc, info.qualifier, info.parent, this.file.getId(), this.natureId, false);
        }
        catch (SQLException e) {
            SqlIndex.error("An exception was thrown while inserting model element declaration", e);
        }
    }

    public void addReference(IIndexingRequestor.ReferenceInfo info) {
        try {
            this.elementDao.insert(this.connection, info.elementType, 0, info.offset, info.length, 0, 0, info.elementName, info.metadata, null, info.qualifier, null, this.file.getId(), this.natureId, true);
        }
        catch (SQLException e) {
            SqlIndex.error("An exception was thrown while inserting model element reference", e);
        }
    }

    public void indexDocument(ISourceModule sourceModule) {
        IFileHandle fileHandle = EnvironmentPathUtils.getFile((IModelElement)sourceModule);
        try {
            DbFactory dbFactory = DbFactory.getInstance();
            this.connection = dbFactory.createConnection();
            try {
                this.connection.setAutoCommit(false);
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)sourceModule);
                if (toolkit == null) {
                    return;
                }
                this.natureId = toolkit.getNatureId();
                IPath containerPath = sourceModule instanceof SourceModule ? sourceModule.getScriptProject().getPath() : sourceModule.getAncestor(3).getPath();
                Container container = dbFactory.getContainerDao().insert(this.connection, containerPath.toString());
                String relativePath = toolkit instanceof IDLTKLanguageToolkitExtension && ((IDLTKLanguageToolkitExtension)toolkit).isArchiveFileName(sourceModule.getPath().toString()) ? ((ExternalSourceModule)sourceModule).getFullPath().toString() : Util.relativePath((IPath)sourceModule.getPath(), (int)containerPath.segmentCount());
                long lastModified = fileHandle == null ? 0L : fileHandle.lastModified();
                File existing = dbFactory.getFileDao().select(this.connection, relativePath, container.getId());
                if (existing != null) {
                    if (existing.getTimestamp() == lastModified) {
                        return;
                    }
                    dbFactory.getFileDao().deleteById(this.connection, existing.getId());
                }
                this.file = dbFactory.getFileDao().insert(this.connection, relativePath, lastModified, container.getId());
                super.indexDocument(sourceModule);
            }
            finally {
                this.elementDao.commitInsertions();
                this.connection.commit();
                this.connection.close();
            }
        }
        catch (Exception e) {
            SqlIndex.error("An exception was thrown while indexing document", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Long> getDocuments(IPath containerPath) {
        try {
            DbFactory dbFactory = DbFactory.getInstance();
            Connection connection = dbFactory.createConnection();
            try {
                Container containerDao = dbFactory.getContainerDao().selectByPath(connection, containerPath.toString());
                if (containerDao == null) return null;
                File[] files = dbFactory.getFileDao().selectByContainerId(connection, containerDao.getId());
                HashMap<String, Long> paths = new HashMap<String, Long>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        HashMap<String, Long> hashMap = paths;
                        return hashMap;
                    }
                    File fileDao = fileArray[n2];
                    paths.put(fileDao.getPath(), fileDao.getTimestamp());
                    ++n2;
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            SqlIndex.error("An exception thrown while analyzing source module changes", e);
        }
        return null;
    }

    public void removeContainer(IPath containerPath) {
        try {
            DbFactory dbFactory = DbFactory.getInstance();
            Connection connection = dbFactory.createConnection();
            try {
                dbFactory.getContainerDao().deleteByPath(connection, containerPath.toString());
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            SqlIndex.error(NLS.bind((String)"An exception thrown while removing container ''{0}'' from index", (Object)containerPath.toString()), e);
        }
    }

    public void removeDocument(IPath containerPath, String relativePath) {
        try {
            DbFactory dbFactory = DbFactory.getInstance();
            Connection connection = dbFactory.createConnection();
            try {
                Container containerDao = dbFactory.getContainerDao().selectByPath(connection, containerPath.toString());
                if (containerDao != null) {
                    dbFactory.getFileDao().delete(connection, relativePath, containerDao.getId());
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            SqlIndex.error(NLS.bind((String)"An exception thrown while removing file ''{0}'' from index", (Object)containerPath.append(relativePath).toString()), e);
        }
    }

    public ISearchEngine createSearchEngine() {
        return new SqlSearchEngine();
    }
}

