/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.SourcePosition;

public class EnsureNode
extends Node {
    static final long serialVersionUID = -409805241533215981L;
    private final Node bodyNode;
    private final Keyword ensureNode;

    public EnsureNode(ISourcePosition position, Node bodyNode, Keyword ensureNode) {
        super(position, 35);
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Keyword getEnsureNode() {
        return this.ensureNode;
    }

    public List childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }

    public static class Keyword
    extends Node {
        private final ISourcePositionHolder keyword;
        private final Node statement;

        public Keyword(ISourcePositionHolder keyword, Node statement) {
            super(SourcePosition.combinePosition(keyword.getPosition(), statement.getPosition()), 201);
            this.keyword = keyword;
            this.statement = statement;
        }

        public Instruction accept(NodeVisitor visitor) {
            throw new RuntimeException(String.valueOf(this.getNodeName()) + " should never be evaluated");
        }

        public List childNodes() {
            return Keyword.createList(this.statement);
        }

        public ISourcePositionHolder getKeyword() {
            return this.keyword;
        }

        public Node getStatement() {
            return this.statement;
        }
    }
}

