/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;

public class StringAsserts {
    private static final int printRange = 6;

    private static int getDiffPos(String str1, String str2) {
        int len1 = Math.min(str1.length(), str2.length());
        int diffPos = -1;
        int i = 0;
        while (i < len1) {
            if (str1.charAt(i) != str2.charAt(i)) {
                diffPos = i;
                break;
            }
            ++i;
        }
        if (diffPos == -1 && str1.length() != str2.length()) {
            diffPos = len1;
        }
        return diffPos;
    }

    public static void assertEqualString(String actual, String expected) {
        int diffPos;
        if (actual == null || expected == null) {
            if (actual == expected) {
                return;
            }
            if (actual == null) {
                Assert.assertTrue((String)("Content not as expected: is 'null' expected: " + expected), (boolean)false);
            } else {
                Assert.assertTrue((String)("Content not as expected: expected 'null' is: " + actual), (boolean)false);
            }
        }
        if ((diffPos = StringAsserts.getDiffPos(actual, expected)) != -1) {
            int diffAhead = Math.max(0, diffPos - 6);
            int diffAfter = Math.min(actual.length(), diffPos + 6);
            String diffStr = String.valueOf(actual.substring(diffAhead, diffPos)) + '^' + actual.substring(diffPos, diffAfter);
            String message = "Content not as expected: is\n" + actual + "\nDiffers at pos " + diffPos + ": " + diffStr + "\nexpected:\n" + expected;
            Assert.assertEquals((String)message, (String)expected, (String)actual);
        }
    }

    public static void assertEqualStringIgnoreDelim(String actual, String expected) throws IOException {
        if (actual == null || expected == null) {
            if (actual == expected) {
                return;
            }
            if (actual == null) {
                Assert.assertTrue((String)("Content not as expected: is 'null' expected: " + expected), (boolean)false);
            } else {
                Assert.assertTrue((String)("Content not as expected: expected 'null' is: " + actual), (boolean)false);
            }
        }
        BufferedReader read1 = new BufferedReader(new StringReader(actual));
        BufferedReader read2 = new BufferedReader(new StringReader(expected));
        int line = 1;
        while (true) {
            String s1 = read1.readLine();
            String s2 = read2.readLine();
            if (s1 == null || !s1.equals(s2)) {
                if (s1 == null && s2 == null) {
                    return;
                }
                String diffStr = s1 == null ? s2 : s1;
                String message = "Content not as expected: Content is: \n" + actual + "\nDiffers at line " + line + ": " + diffStr + "\nExpected contents: \n" + expected;
                Assert.assertEquals((String)message, (String)expected, (String)actual);
            }
            ++line;
        }
    }

    public static void assertEqualStringsIgnoreOrder(String[] actuals, String[] expecteds) {
        int n2;
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(actuals));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList(expecteds));
        int i = list1.size() - 1;
        while (i >= 0) {
            if (list2.remove(list1.get(i))) {
                list1.remove(i);
            }
            --i;
        }
        int n1 = list1.size();
        if (n1 + (n2 = list2.size()) > 0) {
            if (n1 == 1 && n2 == 1) {
                StringAsserts.assertEqualString(list1.get(0), list2.get(0));
            }
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < n1) {
                String s1 = list1.get(i2);
                if (s1 != null) {
                    buf.append(s1);
                    buf.append("\n");
                }
                ++i2;
            }
            String actual = buf.toString();
            buf = new StringBuffer();
            int i3 = 0;
            while (i3 < n2) {
                String s2 = list2.get(i3);
                if (s2 != null) {
                    buf.append(s2);
                    buf.append("\n");
                }
                ++i3;
            }
            String expected = buf.toString();
            String message = "Content not as expected: Content is: \n" + actual + "\nExpected contents: \n" + expected;
            Assert.assertEquals((String)message, (String)expected, (String)actual);
        }
    }

    public static void assertExpectedExistInProposals(String[] actuals, String[] expecteds) {
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(actuals));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList(expecteds));
        int i = list1.size() - 1;
        while (i >= 0) {
            if (list2.remove(list1.get(i))) {
                list1.remove(i);
            }
            --i;
        }
        int n1 = list1.size();
        int n2 = list2.size();
        if (n2 > 0) {
            if (n1 == 1 && n2 == 1) {
                StringAsserts.assertEqualString(list1.get(0), list2.get(0));
            }
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < n1) {
                String s1 = list1.get(i2);
                if (s1 != null) {
                    buf.append(s1);
                    buf.append("\n");
                }
                ++i2;
            }
            String actual = buf.toString();
            buf = new StringBuffer();
            int i3 = 0;
            while (i3 < n2) {
                String s2 = list2.get(i3);
                if (s2 != null) {
                    buf.append(s2);
                    buf.append("\n");
                }
                ++i3;
            }
            String expected = buf.toString();
            String message = "Content not as expected: Content is: \n" + actual + "\nExpected contents: \n" + expected;
            Assert.assertEquals((String)message, (String)expected, (String)actual);
        }
    }
}

