/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.internal.parser.TclSourceParser;
import org.eclipse.dltk.utils.CorePrinter;

public class TclBlockExpression
extends Expression {
    private String fBlockContent;
    private char[] fileName = null;

    public TclBlockExpression(int start, int end, String content) {
        this.setStart(start);
        this.setEnd(end);
        this.fBlockContent = content;
    }

    public int getKind() {
        return 10003;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            List statements = this.parseBlock();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    ASTNode node = (ASTNode)statements.get(i);
                    node.traverse(visitor);
                    ++i;
                }
            }
            visitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("tcl block:" + this.fBlockContent);
    }

    public String toString() {
        return "tcl block:" + this.fBlockContent;
    }

    public List parseBlock() {
        return this.parseBlock(this.sourceStart() + 1);
    }

    public List parseBlock(int startFrom) {
        if (this.fBlockContent == null) {
            return null;
        }
        String content = this.fBlockContent.substring(1, this.fBlockContent.length() - 1);
        TclSourceParser parser = null;
        try {
            parser = (TclSourceParser)DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return new ArrayList();
        }
        parser.setCurrentPosition(startFrom);
        ModuleDeclaration module = parser.parse(this.fileName, content.toCharArray(), null);
        return module.getStatements();
    }

    public String getBlock() {
        return this.fBlockContent;
    }

    public void setFilename(char[] fileName) {
        this.fileName = fileName;
    }
}

