/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.internal.tclchecker.TclChecker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMarker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerNature;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;

public class TclCheckerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.dltk.tcl.tclchecker.tclcheckerbuilder";
    private static final String JOB_NAME = "Checking with TclChecker";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            ArrayList resource = new ArrayList();
            this.getProject().accept((IResourceVisitor)new ResourceVisitor(resource));
            this.runTclChecker(resource);
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ArrayList reources = new ArrayList();
        delta.accept((IResourceDeltaVisitor)new ResourceVisitor(reources));
        this.runTclChecker(reources);
    }

    protected void runTclChecker(List resources) throws CoreException {
        ArrayList<IModelElement> sourceModules = new ArrayList<IModelElement>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            IModelElement element = DLTKCore.create((IResource)((IResource)it.next()));
            if (!(element instanceof ISourceModule)) continue;
            sourceModules.add(element);
        }
        TclChecker checker = new TclChecker(TclCheckerPlugin.getDefault().getPreferenceStore());
        if (!checker.canCheck()) {
            TclCheckerNature.removeNature(this.getProject());
            TclCheckerMarker.clearMarkers(this.getProject());
            return;
        }
        checker.check(sourceModules, JOB_NAME, false);
    }

    class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private List resources;

        public ResourceVisitor(List resources) {
            this.resources = resources;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    this.resources.add(resource);
                    break;
                }
                case 4: {
                    this.resources.add(resource);
                }
            }
            return true;
        }

        public boolean visit(IResource resource) {
            this.resources.add(resource);
            return true;
        }
    }
}

