/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropAdapter;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;

class FileTransferDropAdapter
extends DLTKViewerDropAdapter
implements TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer, 24);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IModelElement || target instanceof IResource;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        boolean isScriptFolder = target instanceof IScriptFolder;
        boolean isScriptProject = target instanceof IScriptProject;
        boolean isProjectFragment = target instanceof IProjectFragment;
        boolean isContainer = target instanceof IContainer;
        if (!(isScriptFolder || isScriptProject || isProjectFragment || isContainer)) {
            return;
        }
        if (isContainer) {
            IContainer container = (IContainer)target;
            if (container.isAccessible() && !Resources.isReadOnly((IResource)container)) {
                event.detail = 1;
            }
        } else {
            IModelElement element = (IModelElement)target;
            if (!element.isReadOnly()) {
                event.detail = 1;
            }
        }
    }

    public void drop(Object dropTarget, final DropTargetEvent event) {
        try {
            int operation = event.detail;
            event.detail = 0;
            final Object data = event.data;
            if (data == null || !(data instanceof String[]) || operation != 1) {
                return;
            }
            final IContainer target = this.getActualTarget(dropTarget);
            if (target == null) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    FileTransferDropAdapter.this.getShell().forceActive();
                    new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])data, target);
                    event.detail = 1;
                }
            });
        }
        catch (ModelException e) {
            String title = ScriptMessages.DropAdapter_errorTitle;
            String message = ScriptMessages.DropAdapter_errorMessage;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
        }
    }

    private IContainer getActualTarget(Object dropTarget) throws ModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IModelElement) {
            return this.getActualTarget(((IModelElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

