/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import org.eclipse.dltk.dbgp.internal.DbgpTermination;

public abstract class DbgpWorkingThread
extends DbgpTermination {
    private Thread thread;
    private final String name;

    public DbgpWorkingThread(String name) {
        this.name = name;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            throw new IllegalStateException("Thread already started");
        }
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    DbgpWorkingThread.this.workingCycle();
                }
                catch (Exception e) {
                    DbgpWorkingThread.this.fireObjectTerminated(e);
                    return;
                }
                DbgpWorkingThread.this.fireObjectTerminated(null);
            }
        }, this.name);
        this.thread.start();
    }

    public void requestTermination() {
        this.thread.interrupt();
    }

    public void waitTerminated() throws InterruptedException {
        this.thread.join();
    }

    protected abstract void workingCycle() throws Exception;
}

