/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpExtendedCommands
extends DbgpBaseCommands
implements IDbgpExtendedCommands {
    private static final String BREAK_COMMAND = "break";
    private static final String STDIN_COMMAND = "stdin";
    private static final String EVAL_COMMAND = "eval";
    private static final String EXEC_COMMAND = "exec";
    private static final String EXPR_COMMAND = "expr";

    private IDbgpProperty parseResponse(Element response) {
        if (DbgpXmlParser.parseSuccess(response)) {
            NodeList list = response.getElementsByTagName("property");
            return DbgpXmlEntityParser.parseProperty((Element)list.item(0));
        }
        return null;
    }

    public DbgpExtendedCommands(IDbgpCommunicator communicator) throws DbgpException {
        super(communicator);
    }

    public boolean makeBreak() throws DbgpException {
        return DbgpXmlParser.parseSuccess(this.communicate(this.createRequest(BREAK_COMMAND)));
    }

    public boolean configureStdin(int value) throws DbgpException {
        DbgpRequest request = this.createRequest(STDIN_COMMAND);
        request.addOption("-c", value);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    public boolean sendStdin(String data) throws DbgpException {
        DbgpRequest request = this.createRequest(STDIN_COMMAND);
        request.setData(data);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    public IDbgpProperty evaluate(String string) throws DbgpException {
        DbgpRequest request = this.createRequest(EVAL_COMMAND);
        request.setData(string);
        return this.parseResponse(this.communicate(request));
    }

    public IDbgpProperty expression(String expression) throws DbgpException {
        DbgpRequest request = this.createRequest(EXPR_COMMAND);
        request.setData(expression);
        return this.parseResponse(this.communicate(request));
    }

    public IDbgpProperty execute(String code) throws DbgpException {
        DbgpRequest request = this.createRequest(EXEC_COMMAND);
        request.setData(code);
        return this.parseResponse(this.communicate(request));
    }
}

