/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.compiler.env.IGenericType;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.NameLookup;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceTypeElementInfo;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyType;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.core.util.ResourceSourceModule;

public abstract class HierarchyBuilder {
    protected TypeHierarchy hierarchy;
    protected NameLookup nameLookup;
    protected Map infoToHandle;
    protected String focusQualifiedName;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws ModelException {
        ISourceModule[] unitsToLookInside;
        this.hierarchy = hierarchy;
        ScriptProject project = (ScriptProject)hierarchy.javaProject();
        IType focusType = hierarchy.getType();
        ISourceModule unitToLookInside = focusType == null ? null : focusType.getSourceModule();
        ISourceModule[] workingCopies = this.hierarchy.workingCopies;
        if (unitToLookInside != null) {
            int wcLength;
            int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
            if (wcLength == 0) {
                unitsToLookInside = new ISourceModule[]{unitToLookInside};
            } else {
                unitsToLookInside = new ISourceModule[wcLength + 1];
                unitsToLookInside[0] = unitToLookInside;
                System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
            }
        } else {
            unitsToLookInside = workingCopies;
        }
        if (project != null) {
            ISearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
            this.nameLookup = searchableEnvironment.getNameLookup();
        }
        this.infoToHandle = new HashMap(5);
        this.focusQualifiedName = focusType == null ? null : focusType.getFullyQualifiedName();
    }

    public abstract void build(boolean var1) throws ModelException, CoreException;

    protected void buildSupertypes() {
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    public void connect(IGenericType type, IType typeHandle, IType[] superclassHandles) {
        if (typeHandle == null) {
            return;
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((ModelElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.print("  superclassess:");
            if (superclassHandles == null || superclassHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                int i = 0;
                int length = superclassHandles.length;
                while (i < length) {
                    if (superclassHandles[i] != null) {
                        System.out.println("    " + ((ModelElement)((Object)superclassHandles[i])).toStringWithAncestors());
                    }
                    ++i;
                }
            }
        }
        if (superclassHandles == null) {
            this.hierarchy.addRootClass(typeHandle);
        } else {
            int q = 0;
            while (q < superclassHandles.length) {
                this.hierarchy.cacheSuperclass(typeHandle, superclassHandles[q]);
                ++q;
            }
        }
        if (superclassHandles == null) {
            superclassHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheFlags(typeHandle, type.getModifiers());
    }

    protected IType getHandle(IGenericType genericType) {
        if (genericType == null) {
            return null;
        }
        if (genericType instanceof HierarchyType) {
            IType handle = (IType)this.infoToHandle.get(genericType);
            if (handle == null) {
                handle = ((HierarchyType)genericType).typeHandle;
                this.infoToHandle.put(genericType, handle);
            }
            return handle;
        }
        if (genericType instanceof SourceTypeElementInfo) {
            IType handle = ((SourceTypeElementInfo)genericType).getHandle();
            return handle;
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    protected ISourceModule createCompilationUnitFromPath(Openable handle, IFile file) {
        final char[] elementName = handle.getElementName().toCharArray();
        return new ResourceSourceModule(file, file.getLocationURI()){

            public char[] getFileName() {
                return elementName;
            }
        };
    }
}

