/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class NewScriptProjectPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.xore.dltk.ui.preferences.BuildPathPreferencePage";
    private static final String SRCBIN_FOLDERS_IN_NEWPROJ = "com.xore.dltk.ui.wizards.srcBinFoldersInNewProjects";
    private static final String SRC_SRCNAME = "com.xore.dltk.ui.wizards.srcFoldersSrcName";
    private static String fgDefaultEncoding = System.getProperty("file.encoding");
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;
    private SelectionListener fSelectionListener;
    private ModifyListener fModifyListener;
    private Text fSrcFolderNameText;
    private Button fProjectAsSourceFolder;
    private Button fFoldersAsSourceFolder;
    private Label fSrcFolderNameLabel;

    public abstract IBuildpathEntry[] getDefaultLanguageLibrary();

    public static String decodeInterpreterEnvironmentLibraryDescription(String encoded) {
        int end = encoded.indexOf(32);
        if (end != -1) {
            return NewScriptProjectPreferencePage.decode(encoded.substring(0, end));
        }
        return "";
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            DLTKUIPlugin.log(e);
            return "";
        }
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            DLTKUIPlugin.log(e);
            return "";
        }
    }

    public static IBuildpathEntry[] decodeInterpreterEnvironmentLibraryBuildpathEntries(String encoded) {
        StringTokenizer tok = new StringTokenizer(encoded, " ");
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>();
        while (tok.hasMoreTokens()) {
            String message;
            try {
                tok.nextToken();
                int kind = Integer.parseInt(tok.nextToken());
                IPath path = NewScriptProjectPreferencePage.decodePath(tok.nextToken());
                boolean isExported = Boolean.valueOf(tok.nextToken());
                switch (kind) {
                    case 3: {
                        res.add(DLTKCore.newSourceEntry((IPath)path));
                        break;
                    }
                    case 1: {
                        res.add(DLTKCore.newLibraryEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 2: {
                        res.add(DLTKCore.newProjectEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 5: {
                        res.add(DLTKCore.newContainerEntry((IPath)path, (boolean)isExported));
                    }
                }
            }
            catch (NumberFormatException e) {
                message = PreferencesMessages.NewScriptProjectPreferencePage_error_decode;
                DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 4, message, (Throwable)e));
            }
            catch (NoSuchElementException e) {
                message = PreferencesMessages.NewScriptProjectPreferencePage_error_decode;
                DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 4, message, (Throwable)e));
            }
        }
        return res.toArray(new IBuildpathEntry[res.size()]);
    }

    public static String encodeInterpreterEnvironmentLibrary(String desc, IBuildpathEntry[] cpentries) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cpentries.length) {
            IBuildpathEntry entry = cpentries[i];
            buf.append(NewScriptProjectPreferencePage.encode(desc));
            buf.append(' ');
            buf.append(entry.getEntryKind());
            buf.append(' ');
            buf.append(NewScriptProjectPreferencePage.encodePath(entry.getPath()));
            buf.append(' ');
            buf.append(entry.isExported());
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static String encodePath(IPath path) {
        if (path == null) {
            return "#";
        }
        if (path.isEmpty()) {
            return "&";
        }
        return NewScriptProjectPreferencePage.encode(path.toPortableString());
    }

    private static IPath decodePath(String str) {
        if ("#".equals(str)) {
            return null;
        }
        if ("&".equals(str)) {
            return Path.EMPTY;
        }
        return Path.fromPortableString((String)NewScriptProjectPreferencePage.decode(str));
    }

    public NewScriptProjectPreferencePage() {
        this.setPreferenceStore(DLTKUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.NewScriptProjectPreferencePage_description);
        this.setTitle(PreferencesMessages.NewScriptProjectPreferencePage_title);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
        this.fSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewScriptProjectPreferencePage.this.controlChanged(e.widget);
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewScriptProjectPreferencePage.this.controlModified(e.widget);
            }
        };
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(SRCBIN_FOLDERS_IN_NEWPROJ, false);
        store.setDefault(SRC_SRCNAME, "src");
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setText(this.getPreferenceStore().getString(key));
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        this.fTextControls.add(text);
        return text;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group sourceFolderGroup = new Group(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        sourceFolderGroup.setLayout((Layout)layout);
        sourceFolderGroup.setLayoutData((Object)gd);
        sourceFolderGroup.setText(PreferencesMessages.NewScriptProjectPreferencePage_sourcefolder_label);
        int indent = 0;
        this.fProjectAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewScriptProjectPreferencePage_sourcefolder_project, SRCBIN_FOLDERS_IN_NEWPROJ, "false", indent);
        this.fProjectAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fFoldersAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewScriptProjectPreferencePage_sourcefolder_folder, SRCBIN_FOLDERS_IN_NEWPROJ, "true", indent);
        this.fFoldersAsSourceFolder.addSelectionListener(this.fSelectionListener);
        indent = this.convertWidthInCharsToPixels(4);
        this.fSrcFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fSrcFolderNameLabel.setText(PreferencesMessages.NewScriptProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fSrcFolderNameLabel, SRC_SRCNAME, indent);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        this.validateFolders();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void validateFolders() {
        boolean useFolders = this.fFoldersAsSourceFolder.getSelection();
        this.fSrcFolderNameText.setEnabled(useFolders);
        this.fSrcFolderNameLabel.setEnabled(useFolders);
        if (useFolders) {
            IStatus status;
            String srcName = this.fSrcFolderNameText.getText();
            if (srcName.length() == 0) {
                this.updateStatus(new StatusInfo(4, PreferencesMessages.NewScriptProjectPreferencePage_folders_error_namesempty));
                return;
            }
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            IProject dmy = workspace.getRoot().getProject("project");
            IPath srcPath = dmy.getFullPath().append(srcName);
            if (srcName.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
                String message = Messages.format(PreferencesMessages.NewScriptProjectPreferencePage_folders_error_invalidsrcname, status.getMessage());
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
            IBuildpathEntry entry = DLTKCore.newSourceEntry((IPath)srcPath);
            status = BuildpathEntry.validateBuildpath((IScriptProject)DLTKCore.create((IProject)dmy), (IBuildpathEntry[])new IBuildpathEntry[]{entry});
            if (!status.isOK()) {
                String message = PreferencesMessages.NewScriptProjectPreferencePage_folders_error_invalidcp;
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
        }
        this.updateStatus(new StatusInfo());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void controlChanged(Widget widget) {
        if (widget == this.fFoldersAsSourceFolder || widget == this.fProjectAsSourceFolder) {
            this.validateFolders();
        }
    }

    private void controlModified(Widget widget) {
        if (widget == this.fSrcFolderNameText) {
            this.validateFolders();
        }
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        this.validateFolders();
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        DLTKUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

