/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.ruby.core.PredefinedVariables;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.internal.ui.docs.RiHelper;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RubyDocumentationProvider
implements IScriptDocumentationProvider {
    protected String getLine(Document d, int line) throws BadLocationException {
        return d.get(d.getLineOffset(line), d.getLineLength(line));
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__ruby_string", "__ruby_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RubyPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__ruby_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__ruby_partitioning", null);
    }

    /*
     * Exception decompiling
     */
    public static String getHeaderComment(String contents, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 406->409)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getHeaderComment(IMember member) {
        ISourceModule sourceModule;
        IBuffer buf;
        int offset;
        block6: {
            ISourceRange range;
            block5: {
                if (member instanceof IField) {
                    return null;
                }
                try {
                    range = member.getSourceRange();
                    if (range != null) break block5;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            offset = range.getOffset();
            buf = null;
            sourceModule = member.getSourceModule();
            if (sourceModule.isConsistent()) break block6;
            return null;
        }
        buf = sourceModule.getBuffer();
        String contents = buf.getContents();
        return RubyDocumentationProvider.getHeaderComment(contents, offset);
    }

    private Reader proccessBuiltin(IMethod method) {
        String divider;
        try {
            divider = (method.getFlags() & 0x80) != 0 ? "::" : ".";
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
        IModelElement pp = method.getAncestor(7);
        if (pp.getElementName().startsWith("<<")) {
            pp = pp.getAncestor(7);
        }
        String keyword = String.valueOf(pp.getElementName()) + divider + method.getElementName();
        RiHelper helper = RiHelper.getInstance();
        String doc = helper.getDocFor(keyword);
        if ((doc.indexOf("Nothing known about") != -1 || doc.trim().length() == 0) && pp.getElementName().equals("Kernel")) {
            keyword = "Object" + divider + method.getElementName();
            doc = helper.getDocFor(keyword);
        }
        if (doc != null) {
            return new StringReader(doc);
        }
        return new StringReader("Built-in method");
    }

    public Reader getInfo(IMember member, boolean lookIntoParents, boolean lookIntoExternal) {
        FakeField field;
        String doc;
        if (member.getAncestor(3) instanceof BuiltinProjectFragment && member instanceof IMethod) {
            IMethod method = (IMethod)member;
            return this.proccessBuiltin(method);
        }
        if (member instanceof FakeField && (doc = PredefinedVariables.getDocOf((String)(field = (FakeField)member).getElementName())) != null) {
            return new StringReader(doc);
        }
        String header = this.getHeaderComment(member);
        if (header == null || header.length() == 0) {
            return null;
        }
        return new StringReader(this.convertToHTML(header));
    }

    private static String replaceSpecTag(String original, String sc, String tag) {
        Matcher matcher;
        String filtered = original;
        if (sc.equals("*") || sc.equals("+")) {
            sc = "\\" + sc;
        }
        Pattern bold = Pattern.compile(String.valueOf(sc) + "[_a-zA-Z0-9]+" + sc);
        while ((matcher = bold.matcher(filtered)).find()) {
            String startStr = filtered.substring(0, matcher.start());
            String endStr = filtered.substring(matcher.end());
            String grp = matcher.group();
            filtered = String.valueOf(startStr) + "<" + tag + ">" + grp.substring(1, grp.length() - 1) + "</" + tag + ">" + endStr;
        }
        return filtered;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String convertToHTML(String header) {
        if (header == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Document d = new Document(header);
        boolean enabled = true;
        int line = 0;
        while (true) {
            block14: {
                try {
                    String str = this.getLine(d, line).trim();
                    if (str == null) {
                        return result.toString();
                    }
                    if (str.startsWith("#--")) {
                        enabled = false;
                    } else if (str.startsWith("#++")) {
                        enabled = true;
                        break block14;
                    }
                    if (!enabled || str.startsWith("=begin") || str.startsWith("=end")) break block14;
                    while (true) {
                        if (str.length() <= 0 || !str.startsWith("#")) {
                            str = RubyDocumentationProvider.replaceSpecTag(str, "*", "b");
                            str = RubyDocumentationProvider.replaceSpecTag(str, "+", "tt");
                            str = RubyDocumentationProvider.replaceSpecTag(str, "_", "em");
                            str.replaceAll("\\*[_a-zA-Z0-9]+\\*", "");
                            if (str.length() != 0) break;
                            result.append("<p>");
                            break block14;
                        }
                        str = str.substring(1);
                    }
                    if (str.trim().startsWith("== ")) {
                        result.append("<h2>");
                        result.append(str.substring(3));
                        result.append("</h2>");
                        break block14;
                    }
                    if (str.trim().startsWith("= ")) {
                        result.append("<h1>");
                        result.append(str.substring(2));
                        result.append("</h1>");
                        break block14;
                    }
                    if (str.trim().startsWith("---")) {
                        result.append("<hr>");
                    } else {
                        result.append(String.valueOf(str) + "<br>");
                    }
                }
                catch (BadLocationException badLocationException) {
                    return result.toString();
                }
            }
            ++line;
        }
    }

    public Reader getInfo(String content) {
        return null;
    }
}

