/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.io.FileNotFoundException;
import java.net.URI;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.ai.scripteditor.util.TempFileUtil;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.ScriptListView;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SelectWAVFileTab
implements IUNIT {
    Composite ownComposite;
    private static SelectWAVFileTab ownInst = null;
    private static Shell instParentShell = null;
    private ScriptData instScriptData = null;
    private SoundMixer instSoundMixer = null;
    private int descriptionIndex = -1;
    private int descriptionStartTime = 0;
    private int descriptionEndTime = 0;
    private URI descriptionWavFile = null;
    private float descriptionCompetitiveRatio = 1.0f;
    private boolean currentStatAppend = true;
    private boolean currentModeAppend = true;
    private boolean currentStatDelete = true;
    private boolean currentStatPreview = true;
    private boolean currentSelWavFile = true;
    private Label textStartTime;
    private Label textEndTime;
    private Text textAreaWavInfo;
    private Button buttonWavAppend;
    private Button buttonWavDelete;
    private Button buttonWavPreview;
    private Button chkboxPlayWav;
    private Label labelPlayWav;
    private Label labelWSpeed;
    private Scale scaleWavSpeed;
    private boolean current_tab_mode = true;
    private Button buttonWavOpen;

    public SelectWAVFileTab(CTabFolder parent) {
        ownInst = this;
        this.initTab(parent);
    }

    public static SelectWAVFileTab getInstance() {
        return ownInst;
    }

    public void initTab(CTabFolder parent) {
        this.ownComposite = new Composite((Composite)parent, 0);
        this.instScriptData = ScriptData.getInstance();
        this.instSoundMixer = SoundMixer.getInstance();
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        instParentShell = display.getActiveShell();
        this.initGUI(display);
    }

    public void setFocus() {
        this.ownComposite.setFocus();
    }

    private FormData prepareFormData(int width, int height, int[] left, int[] top) {
        FormData tmpData = new FormData(-1, -1);
        tmpData.left = new FormAttachment(left[0], left[1], left[2]);
        tmpData.top = new FormAttachment(top[0], top[1], top[2]);
        return tmpData;
    }

    private void initGUI(Display parentDisp) {
        try {
            FormLayout groupSelWAVFileLayout = new FormLayout();
            FormData groupSelWAVFileLData = new FormData(925, 128);
            groupSelWAVFileLData.top = new FormAttachment(0, 1000, 0);
            groupSelWAVFileLData.left = new FormAttachment(0, 1000, 0);
            groupSelWAVFileLData.right = new FormAttachment(1000, 1000, 0);
            groupSelWAVFileLData.bottom = new FormAttachment(1000, 1000, 0);
            this.ownComposite.setLayoutData((Object)groupSelWAVFileLData);
            this.ownComposite.setLayout((Layout)groupSelWAVFileLayout);
            Label labelStartTime = new Label(this.ownComposite, 0);
            int[] nArray = new int[3];
            nArray[1] = 1000;
            nArray[2] = 5;
            int[] nArray2 = new int[3];
            nArray2[1] = 1000;
            nArray2[2] = 11;
            labelStartTime.setLayoutData((Object)this.prepareFormData(54, 12, nArray, nArray2));
            labelStartTime.setText("Start Time");
            this.textStartTime = new Label(this.ownComposite, 0);
            int[] nArray3 = new int[3];
            nArray3[1] = 1000;
            nArray3[2] = 78;
            int[] nArray4 = new int[3];
            nArray4[1] = 1000;
            nArray4[2] = 11;
            this.textStartTime.setLayoutData((Object)this.prepareFormData(84, 12, nArray3, nArray4));
            this.textStartTime.setText("00 : 00 . 000");
            Label labelEndTime = new Label(this.ownComposite, 0);
            int[] nArray5 = new int[3];
            nArray5[1] = 1000;
            nArray5[2] = 176;
            int[] nArray6 = new int[3];
            nArray6[1] = 1000;
            nArray6[2] = 11;
            labelEndTime.setLayoutData((Object)this.prepareFormData(48, 12, nArray5, nArray6));
            labelEndTime.setText("End Time");
            this.textEndTime = new Label(this.ownComposite, 0);
            int[] nArray7 = new int[3];
            nArray7[1] = 1000;
            nArray7[2] = 240;
            int[] nArray8 = new int[3];
            nArray8[1] = 1000;
            nArray8[2] = 11;
            this.textEndTime.setLayoutData((Object)this.prepareFormData(84, 12, nArray7, nArray8));
            this.textEndTime.setText("00 : 00 . 000");
            Label labelWFileInfo = new Label(this.ownComposite, 0);
            int[] nArray9 = new int[3];
            nArray9[1] = 1000;
            nArray9[2] = 5;
            int[] nArray10 = new int[3];
            nArray10[1] = 1000;
            nArray10[2] = 35;
            labelWFileInfo.setLayoutData((Object)this.prepareFormData(58, 12, nArray9, nArray10));
            labelWFileInfo.setText("WAV File");
            FormData textAreaWFileInfoLData = new FormData();
            textAreaWFileInfoLData.width = 415;
            textAreaWFileInfoLData.height = 80;
            textAreaWFileInfoLData.left = new FormAttachment(0, 1000, 69);
            textAreaWFileInfoLData.top = new FormAttachment(0, 1000, 35);
            this.textAreaWavInfo = new Text(this.ownComposite, 2122);
            this.textAreaWavInfo.setLayoutData((Object)textAreaWFileInfoLData);
            this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.descstandby"));
            this.initDnDProc(this.textAreaWavInfo);
            FormData chkboxPlayWavLData = new FormData();
            chkboxPlayWavLData.width = 13;
            chkboxPlayWavLData.height = 16;
            chkboxPlayWavLData.left = new FormAttachment(0, 1000, 501);
            chkboxPlayWavLData.top = new FormAttachment(0, 1000, 4);
            this.chkboxPlayWav = new Button(this.ownComposite, 16416);
            this.chkboxPlayWav.setLayoutData((Object)chkboxPlayWavLData);
            this.chkboxPlayWav.setSelection(true);
            this.chkboxPlayWav.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData labelPlayWavLData = new FormData();
            labelPlayWavLData.left = new FormAttachment(0, 1000, 518);
            labelPlayWavLData.top = new FormAttachment(0, 1000, 6);
            this.labelPlayWav = new Label(this.ownComposite, 0);
            this.labelPlayWav.setLayoutData((Object)labelPlayWavLData);
            this.labelPlayWav.setText("Play WAV");
            FormData labelWSpeedLData = new FormData();
            labelWSpeedLData.left = new FormAttachment(0, 1000, 662);
            labelWSpeedLData.top = new FormAttachment(0, 1000, 22);
            this.labelWSpeed = new Label(this.ownComposite, 0);
            this.labelWSpeed.setLayoutData((Object)labelWSpeedLData);
            this.labelWSpeed.setText("Speed");
            FormData scaleWavSpeedLData = new FormData();
            scaleWavSpeedLData.width = 219;
            scaleWavSpeedLData.height = 42;
            scaleWavSpeedLData.left = new FormAttachment(0, 1000, 697);
            scaleWavSpeedLData.top = new FormAttachment(0, 1000, 6);
            this.scaleWavSpeed = new Scale(this.ownComposite, 256);
            this.scaleWavSpeed.setLayoutData((Object)scaleWavSpeedLData);
            this.scaleWavSpeed.setMinimum(50);
            this.scaleWavSpeed.setMaximum(200);
            this.scaleWavSpeed.setIncrement(10);
            this.scaleWavSpeed.setSelection(100);
            this.scaleWavSpeed.setToolTipText("100/200");
            this.scaleWavSpeed.addSelectionListener((SelectionListener)new ScalePlaySpeedAdapter());
            this.scaleWavSpeed.addMouseTrackListener((MouseTrackListener)new ScaleMouseCursorTrackAdapter());
            FormData buttonWavAppendLData = new FormData();
            buttonWavAppendLData.width = 52;
            buttonWavAppendLData.height = 22;
            buttonWavAppendLData.left = new FormAttachment(0, 1000, 69);
            buttonWavAppendLData.top = new FormAttachment(0, 1000, 126);
            this.buttonWavAppend = new Button(this.ownComposite, 0x1000008);
            this.buttonWavAppend.setLayoutData((Object)buttonWavAppendLData);
            this.setVisibleAppend(false, false);
            this.buttonWavAppend.addSelectionListener((SelectionListener)new AppendScriptButtonAdapter());
            this.buttonWavAppend.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonWavDeleteLData = new FormData();
            buttonWavDeleteLData.width = 52;
            buttonWavDeleteLData.height = 22;
            buttonWavDeleteLData.left = new FormAttachment(0, 1000, 125);
            buttonWavDeleteLData.top = new FormAttachment(0, 1000, 126);
            this.buttonWavDelete = new Button(this.ownComposite, 0x1000008);
            this.buttonWavDelete.setLayoutData((Object)buttonWavDeleteLData);
            Image imgDelete = Activator.getImageDescriptor("/icons/delete.jpg").createImage();
            this.buttonWavDelete.setImage(imgDelete);
            this.setVisibleDelete(false);
            this.buttonWavDelete.addSelectionListener((SelectionListener)new DeleteScriptButtonAdapter());
            this.buttonWavDelete.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonWavPreviewLData = new FormData();
            buttonWavPreviewLData.width = 52;
            buttonWavPreviewLData.height = 22;
            buttonWavPreviewLData.top = new FormAttachment(0, 1000, 68);
            buttonWavPreviewLData.left = new FormAttachment(0, 1000, 501);
            this.buttonWavPreview = new Button(this.ownComposite, 0x1000008);
            this.buttonWavPreview.setLayoutData((Object)buttonWavPreviewLData);
            Image imgPreview = Activator.getImageDescriptor("/icons/preview.jpg").createImage();
            this.buttonWavPreview.setImage(imgPreview);
            this.setVisiblePreview(false);
            this.buttonWavPreview.addSelectionListener((SelectionListener)new PreviewButtonAdapter());
            this.buttonWavPreview.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonWavOpenLData = new FormData();
            buttonWavOpenLData.top = new FormAttachment((Control)labelWFileInfo, 16);
            buttonWavOpenLData.left = new FormAttachment(0, 1000, 5);
            this.buttonWavOpen = new Button(this.ownComposite, 0x1000008);
            this.buttonWavOpen.setLayoutData((Object)buttonWavOpenLData);
            this.buttonWavOpen.setText("OPEN");
            this.buttonWavOpen.addSelectionListener((SelectionListener)new OpenWavButtonAdapter());
            this.ownComposite.layout();
            this.ownComposite.pack();
        }
        catch (Exception e) {
            System.out.println("SelectWAVFileTab : Exception = " + e);
        }
    }

    public void initDispSelWavFile() {
        this.textStartTime.setText("00 : 00 . 000");
        this.textEndTime.setText("00 : 00 . 000");
        this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.descstandby"));
        this.setVisibleAppend(false, this.currentModeAppend);
        this.setVisibleDelete(false);
        this.setVisiblePreview(false);
    }

    public Composite getOwnComposite() {
        return this.ownComposite;
    }

    public void setEnabledTab(boolean newMode) {
        if (this.current_tab_mode != newMode) {
            this.current_tab_mode = newMode;
            if (this.current_tab_mode) {
                this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.descstandby"));
                this.buttonWavOpen.setEnabled(true);
            } else {
                this.initDescriptionStruct();
                this.initDispSelWavFile();
                this.currentSelWavFile = true;
                this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.cannotcontrol"));
                this.buttonWavOpen.setEnabled(false);
            }
        }
    }

    private void setVisibleAppend(boolean stat, boolean mode) {
        if (this.currentStatAppend != stat) {
            this.currentStatAppend = stat;
            if (stat) {
                this.currentModeAppend = mode;
                Image imgAppend = mode ? Activator.getImageDescriptor("/icons/update.jpg").createImage() : Activator.getImageDescriptor("/icons/add.jpg").createImage();
                this.buttonWavAppend.setImage(imgAppend);
            } else {
                this.chkboxPlayWav.setSelection(true);
                this.scaleWavSpeed.setSelection(100);
                this.scaleWavSpeed.setToolTipText(String.valueOf(String.valueOf(this.scaleWavSpeed.getSelection())) + "/200");
                this.currentSelWavFile = true;
            }
            this.buttonWavAppend.setVisible(stat);
            this.chkboxPlayWav.setVisible(stat);
            this.labelPlayWav.setVisible(stat);
            this.scaleWavSpeed.setVisible(stat);
            this.labelWSpeed.setVisible(stat);
        }
    }

    public void setEnablePreview(int stat) {
        if (stat == 0) {
            this.buttonWavPreview.setEnabled(true);
        } else {
            this.buttonWavPreview.setEnabled(false);
        }
    }

    public Shell getParentShell() {
        return instParentShell;
    }

    private void setVisibleDelete(boolean stat) {
        if (this.currentStatDelete != stat) {
            this.currentStatDelete = stat;
            this.buttonWavDelete.setVisible(stat);
        }
    }

    private void setVisiblePreview(boolean stat) {
        if (this.currentStatPreview != stat) {
            this.currentStatPreview = stat;
            this.buttonWavPreview.setVisible(stat);
        }
    }

    public void initDescriptionStruct() {
        this.descriptionIndex = -1;
        this.descriptionStartTime = 0;
        this.descriptionEndTime = 0;
        this.descriptionWavFile = null;
        this.descriptionCompetitiveRatio = 1.0f;
    }

    private float calCompetitiveRatioWav() {
        float compratio = 1.0f;
        int nowValue = this.scaleWavSpeed.getSelection();
        compratio = (float)nowValue / 100.0f;
        return compratio;
    }

    private int calSpeedScale(float compRatio) {
        int newPos = 100;
        newPos = (int)(compRatio * 100.0f);
        return newPos;
    }

    private int calDurationTimeWav(int nowDurationTime, float nowCompetitiveRatio) {
        int newDurationTime = nowDurationTime;
        float tempDurationTime = (float)nowDurationTime / nowCompetitiveRatio;
        newDurationTime = (int)tempDurationTime;
        return newDurationTime;
    }

    public void startDescriptionStruct(int startTime, String strDescription) {
        this.descriptionStartTime = startTime;
        this.descriptionCompetitiveRatio = this.calCompetitiveRatioWav();
        this.textStartTime.setText(this.instScriptData.makeFormatMMSSMS(this.descriptionStartTime));
        this.descriptionIndex = this.instScriptData.getIndexWavList(this.descriptionStartTime);
        if (this.descriptionIndex >= 0) {
            this.descriptionWavFile = this.instScriptData.getFileNameWavList(this.descriptionIndex);
            try {
                this.instSoundMixer.storeWavHeader(this.descriptionWavFile);
                this.textAreaWavInfo.setText(this.instSoundMixer.makeFormatWavInfo(this.descriptionWavFile.toString()));
                this.chkboxPlayWav.setSelection(this.instScriptData.getEnableWavList(this.descriptionIndex));
                this.descriptionCompetitiveRatio = this.instScriptData.getPlaySpeedWavList(this.descriptionIndex);
                this.descriptionEndTime = this.calDurationTimeWav(this.instSoundMixer.getDurationTimeWav(), this.descriptionCompetitiveRatio);
                this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(this.descriptionStartTime + this.descriptionEndTime));
                this.scaleWavSpeed.setSelection(this.calSpeedScale(this.descriptionCompetitiveRatio));
                this.scaleWavSpeed.setToolTipText(String.valueOf(String.valueOf(this.scaleWavSpeed.getSelection())) + "/200");
                this.chkboxPlayWav.setEnabled(true);
                this.scaleWavSpeed.setEnabled(true);
                this.setVisibleAppend(true, true);
                this.setVisibleDelete(true);
                this.setVisiblePreview(true);
                this.currentSelWavFile = true;
            }
            catch (Exception exception) {
                String strWavInfo = "";
                String strSeparator = "\n\r";
                String strFileName = "WAV file name : ";
                String strNotice = "Notice : " + Activator.getResourceString("scripteditor.tabitem.selwavfile.wavformerr");
                if (this.descriptionWavFile != null) {
                    strWavInfo = String.valueOf(strFileName) + this.descriptionWavFile + strSeparator;
                }
                strWavInfo = String.valueOf(strWavInfo) + strNotice + strSeparator;
                this.textAreaWavInfo.setText(strWavInfo);
                this.chkboxPlayWav.setEnabled(false);
                this.scaleWavSpeed.setEnabled(false);
                this.descriptionCompetitiveRatio = this.instScriptData.getPlaySpeedWavList(this.descriptionIndex);
                this.descriptionEndTime = 0;
                this.textEndTime.setText(this.instScriptData.makeFormatMMSSMS(this.descriptionEndTime));
                this.setVisibleDelete(true);
                this.setVisibleAppend(false, this.currentModeAppend);
                this.setVisiblePreview(false);
                this.currentSelWavFile = false;
            }
        } else {
            this.textEndTime.setText("00 : 00 . 000");
            this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.wavstandby"));
            this.setVisibleAppend(false, this.currentModeAppend);
            this.setVisibleDelete(false);
            this.setVisiblePreview(false);
            this.currentSelWavFile = true;
        }
    }

    public void repaintDescriptionStruct(int index) {
        int startTime = this.instScriptData.getScriptStartTime(index);
        String strDescription = this.instScriptData.getScriptData(index);
        this.startDescriptionStruct(startTime, strDescription);
    }

    public void refreshScriptData(int currentStartTime, int newStartTime, int newEndTime, boolean dspMode) {
        int index = this.instScriptData.getIndexWavList(currentStartTime);
        if (index >= 0) {
            URI currentWavFileName = this.instScriptData.getFileNameWavList(index);
            boolean currentEnableWav = this.instScriptData.getEnableWavList(index);
            float currentPlaySpeedWav = this.instScriptData.getPlaySpeedWavList(index);
            this.instScriptData.deleteIndexWavList(index);
            this.descriptionStartTime = newStartTime;
            this.descriptionEndTime = newEndTime - newStartTime;
            this.instScriptData.appendDataWavList(this.descriptionStartTime, newEndTime, currentWavFileName, currentEnableWav, currentPlaySpeedWav);
            if (dspMode) {
                index = this.instScriptData.getIndexScriptData(newStartTime);
                this.repaintDescriptionStruct(index);
            }
        }
    }

    private void initDnDProc(Text targetText) {
        DropTarget targetDnD = new DropTarget((Control)targetText, 17);
        targetDnD.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        targetDnD.addDropListener((DropTargetListener)new WavFileDropListener());
    }

    class AppendScriptButtonAdapter
    extends SelectionAdapter {
        AppendScriptButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (SelectWAVFileTab.this.currentSelWavFile) {
                boolean nowEnableWav = SelectWAVFileTab.this.chkboxPlayWav.getSelection();
                float nowCompetitiveRatio = SelectWAVFileTab.this.calCompetitiveRatioWav();
                SelectWAVFileTab.this.instScriptData.appendDataWavList(SelectWAVFileTab.this.descriptionStartTime, SelectWAVFileTab.this.descriptionStartTime + SelectWAVFileTab.this.descriptionEndTime, SelectWAVFileTab.this.descriptionWavFile, nowEnableWav, nowCompetitiveRatio);
                int index = ScriptData.getInstance().searchScriptData(SelectWAVFileTab.this.descriptionStartTime);
                int newEndTime = SelectWAVFileTab.this.descriptionStartTime + SelectWAVFileTab.this.descriptionEndTime;
                if (index >= 0) {
                    if (!nowEnableWav) {
                        newEndTime = ScriptData.getInstance().getScriptEndTime(index);
                    }
                    EditPanelView.getInstance().getInstanceTabEditPanel().reqUpdateEndTimeAudioLabel(index, newEndTime);
                    int stat = 5;
                    String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                    if (filePath != null) {
                        stat = 2;
                    }
                    SelectWAVFileTab.this.instScriptData.setStatusSaveScripts(stat, true);
                    SelectWAVFileTab.this.chkboxPlayWav.setEnabled(true);
                    SelectWAVFileTab.this.scaleWavSpeed.setEnabled(true);
                }
                SelectWAVFileTab.this.initDescriptionStruct();
                SelectWAVFileTab.this.initDispSelWavFile();
                SelectWAVFileTab.this.currentSelWavFile = true;
                ScriptListView.getInstance().getInstScriptList().reloadScriptList();
            }
        }
    }

    class ButtonMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        ButtonMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 0));
        }
    }

    class DeleteScriptButtonAdapter
    extends SelectionAdapter {
        DeleteScriptButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (SelectWAVFileTab.this.currentSelWavFile) {
                SelectWAVFileTab.this.instScriptData.deleteStartTimeWavList(SelectWAVFileTab.this.descriptionStartTime);
                int index = ScriptData.getInstance().searchScriptData(SelectWAVFileTab.this.descriptionStartTime);
                if (index >= 0) {
                    int newEndTime = ScriptData.getInstance().getScriptEndTime(index);
                    EditPanelView.getInstance().getInstanceTabEditPanel().reqUpdateEndTimeAudioLabel(index, newEndTime);
                    int stat = 5;
                    String filePath = TimeLineView.getInstance().reqGetXMLFilePath();
                    if (filePath != null) {
                        stat = 2;
                    }
                    SelectWAVFileTab.this.instScriptData.setStatusSaveScripts(stat, true);
                }
                SelectWAVFileTab.this.initDescriptionStruct();
                SelectWAVFileTab.this.initDispSelWavFile();
                SelectWAVFileTab.this.currentSelWavFile = true;
                ScriptListView.getInstance().getInstScriptList().reloadScriptList();
            }
        }
    }

    class OpenWavButtonAdapter
    extends SelectionAdapter {
        OpenWavButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] EXTENSIONS = new String[]{"*.wav", "*"};
            String wavFileName = "";
            try {
                FileDialog openDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                openDialog.setFilterExtensions(EXTENSIONS);
                wavFileName = openDialog.open();
                if (wavFileName != null) {
                    if (SelectWAVFileTab.this.instSoundMixer.isWavFormat(wavFileName)) {
                        SelectWAVFileTab.this.descriptionWavFile = TempFileUtil.getResource(wavFileName);
                        SelectWAVFileTab.this.instSoundMixer.storeWavHeader(SelectWAVFileTab.this.descriptionWavFile);
                        SelectWAVFileTab.this.descriptionCompetitiveRatio = SelectWAVFileTab.this.calCompetitiveRatioWav();
                        SelectWAVFileTab.this.descriptionEndTime = SelectWAVFileTab.this.calDurationTimeWav(SelectWAVFileTab.this.instSoundMixer.getDurationTimeWav(), SelectWAVFileTab.this.descriptionCompetitiveRatio);
                        SelectWAVFileTab.this.textEndTime.setText(SelectWAVFileTab.this.instScriptData.makeFormatMMSSMS(SelectWAVFileTab.this.descriptionStartTime + SelectWAVFileTab.this.descriptionEndTime));
                        SelectWAVFileTab.this.textAreaWavInfo.setText(SelectWAVFileTab.this.instSoundMixer.makeFormatWavInfo(SelectWAVFileTab.this.descriptionWavFile.toString()));
                        SelectWAVFileTab.this.chkboxPlayWav.setEnabled(true);
                        SelectWAVFileTab.this.scaleWavSpeed.setEnabled(true);
                        SelectWAVFileTab.this.setVisibleAppend(true, SelectWAVFileTab.this.currentModeAppend);
                        SelectWAVFileTab.this.setVisibleDelete(true);
                        SelectWAVFileTab.this.setVisiblePreview(true);
                        SelectWAVFileTab.this.currentSelWavFile = true;
                    } else {
                        SelectWAVFileTab.this.initDescriptionStruct();
                        SelectWAVFileTab.this.initDispSelWavFile();
                        SelectWAVFileTab.this.currentSelWavFile = true;
                        SelectWAVFileTab.this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.wavformerr"));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {}
        }
    }

    class PreviewButtonAdapter
    extends SelectionAdapter {
        PreviewButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (SelectWAVFileTab.this.currentSelWavFile) {
                SelectWAVFileTab.this.instSoundMixer.startPlaySound(SelectWAVFileTab.this.descriptionWavFile, SelectWAVFileTab.this.descriptionCompetitiveRatio);
            }
        }
    }

    class ScaleMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        ScaleMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Scale parentScale = (Scale)e.getSource();
            parentScale.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Scale parentScale = (Scale)e.getSource();
            parentScale.setCursor(new Cursor(null, 0));
        }
    }

    class ScalePlaySpeedAdapter
    extends SelectionAdapter {
        ScalePlaySpeedAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Scale scale = (Scale)e.widget;
            scale.setToolTipText(String.valueOf(String.valueOf(scale.getSelection())) + "/200");
            SelectWAVFileTab.this.descriptionCompetitiveRatio = SelectWAVFileTab.this.calCompetitiveRatioWav();
            SelectWAVFileTab.this.descriptionEndTime = SelectWAVFileTab.this.calDurationTimeWav(SelectWAVFileTab.this.instSoundMixer.getDurationTimeWav(), SelectWAVFileTab.this.descriptionCompetitiveRatio);
            SelectWAVFileTab.this.textEndTime.setText(SelectWAVFileTab.this.instScriptData.makeFormatMMSSMS(SelectWAVFileTab.this.descriptionStartTime + SelectWAVFileTab.this.descriptionEndTime));
        }
    }

    class WavFileDropListener
    extends DropTargetAdapter {
        WavFileDropListener() {
        }

        public void dragEnter(DropTargetEvent e) {
            e.detail = 1;
        }

        public void drop(DropTargetEvent e) {
            String[] files = (String[])e.data;
            if (SelectWAVFileTab.this.current_tab_mode) {
                try {
                    if (files.length > 0) {
                        if (SelectWAVFileTab.this.instSoundMixer.isWavFormat(files[0])) {
                            SelectWAVFileTab.this.descriptionWavFile = TempFileUtil.getResource(files[0]);
                            SelectWAVFileTab.this.instSoundMixer.storeWavHeader(SelectWAVFileTab.this.descriptionWavFile);
                            SelectWAVFileTab.this.descriptionCompetitiveRatio = SelectWAVFileTab.this.calCompetitiveRatioWav();
                            SelectWAVFileTab.this.descriptionEndTime = SelectWAVFileTab.this.calDurationTimeWav(SelectWAVFileTab.this.instSoundMixer.getDurationTimeWav(), SelectWAVFileTab.this.descriptionCompetitiveRatio);
                            SelectWAVFileTab.this.textEndTime.setText(SelectWAVFileTab.this.instScriptData.makeFormatMMSSMS(SelectWAVFileTab.this.descriptionStartTime + SelectWAVFileTab.this.descriptionEndTime));
                            SelectWAVFileTab.this.textAreaWavInfo.setText(SelectWAVFileTab.this.instSoundMixer.makeFormatWavInfo(SelectWAVFileTab.this.descriptionWavFile.toString()));
                            SelectWAVFileTab.this.chkboxPlayWav.setEnabled(true);
                            SelectWAVFileTab.this.scaleWavSpeed.setEnabled(true);
                            SelectWAVFileTab.this.setVisibleAppend(true, SelectWAVFileTab.this.currentModeAppend);
                            SelectWAVFileTab.this.setVisibleDelete(true);
                            SelectWAVFileTab.this.setVisiblePreview(true);
                            SelectWAVFileTab.this.currentSelWavFile = true;
                        } else {
                            SelectWAVFileTab.this.initDescriptionStruct();
                            SelectWAVFileTab.this.initDispSelWavFile();
                            SelectWAVFileTab.this.currentSelWavFile = true;
                            SelectWAVFileTab.this.textAreaWavInfo.setText(Activator.getResourceString("scripteditor.tabitem.selwavfile.wavformerr"));
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception exception) {}
            }
        }
    }
}

