/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLScriptElement;

public class SHScriptElement
extends SHElement
implements HTMLScriptElement {
    private static final long serialVersionUID = -4183083040741115537L;

    protected SHScriptElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public String getText() {
        Node child = this.getFirstChild();
        return child == null ? null : child.getNodeValue();
    }

    public void setText(String text) {
        Node child = this.getFirstChild();
        if (child == null) {
            this.appendChild(this.getOwnerDocument().createCDATASection(text));
        } else if (child instanceof CharacterData) {
            ((CharacterData)child).setData(text);
        } else {
            this.insertBefore(this.getOwnerDocument().createCDATASection(text), child);
        }
    }

    public String getHtmlFor() {
        return this.getAttribute("for");
    }

    public void setHtmlFor(String htmlFor) {
        this.setAttribute("for", htmlFor);
    }

    public String getEvent() {
        return this.getAttribute("event");
    }

    public void setEvent(String event) {
        this.setAttribute("event", event);
    }

    public String getCharset() {
        return this.getAttribute("charset");
    }

    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    public boolean getDefer() {
        String val = this.getAttribute("defer");
        return val != null && val.length() != 0;
    }

    public void setDefer(boolean defer) {
        this.setAttribute("defer", defer ? "defer" : null);
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }
}

