/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPartSite site;
        Object input = null;
        final IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof IMemoryRenderingSite) {
            ISelection selection;
            site = part.getSite();
            if (site != null && (selection = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow()).getActiveContext()) instanceof IStructuredSelection) {
                input = ((IStructuredSelection)selection).getFirstElement();
            }
        } else if (part instanceof IDebugView) {
            site = part.getSite();
            if (site != null && "org.eclipse.debug.ui.DebugView".equals(site.getId())) {
                Object obj;
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
                    input = ((TCFNode)obj).getModel().getRootNode();
                }
            } else {
                input = ((IDebugView)part).getViewer().getInput();
            }
        }
        if (input instanceof TCFNode) {
            final TCFNode node = (TCFNode)input;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TCFModel model = node.getModel();
                    TCFNode ref_node = node;
                    if (part instanceof IMemoryRenderingSite) {
                        TCFDataCache<TCFNodeExecContext> mem_cache = model.searchMemoryContext(node);
                        if (mem_cache == null) {
                            return;
                        }
                        if (!mem_cache.validate((Runnable)this)) {
                            return;
                        }
                        ref_node = (TCFNode)mem_cache.getData();
                    }
                    if (ref_node != null) {
                        ref_node.refresh(part);
                        if (model.clearLock(part)) {
                            model.setLock(part);
                        }
                    }
                }
            });
        }
        return null;
    }
}

