/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.util.TCFTask;

public final class TCFVirtualInputStream
extends InputStream {
    private static final int MAX_QUEUE = 8;
    private final IChannel channel;
    private final IStreams streams;
    private final String id;
    private final Runnable on_close;
    private final LinkedList<Buffer> queue = new LinkedList();
    private Buffer buf;
    private TCFTask<Buffer> task;
    private byte[] tmp = new byte[1];
    private boolean closed;
    private boolean eof;

    public TCFVirtualInputStream(IChannel channel, String id, Runnable on_close) throws IOException {
        this.channel = channel;
        this.streams = channel.getRemoteService(IStreams.class);
        if (this.streams == null) {
            throw new IOException("Streams service not available");
        }
        this.id = id;
        this.on_close = on_close;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            while (true) {
                if (this.buf == null) {
                    this.buf = (Buffer)new TCFTask<Buffer>(){

                        @Override
                        public void run() {
                            while (!TCFVirtualInputStream.this.eof && TCFVirtualInputStream.this.queue.size() < 8) {
                                final Buffer nxt = new Buffer();
                                TCFVirtualInputStream.this.queue.add(nxt);
                                nxt.token = TCFVirtualInputStream.this.streams.read(TCFVirtualInputStream.this.id, 65536, new IStreams.DoneRead(){

                                    @Override
                                    public void doneRead(IToken token, Exception error, int lost, byte[] data, boolean eos) {
                                        if (!$assertionsDisabled && nxt.token != token) {
                                            throw new AssertionError();
                                        }
                                        nxt.token = null;
                                        nxt.error = error;
                                        nxt.buf = data;
                                        nxt.eof = eos;
                                        if (!TCFVirtualInputStream.this.eof && (eos || error != null)) {
                                            TCFVirtualInputStream.this.eof = true;
                                        }
                                        if (TCFVirtualInputStream.this.task != null) {
                                            if (!$assertionsDisabled && TCFVirtualInputStream.this.queue.getFirst() != nxt) {
                                                throw new AssertionError();
                                            }
                                            TCFVirtualInputStream.this.task.done((Buffer)TCFVirtualInputStream.this.queue.removeFirst());
                                            TCFVirtualInputStream.this.task = null;
                                        }
                                    }
                                });
                            }
                            if (((Buffer)((TCFVirtualInputStream)TCFVirtualInputStream.this).queue.getFirst()).token == null) {
                                this.done((Buffer)TCFVirtualInputStream.this.queue.removeFirst());
                            } else {
                                TCFVirtualInputStream.this.task = this;
                            }
                        }
                    }.getIO();
                }
                if (this.buf.buf != null && this.buf.pos < this.buf.buf.length) {
                    int n = len;
                    if (n > this.buf.buf.length - this.buf.pos) {
                        n = this.buf.buf.length - this.buf.pos;
                    }
                    System.arraycopy(this.buf.buf, this.buf.pos, b, off, n);
                    this.buf.pos += n;
                    return n;
                }
                if (this.buf.error instanceof IOException) {
                    throw (IOException)this.buf.error;
                }
                if (this.buf.error != null) {
                    throw new IOException(this.buf.error);
                }
                if (this.buf.eof) {
                    return -1;
                }
                this.buf = null;
            }
        }
        catch (IOException e) {
            if (this.closed) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.closed && this.buf != null && this.buf.buf != null && this.buf.pos < this.buf.buf.length) {
            return this.buf.buf[this.buf.pos++] & 0xFF;
        }
        int n = this.read(this.tmp, 0, 1);
        if (n < 0) {
            return -1;
        }
        assert (n == 1);
        return this.tmp[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        new TCFTask<Object>(){

            @Override
            public void run() {
                TCFVirtualInputStream.this.streams.disconnect(TCFVirtualInputStream.this.id, new IStreams.DoneDisconnect(){

                    @Override
                    public void doneDisconnect(IToken token, Exception error) {
                        if (error != null && TCFVirtualInputStream.this.channel.getState() != 2) {
                            this.error(error);
                        } else {
                            if (TCFVirtualInputStream.this.on_close != null) {
                                TCFVirtualInputStream.this.on_close.run();
                            }
                            this.done(this);
                        }
                    }
                });
            }
        }.getIO();
    }

    private static class Buffer {
        IToken token;
        Exception error;
        byte[] buf;
        int pos;
        boolean eof;

        private Buffer() {
        }
    }
}

