/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.services;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

public interface IMemory
extends IService {
    public static final String NAME = "Memory";
    public static final String PROP_ID = "ID";
    public static final String PROP_PARENT_ID = "ParentID";
    public static final String PROP_PROCESS_ID = "ProcessID";
    public static final String PROP_BIG_ENDIAN = "BigEndian";
    public static final String PROP_ADDRESS_SIZE = "AddressSize";
    public static final String PROP_NAME = "Name";
    public static final String PROP_START_BOUND = "StartBound";
    public static final String PROP_END_BOUND = "EndBound";
    public static final String PROP_ACCESS_TYPES = "AccessTypes";
    public static final String PROP_ADDRESSABLE_UNIT_SIZE = "AddressableUnitSize";
    public static final String PROP_DEFAULT_WORD_SIZE = "DefaultWordSize";
    public static final String ACCESS_INSTRUCTION = "instruction";
    public static final String ACCESS_DATA = "data";
    public static final String ACCESS_IO = "io";
    public static final String ACCESS_USER = "user";
    public static final String ACCESS_SUPERVISOR = "supervisor";
    public static final String ACCESS_HYPERVISOR = "hypervisor";
    public static final String ACCESS_VIRTUAL = "virtual";
    public static final String ACCESS_PHYSICAL = "physical";
    public static final String ACCESS_CACHE = "cache";
    public static final String ACCESS_TLB = "tlb";
    public static final int MODE_CONTINUEONERROR = 1;
    public static final int MODE_VERIFY = 2;
    public static final int MODE_BYPASS_ADDR_CHECK = 4;
    public static final int MODE_BYPASS_CACHE_SYNC = 8;
    public static final int MODE_DONT_STOP = 16;
    public static final int MODE_MEMORY_ONLY = 32;

    public IToken getContext(String var1, DoneGetContext var2);

    public IToken getChildren(String var1, DoneGetChildren var2);

    public void addListener(MemoryListener var1);

    public void removeListener(MemoryListener var1);

    public static interface DoneGetChildren {
        public void doneGetChildren(IToken var1, Exception var2, String[] var3);
    }

    public static interface DoneGetContext {
        public void doneGetContext(IToken var1, Exception var2, MemoryContext var3);
    }

    public static interface DoneMemory {
        public void doneMemory(IToken var1, MemoryError var2);
    }

    public static interface ErrorOffset {
        public static final int BYTE_VALID = 0;
        public static final int BYTE_UNKNOWN = 1;
        public static final int BYTE_INVALID = 2;
        public static final int BYTE_CANNOT_READ = 4;
        public static final int BYTE_CANNOT_WRITE = 8;
        public static final String RANGE_KEY_ADDR = "addr";
        public static final String RANGE_KEY_SIZE = "size";
        public static final String RANGE_KEY_STAT = "stat";
        public static final String RANGE_KEY_MSG = "msg";

        public int getStatus(int var1);

        public String getMessage(int var1);
    }

    public static interface MemoryContext {
        public String getID();

        public String getParentID();

        public String getProcessID();

        public boolean isBigEndian();

        public int getAddressSize();

        public String getName();

        public Number getStartBound();

        public Number getEndBound();

        public Collection<String> getAccessTypes();

        public int getAddressableUnitSize();

        public int getDefaultWordSize();

        public Map<String, Object> getProperties();

        public IToken set(Number var1, int var2, byte[] var3, int var4, int var5, int var6, DoneMemory var7);

        public IToken get(Number var1, int var2, byte[] var3, int var4, int var5, int var6, DoneMemory var7);

        public IToken fill(Number var1, int var2, byte[] var3, int var4, int var5, DoneMemory var6);
    }

    public static class MemoryError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MemoryError(String msg) {
            super(msg);
        }
    }

    public static interface MemoryListener {
        public void contextAdded(MemoryContext[] var1);

        public void contextChanged(MemoryContext[] var1);

        public void contextRemoved(String[] var1);

        public void memoryChanged(String var1, Number[] var2, long[] var3);
    }
}

