/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IRunControl;

class RunControl {
    private final TCFTestSuite test_suite;
    private final IChannel channel;
    private int channel_id;
    private final IRunControl rc_service;
    private final HashSet<String> suspended_ctx_ids = new HashSet();
    private final HashSet<IToken> get_state_cmds = new HashSet();
    private final HashMap<String, IToken> resume_cmds = new HashMap();
    private final HashSet<String> pending_resume_ids = new HashSet();
    private final HashMap<String, IRunControl.RunControlContext> ctx_map = new HashMap();
    private final Random rnd = new Random();
    private boolean enable_trace;
    private boolean sync_pending;
    private final IRunControl.RunControlListener listener = new IRunControl.RunControlListener(){

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                RunControl.this.ctx_map.put(ctx.getID(), ctx);
                ++n2;
            }
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                IRunControl.RunControlContext prv = RunControl.this.ctx_map.put(ctx.getID(), ctx);
                if (prv != null && prv.getProperties().get("DiagnosticTestProcess") != null && ctx.getProperties().get("DiagnosticTestProcess") == null) {
                    RunControl.this.test_suite.getCanceledTests().remove(ctx.getID());
                    ITCFTest test = RunControl.this.test_suite.getActiveTest(RunControl.this.channel);
                    if (test instanceof DiagnosticTestDone) {
                        ((DiagnosticTestDone)((Object)test)).testDone(ctx.getID());
                    }
                }
                ++n2;
            }
        }

        public void contextRemoved(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                RunControl.this.ctx_map.remove(id);
                RunControl.this.test_suite.getCanceledTests().remove(id);
                RunControl.this.suspended_ctx_ids.remove(id);
                ++n2;
            }
        }

        public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
            if (RunControl.this.enable_trace) {
                System.out.println(RunControl.this.channel_id + " suspended " + id + ": " + pc + " " + reason);
            }
            RunControl.this.suspended_ctx_ids.add(id);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RunControl.this.resume();
                }
            });
        }

        public void contextResumed(String id) {
            if (RunControl.this.enable_trace) {
                System.out.println(RunControl.this.channel_id + " resumed " + id);
            }
            RunControl.this.suspended_ctx_ids.remove(id);
            RunControl.this.pending_resume_ids.remove(id);
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            int n;
            if (RunControl.this.enable_trace) {
                StringBuffer bf = new StringBuffer();
                String[] stringArray = suspended_ids;
                int n2 = suspended_ids.length;
                n = 0;
                while (n < n2) {
                    String id = stringArray[n];
                    if (bf.length() > 0) {
                        bf.append(',');
                    }
                    bf.append(id);
                    ++n;
                }
                System.out.println(RunControl.this.channel_id + " suspended " + bf);
            }
            String[] stringArray = suspended_ids;
            n = suspended_ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                RunControl.this.suspended_ctx_ids.add(id);
                ++n3;
            }
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RunControl.this.resume();
                }
            });
        }

        public void containerResumed(String[] context_ids) {
            int n;
            if (RunControl.this.enable_trace) {
                StringBuffer bf = new StringBuffer();
                String[] stringArray = context_ids;
                int n2 = context_ids.length;
                n = 0;
                while (n < n2) {
                    String id = stringArray[n];
                    if (bf.length() > 0) {
                        bf.append(',');
                    }
                    bf.append(id);
                    ++n;
                }
                System.out.println(RunControl.this.channel_id + " resumed " + bf);
            }
            String[] stringArray = context_ids;
            n = context_ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                RunControl.this.suspended_ctx_ids.remove(id);
                RunControl.this.pending_resume_ids.remove(id);
                ++n3;
            }
        }

        public void contextException(String context, String msg) {
        }
    };

    RunControl(TCFTestSuite test_suite, IChannel channel, int channel_id) {
        this.test_suite = test_suite;
        this.channel = channel;
        this.channel_id = channel_id;
        this.rc_service = (IRunControl)channel.getRemoteService(IRunControl.class);
        if (this.rc_service != null) {
            this.rc_service.addListener(this.listener);
            this.getState();
            this.startTimer();
        }
        this.enable_trace = System.getProperty("org.eclipse.tcf.debug.tracing.tests.runcontrol") != null;
    }

    private void getState() {
        this.get_state_cmds.add(this.rc_service.getChildren(null, new IRunControl.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                RunControl.this.get_state_cmds.remove(token);
                if (error != null) {
                    RunControl.this.exit(error);
                } else {
                    String[] stringArray = context_ids;
                    int n = context_ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String id = stringArray[n2];
                        RunControl.this.get_state_cmds.add(RunControl.this.rc_service.getChildren(id, (IRunControl.DoneGetChildren)this));
                        RunControl.this.get_state_cmds.add(RunControl.this.rc_service.getContext(id, new IRunControl.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                                RunControl.this.get_state_cmds.remove(token);
                                if (error != null) {
                                    RunControl.this.exit(error);
                                } else {
                                    RunControl.this.ctx_map.put(id, context);
                                    if (context.hasState()) {
                                        RunControl.this.get_state_cmds.add(context.getState(new IRunControl.DoneGetState(){

                                            public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                                                RunControl.this.get_state_cmds.remove(token);
                                                if (error != null) {
                                                    if (RunControl.this.ctx_map.get(id) != null) {
                                                        RunControl.this.exit(new Exception("Cannot get context state", error));
                                                    }
                                                } else if (suspended) {
                                                    RunControl.this.suspended_ctx_ids.add(id);
                                                }
                                            }
                                        }));
                                    }
                                }
                            }
                        }));
                        ++n2;
                    }
                }
            }
        }));
    }

    private void startTimer() {
        Protocol.invokeLater((long)50L, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (RunControl.this.channel.getState() != 1) {
                    return;
                }
                if (((RunControl)RunControl.this).test_suite.cancel) {
                    return;
                }
                Protocol.invokeLater((long)50L, (Runnable)this);
                RunControl.this.resume();
            }
        });
    }

    private void resume() {
        Set<String> s = this.test_suite.getCanceledTests().keySet();
        if (s.size() > 0 || this.suspended_ctx_ids.size() > 0) {
            HashSet<String> ids = new HashSet<String>(s);
            ids.addAll(this.suspended_ctx_ids);
            String[] arr = ids.toArray(new String[ids.size()]);
            this.resume(arr[this.rnd.nextInt(arr.length)], 0, 1);
        }
    }

    private void exit(Throwable error) {
        ITCFTest[] arr;
        Collection<ITCFTest> c = this.test_suite.getActiveTests();
        ITCFTest[] iTCFTestArray = arr = c.toArray(new ITCFTest[c.size()]);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            ITCFTest t = iTCFTestArray[n2];
            this.test_suite.done(t, error);
            ++n2;
        }
    }

    IRunControl.RunControlContext getContext(String id) {
        return this.ctx_map.get(id);
    }

    boolean canResume(String id) {
        if (this.sync_pending) {
            return false;
        }
        if (this.get_state_cmds.size() > 0) {
            return false;
        }
        if (this.resume_cmds.get(id) != null) {
            return false;
        }
        if (this.test_suite.getCanceledTests().get(id) == null && !this.suspended_ctx_ids.contains(id)) {
            return false;
        }
        IRunControl.RunControlContext ctx = this.ctx_map.get(id);
        if (ctx == null) {
            return false;
        }
        String grp = ctx.getRCGroup();
        if (grp != null) {
            for (String s : this.resume_cmds.keySet()) {
                IRunControl.RunControlContext c = this.ctx_map.get(s);
                if (c == null) {
                    return false;
                }
                if (!grp.equals(c.getRCGroup())) continue;
                return false;
            }
        }
        return true;
    }

    void resume(final String id, final int mode, final int cnt) {
        if (!this.test_suite.canResume(id)) {
            return;
        }
        assert (!this.sync_pending);
        this.sync_pending = true;
        Protocol.sync((Runnable)new Runnable(){

            @Override
            public void run() {
                RunControl.this.sync_pending = false;
                if (RunControl.this.test_suite.canResume(id)) {
                    if (!$assertionsDisabled && RunControl.this.resume_cmds.get(id) != null) {
                        throw new AssertionError();
                    }
                    final String test_id = RunControl.this.test_suite.getCanceledTests().get(id);
                    if (test_id != null) {
                        IRunControl.RunControlContext ctx;
                        boolean ok = false;
                        if (RunControl.this.enable_trace) {
                            System.out.println(RunControl.this.channel_id + " cancel " + id);
                        }
                        if (RunControl.this.rnd.nextInt(4) == 0 && (ctx = (IRunControl.RunControlContext)RunControl.this.ctx_map.get(test_id)) != null && ctx.canTerminate()) {
                            RunControl.this.resume_cmds.put(id, ctx.terminate(new IRunControl.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    if (!$assertionsDisabled && RunControl.this.resume_cmds.get(id) != token) {
                                        throw new AssertionError();
                                    }
                                    RunControl.this.resume_cmds.remove(id);
                                    if (RunControl.this.enable_trace) {
                                        System.out.println(RunControl.this.channel_id + " done cancel " + error);
                                    }
                                    if (error != null && RunControl.this.ctx_map.get(test_id) != null) {
                                        RunControl.this.exit(error);
                                    }
                                }
                            }));
                            ok = true;
                        }
                        if (!ok && RunControl.this.rnd.nextInt(4) == 0 && (ctx = (IRunControl.RunControlContext)RunControl.this.ctx_map.get(test_id)) != null && ctx.canDetach()) {
                            RunControl.this.resume_cmds.put(id, ctx.detach(new IRunControl.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    if (!$assertionsDisabled && RunControl.this.resume_cmds.get(id) != token) {
                                        throw new AssertionError();
                                    }
                                    RunControl.this.resume_cmds.remove(id);
                                    if (RunControl.this.enable_trace) {
                                        System.out.println(RunControl.this.channel_id + " done detach " + error);
                                    }
                                    if (error != null && RunControl.this.ctx_map.get(test_id) != null) {
                                        RunControl.this.exit(error);
                                    }
                                }
                            }));
                            ok = true;
                        }
                        if (!ok) {
                            IDiagnostics diag = (IDiagnostics)RunControl.this.channel.getRemoteService(IDiagnostics.class);
                            RunControl.this.resume_cmds.put(id, diag.cancelTest(test_id, new IDiagnostics.DoneCancelTest(){

                                public void doneCancelTest(IToken token, Throwable error) {
                                    if (!$assertionsDisabled && RunControl.this.resume_cmds.get(id) != token) {
                                        throw new AssertionError();
                                    }
                                    RunControl.this.resume_cmds.remove(id);
                                    if (RunControl.this.enable_trace) {
                                        System.out.println(RunControl.this.channel_id + " done cancel " + error);
                                    }
                                    if (error != null && RunControl.this.ctx_map.get(test_id) != null) {
                                        RunControl.this.exit(error);
                                    }
                                }
                            }));
                        }
                    } else {
                        final IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)RunControl.this.ctx_map.get(id);
                        if (ctx != null) {
                            RunControl.this.pending_resume_ids.add(id);
                            if (RunControl.this.enable_trace) {
                                System.out.println(RunControl.this.channel_id + " resume " + mode + " " + cnt + " " + id);
                            }
                            RunControl.this.resume_cmds.put(id, ctx.resume(mode, cnt, new IRunControl.DoneCommand(){
                                int retry = 0;

                                public void doneCommand(IToken token, Exception error) {
                                    if (!$assertionsDisabled && RunControl.this.resume_cmds.get(id) != token) {
                                        throw new AssertionError();
                                    }
                                    RunControl.this.resume_cmds.remove(id);
                                    if (RunControl.this.enable_trace) {
                                        System.out.println(RunControl.this.channel_id + " done resume " + error);
                                    }
                                    if (error != null) {
                                        if (this.retry == 0 && cnt > 1 && RunControl.this.suspended_ctx_ids.contains(id) && RunControl.this.pending_resume_ids.contains(id)) {
                                            RunControl.this.resume_cmds.put(id, ctx.resume(mode, 1, (IRunControl.DoneCommand)this));
                                            ++this.retry;
                                        } else {
                                            RunControl.this.pending_resume_ids.remove(id);
                                            if (RunControl.this.suspended_ctx_ids.contains(id)) {
                                                RunControl.this.exit(error);
                                            }
                                        }
                                    } else if (RunControl.this.pending_resume_ids.contains(id)) {
                                        RunControl.this.exit(new Exception("Missing contextResumed event"));
                                    }
                                }
                            }));
                        }
                    }
                }
            }
        });
    }

    void cancel(String test_id) {
        for (IRunControl.RunControlContext ctx : this.ctx_map.values()) {
            if (!ctx.hasState() || !test_id.equals(ctx.getID()) && !test_id.equals(ctx.getParentID()) && !test_id.equals(ctx.getCreatorID())) continue;
            String thread_id = ctx.getID();
            this.test_suite.getCanceledTests().put(thread_id, test_id);
            this.resume(thread_id, 0, 1);
        }
    }

    public static interface DiagnosticTestDone {
        public void testDone(String var1);
    }
}

