/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.ISearchCallback;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.search.AbstractSearcher;
import org.eclipse.tcf.te.ui.search.BreadthFirstSearcher;
import org.eclipse.tcf.te.ui.search.DelegateProgressMonitor;
import org.eclipse.tcf.te.ui.search.DepthFirstSearcher;

public class SearchEngine {
    AbstractSearcher fSearcher;
    Job fSearchJob;
    TreeViewer fViewer;
    boolean fDepthFirst;
    ISearchable fSearchable;
    TreePath fStartPath;
    boolean fWrap;
    TreePath fLastResult;

    public SearchEngine(TreeViewer viewer, boolean depthFirst, ISearchable searchable, TreePath path) {
        this.fViewer = viewer;
        this.fDepthFirst = depthFirst;
        this.fSearchable = searchable;
        this.fStartPath = path;
        this.fSearcher = this.fDepthFirst ? new DepthFirstSearcher(this.fViewer, this.fSearchable) : new BreadthFirstSearcher(this.fViewer, this.fSearchable);
        this.fSearcher.setStartPath(path);
    }

    public boolean isDepthFirst() {
        return this.fDepthFirst;
    }

    public void setDepthFirst(boolean depthFirst) {
        if (this.fDepthFirst != depthFirst) {
            this.fDepthFirst = depthFirst;
            this.fSearcher = this.fDepthFirst ? new DepthFirstSearcher(this.fViewer, this.fSearchable) : new BreadthFirstSearcher(this.fViewer, this.fSearchable);
            this.fSearcher.setStartPath(this.fStartPath);
        }
    }

    public void setStartPath(TreePath path) {
        this.fStartPath = path;
        this.fSearcher.setStartPath(path);
    }

    public void resetPath() {
        this.fSearcher.setStartPath(this.fStartPath);
    }

    public void endSearch() {
        if (this.fSearchJob != null) {
            this.fSearchJob.cancel();
            this.fSearchJob = null;
        }
    }

    public void startSearch(final ISearchCallback callback, final ProgressMonitorPart pmpart) {
        final TreePath[] result = new TreePath[1];
        this.fSearchJob = new Job(Messages.TreeViewerSearchDialog_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor = new DelegateProgressMonitor((IProgressMonitor)monitor, pmpart);
                monitor.beginTask(Messages.TreeViewerSearchDialog_MainTaskName, -1);
                try {
                    try {
                        result[0] = SearchEngine.this.fSearcher.searchNext((IProgressMonitor)monitor);
                    }
                    catch (InvocationTargetException e) {
                        Status status;
                        Status status2 = status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
                        monitor.done();
                        return status2;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.fSearchJob.setSystem(true);
        this.fSearchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                SearchEngine.this.fViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = event.getResult();
                        TreePath treePath = result[0];
                        if (callback != null) {
                            callback.searchDone(status, treePath);
                        }
                        SearchEngine.this.searchDone(status, treePath);
                        (this).SearchEngine.this.fSearchJob = null;
                        if (status.isOK() && treePath == null && (this).SearchEngine.this.fWrap && (this).SearchEngine.this.fLastResult != null) {
                            (this).SearchEngine.this.fLastResult = null;
                            SearchEngine.this.startSearch(callback, pmpart);
                        }
                    }
                });
            }
        });
        this.fSearchJob.schedule();
    }

    public void setForeward(boolean foreward) {
        if (this.fDepthFirst && this.fSearcher instanceof DepthFirstSearcher) {
            ((DepthFirstSearcher)this.fSearcher).setForeward(foreward);
        }
    }

    void searchDone(IStatus status, TreePath path) {
        if (status.isOK()) {
            if (path != null) {
                this.fLastResult = path;
                this.fViewer.expandToLevel((Object)path, 0);
                this.fViewer.setSelection((ISelection)new StructuredSelection(new Object[]{path}), true);
            } else if (this.fWrap && this.fLastResult != null) {
                this.resetPath();
            }
        }
    }

    public boolean isWrap() {
        return this.fWrap;
    }

    public void setWrap(boolean wrap) {
        this.fWrap = wrap;
    }

    public TreePath getLastResult() {
        return this.fLastResult;
    }
}

