/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;

public class LabelProviderDelegateExtensionPointManager
extends AbstractExtensionPointManager<ILabelProvider> {
    LabelProviderDelegateExtensionPointManager() {
    }

    public static LabelProviderDelegateExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.ui.views.labelProviderDelegates";
    }

    protected String getConfigurationElementName() {
        return "labelProviderDelegate";
    }

    public ILabelProvider[] getDelegates(Object context, boolean unique) {
        ArrayList<ILabelProvider> contributions = new ArrayList<ILabelProvider>();
        Collection delegates = this.getExtensions().values();
        ArrayList<ExecutableExtensionProxy> applicableDelegates = new ArrayList<ExecutableExtensionProxy>();
        for (ExecutableExtensionProxy delegate : delegates) {
            boolean isApplicable;
            IConfigurationElement[] children;
            Expression enablement = null;
            IConfigurationElement[] iConfigurationElementArray = children = delegate != null ? delegate.getConfigurationElement().getChildren() : null;
            if (children != null && children.length > 0) {
                try {
                    enablement = ExpressionConverter.getDefault().perform(children[0]);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (context != null) {
                    IEvaluationContext currentState = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).getCurrentState();
                    EvaluationContext evalContext = new EvaluationContext(currentState, context);
                    evalContext.addVariable("context", context);
                    evalContext.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (!isApplicable) continue;
            applicableDelegates.add(delegate);
        }
        Collections.sort(applicableDelegates, new Comparator<ExecutableExtensionProxy<ILabelProvider>>(){

            @Override
            public int compare(ExecutableExtensionProxy<ILabelProvider> o1, ExecutableExtensionProxy<ILabelProvider> o2) {
                String rank1Str = o1.getConfigurationElement().getAttribute("rank");
                int rank1 = 0;
                try {
                    rank1 = rank1Str != null ? Integer.parseInt(rank1Str) : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String rank2Str = o2.getConfigurationElement().getAttribute("rank");
                int rank2 = 0;
                try {
                    rank2 = rank2Str != null ? Integer.parseInt(rank2Str) : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return rank2 - rank1;
            }
        });
        for (ExecutableExtensionProxy delegate : applicableDelegates) {
            ILabelProvider instance;
            ILabelProvider iLabelProvider = instance = unique ? (ILabelProvider)delegate.newInstance() : (ILabelProvider)delegate.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new ILabelProvider[contributions.size()]);
    }

    private static class LazyInstance {
        public static LabelProviderDelegateExtensionPointManager instance = new LabelProviderDelegateExtensionPointManager();

        private LazyInstance() {
        }
    }
}

