/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.te.runtime.persistence.delegates.GsonMapPersistenceDelegate;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;

public class PersistenceManagerDelegate
extends GsonMapPersistenceDelegate {
    private static final String MAP_KEY_MTIME = "mtime";
    private static final String MAP_KEY_TARGET_MTIME = "target_mtime";
    private static final String MAP_KEY_TARGET = "target";
    private static final String MAP_KEY_CACHE = "cache";
    private static final String MAP_KEY_BASE = "base";
    private static final String MAP_KEY_UNRESOLVED = "unresolved";
    private static final String MAP_KEY_RESOLVED = "resolved";
    private static final String MAP_KEY_PROPERTIES = "properties";
    private static final String MAP_KEY_DIGESTS = "digests";

    public Class<?> getPersistedClass(Object context) {
        return PersistenceManager.class;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        PersistenceManager pMgr = (PersistenceManager)context;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(MAP_KEY_DIGESTS, this.persistDigests(pMgr.digests));
        result.put(MAP_KEY_PROPERTIES, this.persistProperties(pMgr.properties));
        result.put(MAP_KEY_RESOLVED, this.persistResolved(pMgr.resolved));
        result.put(MAP_KEY_UNRESOLVED, this.persistUnresolved(pMgr.unresolved));
        return result;
    }

    private Object persistProperties(Map<URI, Map<QualifiedName, String>> properties) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (properties != null) {
            for (Map.Entry<URI, Map<QualifiedName, String>> entry : properties.entrySet()) {
                Map<QualifiedName, String> map = entry.getValue();
                Map<String, Object> valueMap = this.qNames2Map(map);
                result.put(entry.getKey().toString(), valueMap);
            }
        }
        return result;
    }

    private Object persistResolved(Map<URI, IContentType> resolved) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (resolved != null) {
            for (Map.Entry<URI, IContentType> entry : resolved.entrySet()) {
                IContentType object = entry.getValue();
                String value = object.getId();
                result.put(entry.getKey().toString(), value);
            }
        }
        return result;
    }

    private Object persistUnresolved(Map<URI, URI> unresolved) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (unresolved != null) {
            for (Map.Entry<URI, URI> entry : unresolved.entrySet()) {
                URI uri = entry.getValue();
                String value = uri.toString();
                result.put(entry.getKey().toString(), value);
            }
        }
        return result;
    }

    private Object persistDigests(Map<URI, FileState> states) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (states != null) {
            for (Map.Entry<URI, FileState> entry : states.entrySet()) {
                FileState fileState = entry.getValue();
                Map<String, Object> value = this.digest2map(fileState);
                result.put(entry.getKey().toString(), value);
            }
        }
        return result;
    }

    private Map<String, Object> qNames2Map(Map<QualifiedName, String> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<QualifiedName, String> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        PersistenceManager result = (PersistenceManager)context;
        Map digests = (Map)map.get(MAP_KEY_DIGESTS);
        Map properties = (Map)map.get(MAP_KEY_PROPERTIES);
        Map resolved = (Map)map.get(MAP_KEY_RESOLVED);
        Map unresolved = (Map)map.get(MAP_KEY_UNRESOLVED);
        this.restoreDigests(digests, result.digests);
        this.restoreProperites(properties, result.properties);
        this.restoreResolved(resolved, result.resolved);
        this.restoreUnresolved(unresolved, result.unresolved);
        return result;
    }

    private void restoreUnresolved(Map<String, String> map, Map<URI, URI> unresolved) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            URI uri = this.toURI(entry.getKey());
            Assert.isNotNull((Object)uri);
            uri = this.toURI(value);
            Assert.isNotNull((Object)uri);
            unresolved.put(uri, uri);
        }
    }

    private void restoreResolved(Map<String, String> map, Map<URI, IContentType> contentTypes) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            URI uri = this.toURI(entry.getKey());
            Assert.isNotNull((Object)uri);
            IContentType contentType = Platform.getContentTypeManager().getContentType(value);
            contentTypes.put(uri, contentType);
        }
    }

    private void restoreDigests(Map<String, Map<String, Object>> map, Map<URI, FileState> states) {
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            Map<String, Object> value = entry.getValue();
            URI uri = this.toURI(entry.getKey());
            Assert.isNotNull((Object)uri);
            FileState digest = this.map2digest(value);
            states.put(uri, digest);
        }
    }

    private void restoreProperites(Map<String, Map<String, String>> map, Map<URI, Map<QualifiedName, String>> properties) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            Map<String, String> value = entry.getValue();
            URI uri = this.toURI(entry.getKey());
            Assert.isNotNull((Object)uri);
            Map<QualifiedName, String> valueMap = this.toQNameMap(value);
            properties.put(uri, valueMap);
        }
    }

    private FileState map2digest(Map<String, Object> value) {
        byte[] base_digest = this.string2digest((String)value.get(MAP_KEY_BASE));
        byte[] cache_digest = this.string2digest((String)value.get(MAP_KEY_CACHE));
        byte[] target_digest = this.string2digest((String)value.get(MAP_KEY_TARGET));
        Number number = (Number)value.get(MAP_KEY_MTIME);
        long mtime = number.longValue();
        number = (Number)value.get(MAP_KEY_TARGET_MTIME);
        long target_mtime = number == null ? 0L : number.longValue();
        return new FileState(mtime, target_mtime, cache_digest, target_digest, base_digest);
    }

    private Map<String, Object> digest2map(FileState digest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(MAP_KEY_BASE, PersistenceManagerDelegate.digest2string(digest.getBaseDigest()));
        map.put(MAP_KEY_CACHE, PersistenceManagerDelegate.digest2string(digest.getCacheDigest()));
        map.put(MAP_KEY_TARGET, PersistenceManagerDelegate.digest2string(digest.getTargetDigest()));
        map.put(MAP_KEY_MTIME, digest.getCacheMTime());
        map.put(MAP_KEY_TARGET_MTIME, digest.getTargetMTime());
        return map;
    }

    static String digest2string(byte[] digest) {
        if (digest != null && digest.length > 0) {
            StringBuilder buffer = new StringBuilder();
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                int d = element & 0xFF;
                String sByte = Integer.toHexString(d);
                while (sByte.length() < 2) {
                    sByte = "0" + sByte;
                }
                buffer.append(sByte.toLowerCase());
                ++n2;
            }
            return buffer.toString();
        }
        return "";
    }

    private byte[] string2digest(String string) {
        if (string != null && string.length() > 0) {
            int count = string.length() / 2;
            byte[] digest = new byte[count];
            int i = 0;
            while (i < count) {
                try {
                    String seg = string.substring(2 * i, 2 * (i + 1));
                    int d = Integer.parseInt(seg, 16);
                    digest[i] = (byte)d;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            return digest;
        }
        return new byte[0];
    }

    private Map<QualifiedName, String> toQNameMap(Map<String, String> strMap) {
        HashMap<QualifiedName, String> result = new HashMap<QualifiedName, String>();
        for (Map.Entry<String, String> entry : strMap.entrySet()) {
            int dot = entry.getKey().lastIndexOf(":");
            String qualifier = null;
            String local = entry.getKey();
            if (dot != -1) {
                qualifier = entry.getKey().substring(0, dot);
                local = entry.getKey().substring(dot + 1);
            }
            QualifiedName name = new QualifiedName(qualifier, local);
            result.put(name, strMap.get(entry.getKey()));
        }
        return result;
    }

    private URI toURI(final String string) {
        final AtomicReference ref = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                ref.set(new URI(string));
            }
        });
        return (URI)ref.get();
    }
}

