/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IDropToFrameHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.debug.ui.ITCFModel;
import org.eclipse.tcf.debug.ui.ITCFPresentationProvider;
import org.eclipse.tcf.debug.ui.ITCFSourceDisplay;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.adapters.TCFNodePropertySource;
import org.eclipse.tcf.internal.debug.ui.commands.BackIntoCommand;
import org.eclipse.tcf.internal.debug.ui.commands.BackOverCommand;
import org.eclipse.tcf.internal.debug.ui.commands.BackResumeCommand;
import org.eclipse.tcf.internal.debug.ui.commands.BackReturnCommand;
import org.eclipse.tcf.internal.debug.ui.commands.DisconnectCommand;
import org.eclipse.tcf.internal.debug.ui.commands.DropToFrameCommand;
import org.eclipse.tcf.internal.debug.ui.commands.ResumeCommand;
import org.eclipse.tcf.internal.debug.ui.commands.StepIntoCommand;
import org.eclipse.tcf.internal.debug.ui.commands.StepOverCommand;
import org.eclipse.tcf.internal.debug.ui.commands.StepReturnCommand;
import org.eclipse.tcf.internal.debug.ui.commands.SuspendCommand;
import org.eclipse.tcf.internal.debug.ui.commands.TerminateCommand;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.ISourceNotFoundPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFAnnotationManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFColumnPresentationExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFColumnPresentationModules;
import org.eclipse.tcf.internal.debug.ui.model.TCFColumnPresentationRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFConsole;
import org.eclipse.tcf.internal.debug.ui.model.TCFMemoryBlockRetrieval;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelSelectionPolicy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tcf.internal.debug.ui.model.TCFPresentationProvider;
import org.eclipse.tcf.internal.debug.ui.model.TCFSnapshot;
import org.eclipse.tcf.internal.debug.ui.preferences.TCFPreferences;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDisassembly;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProfiler;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TCFModel
implements ITCFModel,
IElementContentProvider,
IElementLabelProvider,
IViewerInputProvider,
IModelProxyFactory,
IColumnPresentationFactory,
ITCFSourceDisplay,
ISuspendTrigger,
IElementMementoProvider {
    public static final String ID_EXPRESSION_HOVER = "org.eclipse.tcf.debug.ui.expression_hover";
    public static final String ID_PINNED_VIEW = "org.eclipse.tcf.debug.ui.pinned_view";
    public static final String SELECT_ADDED = "Added";
    public static final String SELECT_INITIAL = "Launch";
    public static final int UPDATE_POLICY_AUTOMATIC = 0;
    public static final int UPDATE_POLICY_MANUAL = 1;
    public static final int UPDATE_POLICY_BREAKPOINT = 2;
    private final TCFLaunch launch;
    private final Display display;
    private final IExpressionManager expr_manager;
    private final TCFAnnotationManager annotation_manager;
    private InitialSelection initial_selection;
    private final List<ISuspendTriggerListener> suspend_trigger_listeners = new LinkedList<ISuspendTriggerListener>();
    final List<ITCFPresentationProvider> view_request_listeners;
    private final Map<IWorkbenchPage, Object> display_source_generation = new WeakHashMap<IWorkbenchPage, Object>();
    private int suspend_trigger_generation;
    private int auto_disconnect_generation;
    private boolean reverse_debug_enabled;
    private long min_view_updates_interval;
    private boolean view_updates_throttle_enabled;
    private boolean channel_throttle_enabled;
    private boolean wait_for_pc_update_after_step;
    private boolean wait_for_views_update_after_step;
    private boolean delay_stack_update_until_last_step;
    private boolean stack_frames_limit_enabled;
    private int stack_frames_limit_value;
    private boolean show_function_arg_names;
    private boolean show_function_arg_values;
    private boolean delay_children_list_updates;
    private boolean auto_children_list_updates;
    private boolean show_full_error_reports;
    private boolean qualified_type_names_enabled;
    private final Map<String, String> action_results = new HashMap<String, String>();
    private final HashMap<String, TCFAction> active_actions = new HashMap();
    private final List<TCFModelProxy> model_proxies = new ArrayList<TCFModelProxy>();
    private final Map<String, TCFNode> id2node = new HashMap<String, TCFNode>();
    private final Map<Class<?>, Object> adapters = new HashMap();
    private final Map<String, TCFMemoryBlockRetrieval> mem_retrieval = new HashMap<String, TCFMemoryBlockRetrieval>();
    private MemoryBlocksUpdate mem_blocks_update;
    private final Map<String, String> cast_to_type_map = new HashMap<String, String>();
    private final Map<String, Object> context_map = new HashMap<String, Object>();
    private final Map<IWorkbenchPart, TCFNode> pins = new HashMap<IWorkbenchPart, TCFNode>();
    private final Map<IWorkbenchPart, TCFSnapshot> locks = new HashMap<IWorkbenchPart, TCFSnapshot>();
    private final Map<IWorkbenchPart, Integer> lock_policy = new HashMap<IWorkbenchPart, Integer>();
    private final Map<String, TCFConsole> process_consoles = new HashMap<String, TCFConsole>();
    private final List<TCFConsole> debug_consoles = new ArrayList<TCFConsole>();
    private TCFConsole dprintf_console;
    private static final Map<ILaunchConfiguration, IEditorInput> editor_not_found = new HashMap<ILaunchConfiguration, IEditorInput>();
    private final IModelSelectionPolicyFactory model_selection_factory = new IModelSelectionPolicyFactory(){

        public IModelSelectionPolicy createModelSelectionPolicyAdapter(Object element, IPresentationContext context) {
            return TCFModel.this.selection_policy;
        }
    };
    private final IModelSelectionPolicy selection_policy;
    private IChannel channel;
    private TCFNodeLaunch launch_node;
    private boolean disposed;
    private final IMemory.MemoryListener mem_listener = new IMemory.MemoryListener(){

        public void contextAdded(IMemory.MemoryContext[] contexts) {
            IMemory.MemoryContext[] memoryContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IMemory.MemoryContext ctx = memoryContextArray[n2];
                String id = ctx.getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(ctx);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(ctx);
                    }
                }
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextAddedOrRemoved();
        }

        public void contextChanged(IMemory.MemoryContext[] contexts) {
            IMemory.MemoryContext[] memoryContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IMemory.MemoryContext ctx = memoryContextArray[n2];
                String id = ctx.getID();
                TCFNode node = TCFModel.this.getNode(id);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(ctx);
                }
                TCFModel.this.onMemoryChanged(id, true, false, false);
                ++n2;
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void memoryChanged(String id, Number[] addr, long[] size) {
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onMemoryChanged(addr, size);
            }
            TCFModel.this.onMemoryChanged(id, true, false, false);
        }
    };
    private final IRunControl.RunControlListener run_listener = new IRunControl.RunControlListenerV1(){

        public void containerResumed(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TCFNode node = TCFModel.this.getNode(id);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerResumed();
                }
                ++n2;
            }
            TCFModel.this.updateAnnotations(null);
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            boolean func_call = false;
            if (params != null) {
                Boolean b = (Boolean)params.get("FuncCall");
                func_call = b != null && b != false;
            }
            int action_cnt = 0;
            String[] stringArray = suspended_ids;
            int n = suspended_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TCFNode node = TCFModel.this.getNode(id);
                TCFModel.this.action_results.remove(id);
                if (TCFModel.this.active_actions.get(id) != null) {
                    ++action_cnt;
                }
                if (!id.equals(context) && node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerSuspended(func_call);
                }
                TCFModel.this.onMemoryChanged(id, false, true, false);
                ++n2;
            }
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextSuspended(pc, reason, params, func_call);
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
            if (!func_call && action_cnt == 0) {
                TCFModel.this.setDebugViewSelection(node, reason);
                TCFModel.this.updateAnnotations(null);
                TCFNodePropertySource.refresh(node);
            }
            TCFModel.this.action_results.remove(context);
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                String id = ctx.getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(ctx);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(ctx);
                    }
                }
                TCFModel.this.context_map.put(ctx.getID(), ctx);
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextAddedOrRemoved();
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                String id = ctx.getID();
                TCFModel.this.context_map.put(id, ctx);
                TCFNode node = TCFModel.this.getNode(id);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(ctx);
                }
                TCFModel.this.onMemoryChanged(id, true, false, false);
                if (TCFModel.this.active_actions.get(id) == null) {
                    TCFNodePropertySource.refresh(node);
                }
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
        }

        public void contextException(String context, String msg) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextException(msg);
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void contextResumed(String id) {
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextResumed();
            }
            TCFModel.this.updateAnnotations(null);
        }

        public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
            boolean func_call = false;
            if (params != null) {
                Boolean b = (Boolean)params.get("FuncCall");
                func_call = b != null && b != false;
            }
            TCFNode node = TCFModel.this.getNode(id);
            TCFModel.this.action_results.remove(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextSuspended(pc, reason, params, func_call);
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
            if (!func_call && TCFModel.this.active_actions.get(id) == null) {
                TCFModel.this.setDebugViewSelection(node, reason);
                TCFModel.this.updateAnnotations(null);
                TCFNodePropertySource.refresh(node);
            }
            TCFModel.this.onMemoryChanged(id, false, true, false);
        }

        public void contextStateChanged(String id) {
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextStateChanged();
            }
        }
    };
    private final IMemoryMap.MemoryMapListener mmap_listener = new IMemoryMap.MemoryMapListener(){

        public void changed(String id) {
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                TCFNodeExecContext exe = (TCFNodeExecContext)node;
                exe.onMemoryMapChanged();
            }
            TCFModel.this.onMemoryChanged(id, true, false, true);
            TCFModel.this.refreshSourceView();
        }
    };
    private final IPathMap.PathMapListener pmap_listener = new IPathMap.PathMapListener(){

        public void changed() {
            TCFModel.this.refreshSourceView();
        }
    };
    private final IRegisters.RegistersListener reg_listener = new IRegisters.RegistersListener(){

        public void contextChanged() {
            for (TCFNode node : TCFModel.this.id2node.values()) {
                if (!(node instanceof TCFNodeExecContext)) continue;
                ((TCFNodeExecContext)node).onRegistersChanged();
            }
        }

        public void registerChanged(final String id) {
            Runnable done = new Runnable(){

                @Override
                public void run() {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeRegister) {
                        ((TCFNodeRegister)node).onValueChanged();
                    }
                }
            };
            if (TCFModel.this.createNode(id, done)) {
                done.run();
            }
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            IProcesses.ProcessContext prs = TCFModel.this.launch.getProcessContext();
            if (prs != null && process_id.equals(prs.getID())) {
                TCFModel.this.onContextOrProcessRemoved();
            }
        }
    };
    private final IExpressionsListener expressions_listener = new IExpressionsListener(){
        int generation;

        public void expressionsAdded(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsChanged(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsRemoved(IExpression[] expressions) {
            final int g = ++this.generation;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (g != generation) {
                        return;
                    }
                    for (TCFNode n : TCFModel.this.id2node.values()) {
                        if (!(n instanceof TCFNodeExecContext)) continue;
                        ((TCFNodeExecContext)n).onExpressionAddedOrRemoved();
                    }
                    for (TCFModelProxy p : TCFModel.this.model_proxies) {
                        Object o;
                        String id = p.getPresentationContext().getId();
                        if (!"org.eclipse.debug.ui.ExpressionView".equals(id) || !((o = p.getInput()) instanceof TCFNode)) continue;
                        TCFNode n = (TCFNode)o;
                        if (n.model != TCFModel.this) continue;
                        p.addDelta(n, 1024);
                    }
                }
            });
        }
    };
    private final TCFLaunch.ActionsListener actions_listener = new TCFLaunch.ActionsListener(){

        public void onContextActionStart(TCFAction action) {
            String id = action.getContextID();
            TCFModel.this.active_actions.put(id, action);
            TCFModel.this.updateAnnotations(null);
        }

        public void onContextActionResult(String id, String reason) {
            if (reason == null) {
                TCFModel.this.action_results.remove(id);
            } else {
                TCFModel.this.action_results.put(id, reason);
            }
        }

        public void onContextActionDone(final TCFAction action) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    TCFContextState state_data = null;
                    String id = action.getContextID();
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)node).getState();
                        if (!state_cache.validate((Runnable)this)) {
                            return;
                        }
                        state_data = (TCFContextState)state_cache.getData();
                    }
                    if (TCFModel.this.active_actions.get(id) == action) {
                        TCFModel.this.active_actions.remove(id);
                        if (node instanceof TCFNodeExecContext) {
                            ((TCFNodeExecContext)node).onContextActionDone();
                            if (state_data != null && state_data.is_suspended) {
                                String reason = (String)TCFModel.this.action_results.get(id);
                                if (reason == null) {
                                    reason = state_data.suspend_reason;
                                }
                                TCFModel.this.setDebugViewSelection((TCFNode)TCFModel.this.id2node.get(id), reason);
                            }
                        }
                        for (TCFModelProxy p : TCFModel.this.model_proxies) {
                            p.post();
                        }
                        TCFModel.this.updateAnnotations(null);
                        TCFNodePropertySource.refresh(node);
                    }
                    TCFModel.this.launch.removePendingClient((Object)this);
                }
            };
            TCFModel.this.launch.addPendingClient((Object)r);
            Protocol.invokeLater((Runnable)r);
        }
    };
    private final IDebugModelProvider debug_model_provider = new IDebugModelProvider(){

        public String[] getModelIdentifiers() {
            return new String[]{"org.eclipse.tcf.debug"};
        }
    };
    private final IPreferenceStore prefs_store = TCFPreferences.getPreferenceStore();
    private final IPropertyChangeListener prefs_listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TCFModel.this.launch.setContextActionsInterval(TCFModel.this.prefs_store.getLong("MinStepInterval"));
            TCFModel.this.min_view_updates_interval = TCFModel.this.prefs_store.getLong("MinUpdateInterval");
            TCFModel.this.view_updates_throttle_enabled = TCFModel.this.prefs_store.getBoolean("ViewUpdatesThrottle");
            TCFModel.this.channel_throttle_enabled = TCFModel.this.prefs_store.getBoolean("TargetTrafficThrottle");
            TCFModel.this.wait_for_pc_update_after_step = TCFModel.this.prefs_store.getBoolean("WaitForPCUpdateAfterStep");
            TCFModel.this.wait_for_views_update_after_step = TCFModel.this.prefs_store.getBoolean("WaitForViewsUpdateAfterStep");
            TCFModel.this.delay_stack_update_until_last_step = TCFModel.this.prefs_store.getBoolean("DelayStackUpdateUntilLastStep");
            TCFModel.this.stack_frames_limit_enabled = TCFModel.this.prefs_store.getBoolean("StackFrameLimitEnabled");
            TCFModel.this.stack_frames_limit_value = TCFModel.this.prefs_store.getInt("StackFrameLimitValue");
            TCFModel.this.show_function_arg_names = TCFModel.this.prefs_store.getBoolean("StackFrameArgNames");
            TCFModel.this.show_function_arg_values = TCFModel.this.prefs_store.getBoolean("StackFrameArgValues");
            TCFModel.this.auto_children_list_updates = TCFModel.this.prefs_store.getBoolean("AutoChildrenListUpdates");
            TCFModel.this.delay_children_list_updates = TCFModel.this.prefs_store.getBoolean("DelayChildrenListUpdates");
            TCFModel.this.show_full_error_reports = TCFModel.this.prefs_store.getBoolean("FullErrorReports");
            TCFModel.this.qualified_type_names_enabled = TCFModel.this.prefs_store.getBoolean("ShowQualifiedTypeNames");
            final boolean affectsExpressionsOnly = event != null && "ShowQualifiedTypeNames".equals(event.getProperty());
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (TCFNode n : TCFModel.this.id2node.values()) {
                        if (n instanceof TCFNodeExecContext && !affectsExpressionsOnly) {
                            ((TCFNodeExecContext)n).onPreferencesChanged();
                            continue;
                        }
                        if (!(n instanceof TCFNodeExpression) || !affectsExpressionsOnly) continue;
                        ((TCFNodeExpression)n).onPreferencesChanged();
                    }
                }
            });
        }
    };
    private volatile boolean instruction_stepping_enabled;
    private final List<ProfilerDataListener> profiler_listeners = new ArrayList<ProfilerDataListener>();
    private final Map<String, TCFDataCache<Map<String, Object>>> profiler_capabilities = new HashMap<String, TCFDataCache<Map<String, Object>>>();
    private final Map<String, Map<String, Object>> profiler_configuration = new HashMap<String, Map<String, Object>>();
    private final Map<String, IToken> profiler_read_cmds = new HashMap<String, IToken>();
    private final Runnable profiler_read_event = new Runnable(){

        @Override
        public void run() {
            if (!$assertionsDisabled && !TCFModel.this.profiler_read_posted) {
                throw new AssertionError();
            }
            IProfiler profiler = (IProfiler)TCFModel.this.channel.getRemoteService(IProfiler.class);
            for (final String ctx : TCFModel.this.profiler_configuration.keySet()) {
                if (TCFModel.this.profiler_read_cmds.get(ctx) != null) continue;
                TCFModel.this.profiler_read_cmds.put(ctx, profiler.read(ctx, new IProfiler.DoneRead(){

                    public void doneRead(IToken token, Exception error, Map<String, Object>[] data) {
                        TCFModel.this.profiler_read_cmds.remove(ctx);
                        if (error != null && TCFModel.this.channel.getState() == 1) {
                            Protocol.log((String)"Cannot read profiler data", (Throwable)error);
                        }
                        if (data != null) {
                            for (ProfilerDataListener listener : TCFModel.this.profiler_listeners) {
                                listener.onDataReceived(ctx, data);
                            }
                        }
                    }
                }));
            }
            if (TCFModel.this.profiler_configuration.size() > 0) {
                Protocol.invokeLater((long)TCFModel.this.profiler_read_delay, (Runnable)this);
            } else {
                TCFModel.this.profiler_read_posted = false;
            }
        }
    };
    private boolean profiler_read_posted;
    private long profiler_read_delay = 4000L;

    TCFModel(TCFLaunch launch) {
        this.launch = launch;
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.selection_policy = new TCFModelSelectionPolicy(this);
        this.adapters.put(ILaunch.class, launch);
        this.adapters.put(IModelSelectionPolicy.class, this.selection_policy);
        this.adapters.put(IModelSelectionPolicyFactory.class, this.model_selection_factory);
        this.adapters.put(IDebugModelProvider.class, this.debug_model_provider);
        this.adapters.put(ISuspendHandler.class, new SuspendCommand(this));
        this.adapters.put(IResumeHandler.class, new ResumeCommand(this));
        this.adapters.put(BackResumeCommand.class, new BackResumeCommand(this));
        this.adapters.put(ITerminateHandler.class, new TerminateCommand(this));
        this.adapters.put(IDisconnectHandler.class, new DisconnectCommand(this));
        this.adapters.put(IStepIntoHandler.class, new StepIntoCommand(this));
        this.adapters.put(IStepOverHandler.class, new StepOverCommand(this));
        this.adapters.put(IStepReturnHandler.class, new StepReturnCommand(this));
        this.adapters.put(BackIntoCommand.class, new BackIntoCommand(this));
        this.adapters.put(BackOverCommand.class, new BackOverCommand(this));
        this.adapters.put(BackReturnCommand.class, new BackReturnCommand(this));
        this.adapters.put(IDropToFrameHandler.class, new DropToFrameCommand(this));
        this.expr_manager = DebugPlugin.getDefault().getExpressionManager();
        this.expr_manager.addExpressionListener(this.expressions_listener);
        this.annotation_manager = Activator.getAnnotationManager();
        launch.addActionsListener(this.actions_listener);
        this.prefs_listener.propertyChange(null);
        this.prefs_store.addPropertyChangeListener(this.prefs_listener);
        ArrayList<ITCFPresentationProvider> l = new ArrayList<ITCFPresentationProvider>();
        for (ITCFPresentationProvider p : TCFPresentationProvider.getPresentationProviders()) {
            try {
                if (!p.onModelCreated(this)) continue;
                l.add(p);
            }
            catch (Throwable x) {
                Activator.log("Unhandled exception in a presentation provider", x);
            }
        }
        this.view_request_listeners = l.size() > 0 ? l : null;
        TCFMemoryBlockRetrieval.onModelCreated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdapter(Class<?> adapterType, Object adapter) {
        Map<Class<?>, Object> map = this.adapters;
        synchronized (map) {
            this.adapters.put(adapterType, adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(final Class adapter, final TCFNode node) {
        Map<Class<?>, Object> map = this.adapters;
        synchronized (map) {
            Object o = this.adapters.get(adapter);
            if (o != null) {
                return o;
            }
        }
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return new TCFTask<Object>(){

                public void run() {
                    TCFMemoryBlockRetrieval o = null;
                    TCFDataCache<TCFNodeExecContext> cache = TCFModel.this.searchMemoryContext(node);
                    if (cache != null) {
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (cache.getData() != null) {
                            TCFNodeExecContext ctx = (TCFNodeExecContext)cache.getData();
                            if (!ctx.getMemoryContext().validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (ctx.getMemoryContext().getError() == null) {
                                o = TCFModel.this.getMemoryBlockRetrieval(ctx);
                            }
                        }
                    }
                    if (!$assertionsDisabled && o != null && !adapter.isInstance(o)) {
                        throw new AssertionError();
                    }
                    this.done(o);
                }
            }.getE();
        }
        return null;
    }

    TCFMemoryBlockRetrieval getMemoryBlockRetrieval(TCFNodeExecContext node) {
        TCFMemoryBlockRetrieval r = this.mem_retrieval.get(node.id);
        if (r == null) {
            r = new TCFMemoryBlockRetrieval(node);
            this.mem_retrieval.put(node.id, r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncExec(Runnable r) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.display.isDisposed()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.display.asyncExec(r);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void onConnected() {
        IProcesses prs;
        IRegisters reg;
        IPathMap pmap;
        IMemoryMap mmap;
        IRunControl run;
        assert (Protocol.isDispatchThread());
        assert (this.launch_node == null);
        this.channel = this.launch.getChannel();
        this.launch_node = new TCFNodeLaunch(this);
        IMemory mem = (IMemory)this.launch.getService(IMemory.class);
        if (mem != null) {
            mem.addListener(this.mem_listener);
        }
        if ((run = (IRunControl)this.launch.getService(IRunControl.class)) != null) {
            run.addListener(this.run_listener);
        }
        if ((mmap = (IMemoryMap)this.launch.getService(IMemoryMap.class)) != null) {
            mmap.addListener(this.mmap_listener);
        }
        if ((pmap = (IPathMap)this.launch.getService(IPathMap.class)) != null) {
            pmap.addListener(this.pmap_listener);
        }
        if ((reg = (IRegisters)this.launch.getService(IRegisters.class)) != null) {
            reg.addListener(this.reg_listener);
        }
        if ((prs = (IProcesses)this.launch.getService(IProcesses.class)) != null) {
            prs.addListener(this.prs_listener);
        }
        this.launchChanged();
        for (TCFModelProxy p : this.model_proxies) {
            String id = p.getPresentationContext().getId();
            if (!"org.eclipse.debug.ui.DebugView".equals(id)) continue;
            Protocol.invokeLater((Runnable)new InitialSelection(p));
        }
        if (this.launch.isProcessExited()) {
            this.onContextOrProcessRemoved();
        }
        for (TCFConsole c : this.process_consoles.values()) {
            c.onModelConnected();
        }
    }

    void onDisconnected() {
        assert (Protocol.isDispatchThread());
        if (this.locks.size() > 0) {
            TCFSnapshot[] arr = this.locks.values().toArray(new TCFSnapshot[this.locks.size()]);
            this.locks.clear();
            TCFSnapshot[] tCFSnapshotArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                TCFSnapshot s = tCFSnapshotArray[n2];
                s.dispose();
                ++n2;
            }
        }
        if (this.launch.getChannel() != null) {
            IProcesses prs;
            IRegisters reg;
            IPathMap pmap;
            IMemoryMap mmap;
            IRunControl run;
            IMemory mem = (IMemory)this.launch.getService(IMemory.class);
            if (mem != null) {
                mem.removeListener(this.mem_listener);
            }
            if ((run = (IRunControl)this.launch.getService(IRunControl.class)) != null) {
                run.removeListener(this.run_listener);
            }
            if ((mmap = (IMemoryMap)this.launch.getService(IMemoryMap.class)) != null) {
                mmap.removeListener(this.mmap_listener);
            }
            if ((pmap = (IPathMap)this.launch.getService(IPathMap.class)) != null) {
                pmap.removeListener(this.pmap_listener);
            }
            if ((reg = (IRegisters)this.launch.getService(IRegisters.class)) != null) {
                reg.removeListener(this.reg_listener);
            }
            if ((prs = (IProcesses)this.launch.getService(IProcesses.class)) != null) {
                prs.removeListener(this.prs_listener);
            }
        }
        if (this.launch_node != null) {
            this.launch_node.dispose();
            this.launch_node = null;
        }
        for (TCFMemoryBlockRetrieval r : this.mem_retrieval.values()) {
            r.dispose();
        }
        this.mem_retrieval.clear();
        this.refreshLaunchView();
        assert (this.id2node.size() == 0);
        TCFMemoryBlockRetrieval.onModelDisconnected(this);
    }

    void onProcessOutput(String ctx_id, int stream_id, byte[] data) {
        if (ctx_id != null) {
            TCFConsole c = this.process_consoles.get(ctx_id);
            if (c == null) {
                int type = 3;
                IProcesses.ProcessContext prs = this.launch.getProcessContext();
                if (prs != null && ctx_id != null && ctx_id.equals(prs.getID())) {
                    type = 2;
                    boolean use_terminal = true;
                    try {
                        use_terminal = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.tcf.debug.UseTerminal", true);
                    }
                    catch (CoreException coreException) {}
                    if (!use_terminal) {
                        type = 1;
                    }
                }
                c = new TCFConsole(this, type, ctx_id);
                this.process_consoles.put(ctx_id, c);
                if (this.launch_node != null) {
                    c.onModelConnected();
                }
            }
            c.write(stream_id, data);
        } else {
            if (this.dprintf_console == null) {
                this.dprintf_console = new TCFConsole(this, 5, null);
            }
            this.dprintf_console.write(stream_id, data);
        }
    }

    void onProcessStreamError(String process_id, int stream_id, Exception x, int lost_size) {
        if (this.channel != null && this.channel.getState() == 2) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Debugger console IO error");
        if (process_id != null) {
            bf.append(". Process ID ");
            bf.append(process_id);
        }
        bf.append(". Stream ");
        bf.append(stream_id);
        if (lost_size > 0) {
            bf.append(". Lost data size ");
            bf.append(lost_size);
        }
        Activator.log(bf.toString(), x);
    }

    void onMemoryChanged(String id, boolean notify_references, boolean context_suspended, boolean mem_map) {
        if (this.channel == null) {
            return;
        }
        if (notify_references) {
            for (Object obj : this.context_map.values()) {
                TCFNode subnode;
                IRunControl.RunControlContext subctx;
                if (!(obj instanceof IRunControl.RunControlContext) || !id.equals((subctx = (IRunControl.RunControlContext)obj).getProcessID()) || id.equals(subctx.getID()) || !((subnode = this.getNode(subctx.getID())) instanceof TCFNodeExecContext)) continue;
                if (mem_map) {
                    ((TCFNodeExecContext)subnode).onMemoryMapChanged();
                    continue;
                }
                ((TCFNodeExecContext)subnode).onMemoryChanged(null, null);
            }
        }
        if (this.mem_retrieval.size() == 0) {
            return;
        }
        if (this.mem_blocks_update == null) {
            this.mem_blocks_update = new MemoryBlocksUpdate(this.channel);
            if (this.wait_for_views_update_after_step) {
                this.launch.addPendingClient((Object)this.mem_blocks_update);
            }
        }
        this.mem_blocks_update.add(id, context_suspended);
    }

    public TCFAction getActiveAction(String id) {
        return this.active_actions.get(id);
    }

    String getContextActionResult(String id) {
        return this.action_results.get(id);
    }

    public long getMinViewUpdatesInterval() {
        return this.min_view_updates_interval;
    }

    public boolean getViewUpdatesThrottleEnabled() {
        return this.view_updates_throttle_enabled;
    }

    public boolean getWaitForViewsUpdateAfterStep() {
        return this.wait_for_views_update_after_step;
    }

    public boolean getDelayStackUpdateUtilLastStep() {
        return this.delay_stack_update_until_last_step;
    }

    public boolean getChannelThrottleEnabled() {
        return this.channel_throttle_enabled;
    }

    public boolean getStackFramesLimitEnabled() {
        return this.stack_frames_limit_enabled;
    }

    public int getStackFramesLimitValue() {
        return this.stack_frames_limit_value;
    }

    public boolean getShowFunctionArgNames() {
        return this.show_function_arg_names;
    }

    public boolean getShowFunctionArgValues() {
        return this.show_function_arg_values;
    }

    public boolean getAutoChildrenListUpdates() {
        return this.auto_children_list_updates;
    }

    public boolean getDelayChildrenListUpdates() {
        return this.delay_children_list_updates;
    }

    public boolean getShowFullErrorReports() {
        return this.show_full_error_reports;
    }

    void onProxyInstalled(TCFModelProxy mp) {
        IPresentationContext pc = mp.getPresentationContext();
        this.model_proxies.add(mp);
        if (this.launch_node != null && pc.getId().equals("org.eclipse.debug.ui.DebugView")) {
            Protocol.invokeLater((Runnable)new InitialSelection(mp));
        }
    }

    void onProxyDisposed(TCFModelProxy mp) {
        this.model_proxies.remove(mp);
    }

    private void onContextRemoved(String[] context_ids) {
        int n;
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = context_ids;
        int n2 = context_ids.length;
        int n3 = 0;
        while (n3 < n2) {
            String id = stringArray[n3];
            this.launch_node.onContextRemoved(id);
            TCFNode node = this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextRemoved();
                for (TCFModelProxy p : this.model_proxies) {
                    p.saveExpandState(node);
                    p.clearAutoExpandStack(id);
                }
            }
            this.action_results.remove(id);
            if (this.mem_blocks_update != null) {
                this.mem_blocks_update.changeset.remove(id);
            }
            set.add(id);
            ++n3;
        }
        do {
            n = set.size();
            for (Map.Entry<String, Object> e : this.context_map.entrySet()) {
                String pid;
                IRunControl.RunControlContext x;
                Object obj = e.getValue();
                if (obj instanceof IRunControl.RunControlContext) {
                    x = (IRunControl.RunControlContext)obj;
                    if (set.contains(x.getParentID())) {
                        set.add(x.getID());
                    }
                    if ((pid = x.getProcessID()) == null || !set.contains(pid)) continue;
                    set.add(x.getID());
                    continue;
                }
                if (obj instanceof IStackTrace.StackTraceContext) {
                    x = (IStackTrace.StackTraceContext)obj;
                    if (!set.contains(x.getParentID())) continue;
                    set.add(x.getID());
                    continue;
                }
                if (obj instanceof IRegisters.RegistersContext) {
                    x = (IRegisters.RegistersContext)obj;
                    if (set.contains(x.getParentID())) {
                        set.add(x.getID());
                    }
                    if ((pid = x.getProcessID()) == null || !set.contains(pid)) continue;
                    set.add(x.getID());
                    continue;
                }
                if (!(obj instanceof Throwable)) continue;
                set.add(e.getKey());
            }
        } while (n != set.size());
        this.context_map.keySet().removeAll(set);
        this.launch_node.onAnyContextAddedOrRemoved();
        this.onContextOrProcessRemoved();
        this.updateAnnotations(null);
    }

    void onContextRunning() {
        this.updateAnnotations(null);
    }

    Map<String, Object> getContextMap() {
        return this.context_map;
    }

    private void onContextOrProcessRemoved() {
        final int generation = ++this.auto_disconnect_generation;
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (generation != TCFModel.this.auto_disconnect_generation) {
                    return;
                }
                if (TCFModel.this.launch_node == null) {
                    return;
                }
                if (TCFModel.this.launch_node.isDisposed()) {
                    return;
                }
                TCFChildren children = TCFModel.this.launch_node.getFilteredChildren();
                if (!children.validate(this)) {
                    return;
                }
                if (children.size() > 0) {
                    return;
                }
                TCFModel.this.launch.onLastContextRemoved();
            }
        });
    }

    void launchChanged() {
        if (this.launch_node != null) {
            for (TCFModelProxy p : this.model_proxies) {
                String id = p.getPresentationContext().getId();
                if (!"org.eclipse.debug.ui.DebugView".equals(id)) continue;
                p.addDelta(this.launch_node, 3072);
            }
        } else {
            this.refreshLaunchView();
        }
    }

    public TCFModelProxy[] getModelProxies(IPresentationContext ctx) {
        TCFModelProxy[] proxies = new TCFModelProxy[]{};
        for (TCFModelProxy proxy : this.model_proxies) {
            if (!ctx.equals(proxy.getPresentationContext())) continue;
            TCFModelProxy[] old_proxies = proxies;
            proxies = new TCFModelProxy[proxies.length + 1];
            System.arraycopy(old_proxies, 0, proxies, 0, old_proxies.length);
            proxies[proxies.length - 1] = proxy;
        }
        return proxies;
    }

    public Collection<TCFModelProxy> getModelProxies() {
        return this.model_proxies;
    }

    void dispose() {
        assert (Protocol.isDispatchThread());
        if (this.launch_node != null) {
            this.onDisconnected();
        }
        if (this.view_request_listeners != null) {
            for (ITCFPresentationProvider p : this.view_request_listeners) {
                try {
                    p.onModelDisposed(this);
                }
                catch (Throwable x) {
                    Activator.log("Unhandled exception in a presentation provider", x);
                }
            }
        }
        this.prefs_store.removePropertyChangeListener(this.prefs_listener);
        this.launch.removeActionsListener(this.actions_listener);
        this.expr_manager.removeExpressionListener(this.expressions_listener);
        for (TCFConsole c : this.process_consoles.values()) {
            c.close();
        }
        for (TCFConsole c : this.debug_consoles) {
            c.close();
        }
        if (this.dprintf_console != null) {
            this.dprintf_console.close();
        }
        this.process_consoles.clear();
        this.debug_consoles.clear();
        this.dprintf_console = null;
        this.context_map.clear();
        assert (this.id2node.size() == 0);
        this.disposed = true;
    }

    void addNode(String id, TCFNode node) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        assert (this.id2node.get(id) == null);
        assert (this.launch_node != null);
        assert (!node.isDisposed());
        this.id2node.put(id, node);
    }

    void removeNode(String id) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        this.id2node.remove(id);
        TCFMemoryBlockRetrieval r = this.mem_retrieval.remove(id);
        if (r != null) {
            r.dispose();
        }
    }

    void flushAllCaches() {
        ISourceLocator l = this.launch.getSourceLocator();
        if (l instanceof ISourceLookupDirector) {
            ISourceLookupDirector d = (ISourceLookupDirector)l;
            ISourceLookupParticipant[] participants = d.getParticipants();
            int i = 0;
            while (i < participants.length) {
                ISourceLookupParticipant participant = participants[i];
                participant.sourceContainersChanged(d);
                ++i;
            }
        }
        for (TCFMemoryBlockRetrieval b : this.mem_retrieval.values()) {
            b.flushAllCaches();
        }
        for (TCFNode n : this.id2node.values()) {
            n.flushAllCaches();
        }
        this.launch_node.flushAllCaches();
    }

    public IExpressionManager getExpressionManager() {
        return this.expr_manager;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    public TCFLaunch getLaunch() {
        return this.launch;
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    public TCFNodeLaunch getRootNode() {
        return this.launch_node;
    }

    public TCFChildren getHoverExpressionCache(TCFNode parent, String expression) {
        assert (Protocol.isDispatchThread());
        if (parent instanceof TCFNodeStackFrame) {
            return ((TCFNodeStackFrame)parent).getHoverExpressionCache(expression);
        }
        if (parent instanceof TCFNodeExecContext) {
            return ((TCFNodeExecContext)parent).getHoverExpressionCache(expression);
        }
        return null;
    }

    @Override
    public TCFNode getNode(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals("")) {
            return this.launch_node;
        }
        assert (Protocol.isDispatchThread());
        return this.id2node.get(id);
    }

    public String getCastToType(String id) {
        return this.cast_to_type_map.get(id);
    }

    public void setCastToType(String id, String type) {
        if (type != null && type.trim().length() == 0) {
            type = null;
        }
        if (type == null) {
            this.cast_to_type_map.remove(id);
        } else {
            this.cast_to_type_map.put(id, type);
        }
        TCFNode node = this.id2node.get(id);
        if (node instanceof ICastToType) {
            ((ICastToType)((Object)node)).onCastToTypeChanged();
        }
    }

    public TCFDataCache<ISymbols.Symbol> getSymbolInfoCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getContext();
    }

    public TCFDataCache<String[]> getSymbolChildrenCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getChildren();
    }

    public TCFDataCache<Map<String, Object>> getSymbolLocationCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getLocation();
    }

    public TCFDataCache<TCFNodeExecContext> searchMemoryContext(TCFNode node) {
        TCFNode n = node;
        while (n != null && !n.isDisposed()) {
            if (n instanceof TCFNodeExecContext) {
                return ((TCFNodeExecContext)n).getMemoryNode();
            }
            n = n.parent;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean createNode(String id, Runnable done) {
        parent = this.getNode(id);
        if (parent != null) {
            return true;
        }
        path = null;
        while (true) {
            if ((obj = this.context_map.get(id)) == null) {
                obj = new CreateNodeRunnable(id);
            }
            if (obj instanceof CreateNodeRunnable) {
                ((CreateNodeRunnable)obj).wait(done);
                return false;
            }
            if (obj instanceof Throwable) {
                if (done instanceof TCFDataCache) {
                    ((TCFDataCache)done).set(null, (Throwable)obj, null);
                }
                return true;
            }
            if (path == null) {
                path = new LinkedList<Object>();
            }
            path.add(obj);
            parent_id = null;
            parent_id = obj instanceof IRunControl.RunControlContext != false ? ((IRunControl.RunControlContext)obj).getParentID() : (obj instanceof IStackTrace.StackTraceContext != false ? ((IStackTrace.StackTraceContext)obj).getParentID() : ((IRegisters.RegistersContext)obj).getParentID());
            v0 /* !! */  = parent = parent_id == null ? this.launch_node : this.getNode(parent_id);
            if (parent != null) ** GOTO lbl56
            id = parent_id;
        }
lbl-1000:
        // 1 sources

        {
            obj = path.removeLast();
            if (obj instanceof IRunControl.RunControlContext) {
                ctx = (IRunControl.RunControlContext)obj;
                n = new TCFNodeExecContext(parent, ctx.getID());
                if (parent instanceof TCFNodeLaunch) {
                    ((TCFNodeLaunch)parent).getChildren().add(n);
                } else {
                    ((TCFNodeExecContext)parent).getChildren().add(n);
                }
                n.setRunContext(ctx);
                parent = n;
                continue;
            }
            if (obj instanceof IStackTrace.StackTraceContext) {
                ctx = (IStackTrace.StackTraceContext)obj;
                n = new TCFNodeStackFrame((TCFNodeExecContext)parent, ctx.getID(), false);
                ((TCFNodeExecContext)parent).getStackTrace().add(n);
                parent = n;
                continue;
            }
            if (obj instanceof IRegisters.RegistersContext) {
                ctx = (IRegisters.RegistersContext)obj;
                n = new TCFNodeRegister(parent, ctx.getID());
                if (parent instanceof TCFNodeRegister) {
                    ((TCFNodeRegister)parent).getChildren().add(n);
                } else if (parent instanceof TCFNodeStackFrame) {
                    ((TCFNodeStackFrame)parent).getRegisters().add(n);
                } else {
                    ((TCFNodeExecContext)parent).getRegisters().add(n);
                }
                parent = n;
                continue;
            }
            if (!TCFModel.$assertionsDisabled) {
                throw new AssertionError();
            }
lbl56:
            // 6 sources

            ** while (path.size() > 0)
        }
lbl57:
        // 1 sources

        return true;
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            Object o = update.getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(update);
                } else {
                    update.setChildCount(0);
                    update.done();
                }
            } else {
                ((TCFNode)o).update(update);
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            Object o = update.getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(update);
                } else {
                    update.done();
                }
            } else {
                ((TCFNode)o).update(update);
            }
            ++n2;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            Object o = update.getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(update);
                } else {
                    update.setHasChilren(false);
                    update.done();
                }
            } else {
                ((TCFNode)o).update(update);
            }
            ++n2;
        }
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            Object o = update.getElement();
            assert (!(o instanceof TCFLaunch));
            ((TCFNode)o).update(update);
            ++n2;
        }
    }

    public void update(final IViewerInputUpdate update) {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TCFNode node = (TCFNode)TCFModel.this.pins.get(update.getPresentationContext().getPart());
                if (node != null) {
                    node.update(update);
                } else {
                    IViewerInputProvider p;
                    if ("org.eclipse.debug.ui.BreakpointView".equals(update.getPresentationContext().getId()) && (p = (IViewerInputProvider)TCFModel.this.launch.getAdapter(IViewerInputProvider.class)) != null) {
                        p.update(update);
                        return;
                    }
                    Object o = update.getElement();
                    if (o instanceof TCFLaunch) {
                        update.setInputElement(o);
                        update.done();
                    } else {
                        ((TCFNode)o).update(update);
                    }
                }
            }
        });
    }

    public void encodeElements(final IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            if (element instanceof TCFNode) {
                ((TCFNode)element).encodeElement(request);
            }
            ++n2;
        }
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IElementMementoRequest[] iElementMementoRequestArray = requests;
                int n = requests.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementMementoRequest request = iElementMementoRequestArray[n2];
                    request.done();
                    ++n2;
                }
            }
        });
    }

    public void compareElements(final IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            if (element instanceof TCFNode) {
                ((TCFNode)element).compareElements(request);
            }
            ++n2;
        }
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IElementCompareRequest[] iElementCompareRequestArray = requests;
                int n = requests.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementCompareRequest request = iElementCompareRequestArray[n2];
                    request.done();
                    ++n2;
                }
            }
        });
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        return new TCFModelProxy(this);
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        String id = this.getColumnPresentationId(context, element);
        if (id == null) {
            return null;
        }
        if (id.equals("Registers")) {
            return new TCFColumnPresentationRegister();
        }
        if (id.equals("Expressions")) {
            return new TCFColumnPresentationExpression();
        }
        if (id.equals("Modules")) {
            return new TCFColumnPresentationModules();
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        if ("org.eclipse.debug.ui.RegisterView".equals(context.getId())) {
            return "Registers";
        }
        if ("org.eclipse.debug.ui.VariableView".equals(context.getId())) {
            return "Expressions";
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(context.getId())) {
            return "Expressions";
        }
        if (ID_EXPRESSION_HOVER.equals(context.getId())) {
            return "Expressions";
        }
        if ("org.eclipse.debug.ui.ModuleView".equals(context.getId())) {
            return "Modules";
        }
        return null;
    }

    public void setPin(IWorkbenchPart part, TCFNode node) {
        assert (Protocol.isDispatchThread());
        if (node == null) {
            this.pins.remove(part);
        } else {
            this.pins.put(part, node);
        }
    }

    private IPresentationContext getPresentationContext(IWorkbenchPart part) {
        Viewer viewer;
        if (part instanceof IDebugView && (viewer = ((IDebugView)part).getViewer()) instanceof ITreeModelViewer) {
            ITreeModelViewer t = (ITreeModelViewer)viewer;
            return t.getPresentationContext();
        }
        return null;
    }

    public void setLock(IWorkbenchPart part) {
        if (this.launch_node == null) {
            return;
        }
        IPresentationContext ctx = this.getPresentationContext(part);
        if (ctx == null) {
            return;
        }
        this.locks.put(part, new TCFSnapshot(ctx));
        for (TCFModelProxy proxy : this.model_proxies) {
            if (!ctx.equals(proxy.getPresentationContext())) continue;
            proxy.addDelta((TCFNode)proxy.getInput(), 1024);
        }
    }

    public boolean isLocked(IWorkbenchPart part) {
        return this.locks.get(part) != null;
    }

    public boolean clearLock(IWorkbenchPart part) {
        TCFSnapshot snapshot = this.locks.remove(part);
        if (snapshot == null) {
            return false;
        }
        snapshot.dispose();
        IPresentationContext ctx = this.getPresentationContext(part);
        if (ctx != null) {
            for (TCFModelProxy proxy : this.model_proxies) {
                if (!ctx.equals(proxy.getPresentationContext())) continue;
                proxy.addDelta((TCFNode)proxy.getInput(), 1024);
            }
        }
        return true;
    }

    public void setLockPolicy(IWorkbenchPart part, int policy) {
        if (policy == 0) {
            this.clearLock(part);
            this.lock_policy.remove(part);
        } else {
            if (!this.isLocked(part)) {
                this.setLock(part);
            }
            this.lock_policy.put(part, policy);
        }
    }

    public int getLockPolicy(IWorkbenchPart part) {
        if (this.locks.get(part) == null) {
            return 0;
        }
        Integer i = this.lock_policy.get(part);
        if (i == null || i == 0) {
            return 1;
        }
        return i;
    }

    TCFSnapshot getSnapshot(IPresentationContext ctx) {
        return this.locks.get(ctx.getPart());
    }

    public void setDebugViewSelection(TCFNode node, String reason) {
        assert (Protocol.isDispatchThread());
        if (node == null) {
            return;
        }
        if (node.isDisposed()) {
            return;
        }
        if (!SELECT_ADDED.equals(reason)) {
            this.runSuspendTrigger(node);
        }
        if (this.initial_selection != null) {
            Protocol.invokeLater((Runnable)this.initial_selection);
        }
        if (reason == null) {
            return;
        }
        for (TCFModelProxy proxy : this.model_proxies) {
            IWorkbenchPart part;
            int policy;
            if (proxy.getPresentationContext().getId().equals("org.eclipse.debug.ui.DebugView")) {
                this.setDebugViewSelectionForProxy(proxy, node, reason);
            }
            if (!reason.equals("Breakpoint") || (policy = this.getLockPolicy(part = proxy.getPresentationContext().getPart())) != 2) continue;
            this.clearLock(part);
            this.setLock(part);
        }
    }

    public boolean setDebugViewSelectionForProxy(TCFModelProxy proxy, TCFNode node, String reason) {
        boolean user_request;
        assert (Protocol.isDispatchThread());
        if (!proxy.getPresentationContext().getId().equals("org.eclipse.debug.ui.DebugView")) {
            return false;
        }
        if (node == null) {
            return false;
        }
        if (node.isDisposed()) {
            return false;
        }
        if (reason == null) {
            return false;
        }
        boolean bl = user_request = reason.equals("Suspended") || reason.equals("Step") || reason.equals("Container") || this.delay_stack_update_until_last_step && this.launch.getContextActionsCount(node.id) != 0;
        if (proxy.getAutoExpandNode(node, user_request)) {
            proxy.expand(node);
        }
        if (reason.equals("Suspended") || reason.equals(SELECT_ADDED)) {
            return false;
        }
        if (this.initial_selection != null && !reason.equals(SELECT_INITIAL)) {
            this.initial_selection = null;
        }
        proxy.setSelection(node);
        return true;
    }

    public void updateAnnotations(IWorkbenchWindow window) {
        this.annotation_manager.updateAnnotations(window, this.launch);
    }

    private synchronized Object displaySourceStart(IWorkbenchPage page, boolean wait) {
        Object prev;
        Object generation = new Object();
        if (wait) {
            this.launch.addPendingClient(generation);
        }
        if (page != null && (prev = this.display_source_generation.put(page, generation)) != null) {
            this.launch.removePendingClient(prev);
        }
        return generation;
    }

    private synchronized boolean displaySourceCheck(IWorkbenchPage page, Object generation) {
        return page == null || generation == this.display_source_generation.get(page);
    }

    private synchronized void displaySourceEnd(Object generation) {
        this.launch.removePendingClient(generation);
    }

    public void displaySource(Object model_element, final IWorkbenchPage page, boolean forceSourceLookup) {
        ISelection context;
        final Object generation = this.displaySourceStart(page, this.wait_for_pc_update_after_step);
        if (page != null && (context = DebugUITools.getDebugContextManager().getContextService(page.getWorkbenchWindow()).getActiveContext()) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)context;
            model_element = selection.isEmpty() ? null : selection.getFirstElement();
        }
        final Object element = model_element;
        Protocol.invokeLater((long)25L, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!TCFModel.this.displaySourceCheck(page, generation)) {
                    return;
                }
                TCFNodeStackFrame stack_frame = null;
                if (!TCFModel.this.disposed && TCFModel.this.channel.getState() == 1) {
                    if (element instanceof TCFNodeExecContext) {
                        TCFNodeExecContext exec_ctx = (TCFNodeExecContext)element;
                        if (!exec_ctx.isDisposed() && TCFModel.this.active_actions.get(exec_ctx.id) == null) {
                            TCFContextState state_data;
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            if (!exec_ctx.isNotActive() && (state_data = (TCFContextState)state_cache.getData()) != null && state_data.is_suspended) {
                                TCFChildrenStackTrace stack_trace = exec_ctx.getStackTrace();
                                if (!stack_trace.validate(this)) {
                                    return;
                                }
                                stack_frame = stack_trace.getTopFrame();
                            }
                        }
                    } else if (element instanceof TCFNodeStackFrame) {
                        TCFNodeStackFrame f = (TCFNodeStackFrame)element;
                        TCFNodeExecContext exec_ctx = (TCFNodeExecContext)f.parent;
                        if (!f.isDisposed() && !exec_ctx.isDisposed() && TCFModel.this.active_actions.get(exec_ctx.id) == null) {
                            TCFContextState state_data;
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            if (!exec_ctx.isNotActive() && (state_data = (TCFContextState)state_cache.getData()) != null && state_data.is_suspended) {
                                TCFChildrenStackTrace stack_trace = exec_ctx.getStackTrace();
                                if (!stack_trace.validate(this)) {
                                    return;
                                }
                                stack_frame = f;
                            }
                        }
                    }
                }
                String ctx_id = null;
                String mem_id = null;
                boolean top_frame = false;
                ILineNumbers.CodeArea area = null;
                if (stack_frame != null) {
                    TCFDataCache<TCFSourceRef> line_info = stack_frame.getLineInfo();
                    if (!line_info.validate((Runnable)this)) {
                        return;
                    }
                    Throwable error = line_info.getError();
                    TCFSourceRef src_ref = (TCFSourceRef)line_info.getData();
                    if (error == null && src_ref != null) {
                        error = src_ref.error;
                    }
                    if (error != null) {
                        Activator.log("Error retrieving source mapping for a stack frame", error);
                    }
                    if (src_ref != null) {
                        mem_id = src_ref.context_id;
                        area = src_ref.area;
                    }
                    top_frame = stack_frame.getFrameNo() == 0;
                    ctx_id = stack_frame.parent.id;
                }
                TCFModel.this.displaySource(generation, page, element, ctx_id, mem_id, top_frame, area);
            }
        });
    }

    @Override
    public ITextEditor displaySource(final String context_id, String source_file_name, int line) {
        TCFModelPresentation presentation;
        if (PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        String editor_id = null;
        IEditorInput editor_input = null;
        Object source_element = TCFSourceLookupDirector.lookup((TCFLaunch)this.launch, (String)context_id, (Object)source_file_name);
        if (source_element != null && (editor_input = (presentation = TCFModelPresentation.getDefault()).getEditorInput(source_element)) != null) {
            editor_id = presentation.getEditorId(editor_input, source_element);
        }
        if (editor_input == null || editor_id == null) {
            ISourceNotFoundPresentation presentation2;
            ILaunchConfiguration cfg = this.launch.getLaunchConfiguration();
            TCFNode node = (TCFNode)new TCFTask<TCFNode>(this.channel){

                public void run() {
                    if (!TCFModel.this.createNode(context_id, (Runnable)((Object)this))) {
                        return;
                    }
                    this.done(TCFModel.this.getNode(context_id));
                }
            }.getE();
            if (node != null && (presentation2 = (ISourceNotFoundPresentation)DebugPlugin.getAdapter((Object)node, ISourceNotFoundPresentation.class)) != null) {
                editor_input = presentation2.getEditorInput(node, cfg, source_file_name);
                editor_id = presentation2.getEditorId(editor_input, node);
            }
            if (editor_id == null || editor_input == null) {
                editor_id = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                editor_input = editor_not_found.get(cfg);
                if (editor_input == null) {
                    editor_input = new CommonSourceNotFoundEditorInput((Object)cfg);
                    editor_not_found.put(cfg, editor_input);
                }
            }
        }
        IWorkbenchPage page = window.getActivePage();
        return this.displaySource(page, editor_id, editor_input, line);
    }

    private void displaySource(final Object generation, final IWorkbenchPage page, final Object element, final String exe_id, final String mem_id, boolean top_frame, final ILineNumbers.CodeArea area) {
        final boolean disassembly_available = this.channel.getRemoteService(IDisassembly.class) != null;
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Object presentation;
                    Object source_element;
                    if (!TCFModel.this.displaySourceCheck(page, generation)) {
                        return;
                    }
                    String editor_id = null;
                    IEditorInput editor_input = null;
                    int line = 0;
                    if (area != null && (source_element = TCFSourceLookupDirector.lookup((TCFLaunch)TCFModel.this.launch, (String)mem_id, (Object)area)) != null) {
                        presentation = TCFModelPresentation.getDefault();
                        editor_input = presentation.getEditorInput(source_element);
                        if (editor_input != null) {
                            editor_id = presentation.getEditorId(editor_input, source_element);
                        }
                        line = area.start_line;
                    }
                    if (!(area == null || TCFModel.this.instruction_stepping_enabled || editor_input != null && editor_id != null)) {
                        ILaunchConfiguration cfg = TCFModel.this.launch.getLaunchConfiguration();
                        presentation = (ISourceNotFoundPresentation)DebugPlugin.getAdapter((Object)element, ISourceNotFoundPresentation.class);
                        if (presentation != null) {
                            String filename = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)area);
                            editor_input = presentation.getEditorInput(element, cfg, filename);
                            editor_id = presentation.getEditorId(editor_input, element);
                        }
                        if (editor_id == null || editor_input == null) {
                            editor_id = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                            editor_input = (IEditorInput)editor_not_found.get(cfg);
                            if (editor_input == null) {
                                editor_input = new CommonSourceNotFoundEditorInput((Object)cfg);
                                editor_not_found.put(cfg, editor_input);
                            }
                        }
                    }
                    if (exe_id != null && disassembly_available && (editor_input == null || editor_id == null || TCFModel.this.instruction_stepping_enabled) && PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.cdt.dsf.ui.disassembly") != null) {
                        editor_id = "org.eclipse.cdt.dsf.ui.disassembly";
                        editor_input = DisassemblyEditorInput.INSTANCE;
                    }
                    if (!TCFModel.this.displaySourceCheck(page, generation)) {
                        return;
                    }
                    TCFModel.this.displaySource(page, editor_id, editor_input, line);
                    if (TCFModel.this.wait_for_pc_update_after_step) {
                        TCFModel.this.launch.addPendingClient((Object)TCFModel.this.annotation_manager);
                    }
                    TCFModel.this.updateAnnotations(page.getWorkbenchWindow());
                }
                finally {
                    TCFModel.this.displaySourceEnd(generation);
                }
            }
        });
    }

    private ITextEditor displaySource(IWorkbenchPage page, String editor_id, IEditorInput editor_input, int line) {
        ITextEditor text_editor = null;
        if (page != null && editor_input != null && editor_id != null) {
            IEditorPart editor = this.openEditor(editor_input, editor_id, page);
            if (editor instanceof ITextEditor) {
                text_editor = (ITextEditor)editor;
            } else if (editor != null) {
                text_editor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            }
        }
        IRegion region = null;
        if (text_editor != null && (region = this.getLineInformation(text_editor, line)) != null) {
            text_editor.selectAndReveal(region.getOffset(), 0);
        }
        return text_editor;
    }

    private void refreshSourceView() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows == null) {
                    return;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null) {
                        TCFModel.this.displaySource(null, page, true);
                    }
                    ++n2;
                }
            }
        });
    }

    private void refreshLaunchView() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows == null) {
                    return;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IDebugView view;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null && (view = (IDebugView)page.findView("org.eclipse.debug.ui.DebugView")) != null) {
                        ((StructuredViewer)view.getViewer()).refresh((Object)TCFModel.this.launch);
                    }
                    ++n2;
                }
            }
        });
    }

    public void showDebugConsole() {
        this.debug_consoles.add(new TCFConsole(this, 4, null));
    }

    public void showMessageBox(final String title, final Throwable error) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = TCFModel.this.display.getActiveShell();
                if (shell == null) {
                    Shell s;
                    Shell[] shells = TCFModel.this.display.getShells();
                    HashSet<Shell> set = new HashSet<Shell>();
                    Shell[] shellArray = shells;
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        set.add(s);
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        if (s.getParent() != null) {
                            set.remove(s.getParent().getShell());
                        }
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        shell = s = shellArray[n2];
                        ++n2;
                    }
                }
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText(title);
                mb.setMessage(TCFModel.getErrorMessage(error, !(error instanceof IErrorReport)));
                if (error instanceof IErrorReport) {
                    Activator.log(title, error);
                }
                mb.open();
            }
        });
    }

    public static String getErrorMessage(Throwable error, boolean multiline) {
        StringBuffer buf = new StringBuffer();
        while (error != null) {
            String msg = null;
            msg = !multiline && error instanceof IErrorReport ? Command.toErrorString((Object)((IErrorReport)error).getAttributes()) : (error instanceof UnknownHostException ? "Unknown host: " + error.getMessage() : error.getLocalizedMessage());
            if (msg == null || msg.length() == 0) {
                msg = error.getClass().getName();
            }
            buf.append(msg);
            error = error.getCause();
            if (error == null) continue;
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            } else if (ch != '.' && ch != ';') {
                buf.append(';');
            }
            if (multiline) {
                buf.append("Caused by:\n");
                continue;
            }
            buf.append(' ');
        }
        if (buf.length() > 0) {
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private IEditorPart openEditor(final IEditorInput input, final String id, final IWorkbenchPage page) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                    try {
                        editor[0] = page.openEditor(input, id, false, 3);
                    }
                    catch (PartInitException e) {
                        Activator.log("Cannot open editor", e);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)this.display, (Runnable)r);
        return editor[0];
    }

    private IRegion getLineInformation(ITextEditor editor, int line) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(line - 1);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    public synchronized void addSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.add(listener);
    }

    public synchronized void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.remove(listener);
    }

    private synchronized void runSuspendTrigger(final TCFNode node) {
        if (this.suspend_trigger_listeners.size() == 0) {
            return;
        }
        final ISuspendTriggerListener[] listeners = this.suspend_trigger_listeners.toArray(new ISuspendTriggerListener[this.suspend_trigger_listeners.size()]);
        final int generation = ++this.suspend_trigger_generation;
        if (this.wait_for_views_update_after_step) {
            this.launch.addPendingClient(this.suspend_trigger_listeners);
        }
        this.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TCFModel tCFModel = TCFModel.this;
                synchronized (tCFModel) {
                    if (generation != TCFModel.this.suspend_trigger_generation) {
                        return;
                    }
                }
                ISuspendTriggerListener[] iSuspendTriggerListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ISuspendTriggerListener listener = iSuspendTriggerListenerArray[n2];
                    try {
                        listener.suspended((ILaunch)TCFModel.this.launch, (Object)node);
                    }
                    catch (Throwable x) {
                        Activator.log(x);
                    }
                    ++n2;
                }
                tCFModel = TCFModel.this;
                synchronized (tCFModel) {
                    if (generation != TCFModel.this.suspend_trigger_generation) {
                        return;
                    }
                    TCFModel.this.launch.removePendingClient((Object)TCFModel.this.suspend_trigger_listeners);
                }
            }
        });
    }

    public void setInstructionSteppingEnabled(boolean enabled) {
        this.instruction_stepping_enabled = enabled;
    }

    public boolean isInstructionSteppingEnabled() {
        return this.instruction_stepping_enabled;
    }

    public void setReverseDebugEnabled(boolean enabled) {
        this.reverse_debug_enabled = enabled;
    }

    public boolean isReverseDebugEnabled() {
        return this.reverse_debug_enabled;
    }

    public boolean isShowQualifiedTypeNamesEnabled() {
        return this.qualified_type_names_enabled;
    }

    public TCFDataCache<Map<String, Object>> getProfilerCapabilities(final String ctx) {
        assert (Protocol.isDispatchThread());
        TCFDataCache<Map<String, Object>> cache = this.profiler_capabilities.get(ctx);
        if (cache == null) {
            cache = new TCFDataCache<Map<String, Object>>(this.channel){

                protected boolean startDataRetrieval() {
                    IProfiler profiler = (IProfiler)this.channel.getRemoteService(IProfiler.class);
                    if (profiler == null) {
                        this.set(null, null, new HashMap());
                        return false;
                    }
                    this.command = profiler.getCapabilities(ctx, new IProfiler.DoneGetCapabilities(){

                        public void doneGetCapabilities(IToken token, Exception error, Map<String, Object> capabilities) {
                            IErrorReport r;
                            if (error instanceof IErrorReport && (r = (IErrorReport)error).getErrorCode() == 25) {
                                this.set(token, null, null);
                                return;
                            }
                            this.set(token, error, capabilities);
                        }
                    });
                    return false;
                }
            };
            this.profiler_capabilities.put(ctx, cache);
        }
        return cache;
    }

    public Map<String, Object> getProfilerConfiguration(String ctx) {
        assert (Protocol.isDispatchThread());
        Map<String, Object> m = this.profiler_configuration.get(ctx);
        if (m == null) {
            m = new HashMap<String, Object>();
            this.profiler_configuration.put(ctx, m);
        }
        return m;
    }

    public void sendProfilerConfiguration(String ctx) {
        assert (Protocol.isDispatchThread());
        Map<String, Object> m = this.profiler_configuration.get(ctx);
        IProfiler profiler = (IProfiler)this.channel.getRemoteService(IProfiler.class);
        if (profiler == null) {
            return;
        }
        if (m.size() == 0) {
            this.profiler_configuration.remove(ctx);
        }
        profiler.configure(ctx, m, new IProfiler.DoneConfigure(){

            public void doneConfigure(IToken token, Exception error) {
                if (error != null) {
                    TCFModel.this.channel.terminate((Throwable)error);
                } else if (!TCFModel.this.profiler_read_posted && TCFModel.this.profiler_configuration.size() > 0) {
                    Protocol.invokeLater((Runnable)TCFModel.this.profiler_read_event);
                    TCFModel.this.profiler_read_posted = true;
                }
            }
        });
    }

    public long getProfilerReadDelay() {
        return this.profiler_read_delay;
    }

    public void setProfilerReadDelay(long delay) {
        if (delay < 100L) {
            delay = 100L;
        }
        this.profiler_read_delay = delay;
    }

    public void addProfilerDataListener(ProfilerDataListener listener) {
        assert (Protocol.isDispatchThread());
        this.profiler_listeners.add(listener);
    }

    public void removeProfilerDataListener(ProfilerDataListener listener) {
        assert (Protocol.isDispatchThread());
        this.profiler_listeners.remove(listener);
    }

    private class CreateNodeRunnable
    implements Runnable {
        final String id;
        final ArrayList<Runnable> waiting_list = new ArrayList();
        final ArrayList<IService> service_list = new ArrayList();

        CreateNodeRunnable(String id) {
            String[] arr;
            this.id = id;
            assert (TCFModel.this.context_map.get(id) == null);
            String[] stringArray = arr = new String[]{"RunControl", "StackTrace", "Registers"};
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String nm = stringArray[n2];
                IService s = TCFModel.this.channel.getRemoteService(nm);
                if (s != null) {
                    this.service_list.add(s);
                }
                ++n2;
            }
            TCFModel.this.context_map.put(id, this);
            Protocol.invokeLater((Runnable)this);
        }

        void wait(Runnable r) {
            assert (TCFModel.this.context_map.get(this.id) == this);
            if (this.waiting_list.contains(r)) {
                return;
            }
            this.waiting_list.add(r);
        }

        void done(Object res) {
            assert (res != null);
            assert (res != this);
            TCFModel.this.context_map.put(this.id, res);
            for (Runnable r : this.waiting_list) {
                if (!TCFModel.this.createNode(this.id, r)) continue;
                if (r instanceof TCFDataCache) {
                    ((TCFDataCache)r).post();
                    continue;
                }
                r.run();
            }
        }

        @Override
        public void run() {
            if (TCFModel.this.context_map.get(this.id) != this) {
                Object res = TCFModel.this.context_map.get(this.id);
                if (res == null) {
                    res = new Exception("Invalid context ID");
                }
                this.done(res);
            } else if (this.service_list.size() == 0) {
                this.done(new Exception("Invalid context ID"));
            } else {
                IService s = this.service_list.remove(0);
                if (s instanceof IRunControl) {
                    ((IRunControl)s).getContext(this.id, new IRunControl.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                            if (error == null && context != null) {
                                CreateNodeRunnable.this.done(context);
                            } else {
                                CreateNodeRunnable.this.run();
                            }
                        }
                    });
                } else if (s instanceof IStackTrace) {
                    ((IStackTrace)s).getContext(new String[]{this.id}, new IStackTrace.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IStackTrace.StackTraceContext[] context) {
                            if (error == null && context != null && context.length == 1 && context[0] != null) {
                                CreateNodeRunnable.this.done(context[0]);
                            } else {
                                CreateNodeRunnable.this.run();
                            }
                        }
                    });
                } else {
                    ((IRegisters)s).getContext(this.id, new IRegisters.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                            if (error == null && context != null) {
                                CreateNodeRunnable.this.done(context);
                            } else {
                                CreateNodeRunnable.this.run();
                            }
                        }
                    });
                }
            }
        }
    }

    public static class DisassemblyEditorInput
    implements IEditorInput {
        static final String EDITOR_ID = "org.eclipse.cdt.dsf.ui.disassembly";
        static final DisassemblyEditorInput INSTANCE = new DisassemblyEditorInput();

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return "Disassembly";
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return "Disassembly";
        }
    }

    private class InitialSelection
    implements Runnable {
        final TCFModelProxy proxy;
        boolean launch_selected;
        boolean done;

        InitialSelection(TCFModelProxy proxy) {
            this.proxy = proxy;
            TCFModel.this.initial_selection = this;
        }

        @Override
        public void run() {
            if (this.done) {
                return;
            }
            if (TCFModel.this.initial_selection != this) {
                return;
            }
            if (TCFModel.this.launch_node != null) {
                ArrayList<TCFNodeExecContext> nodes = new ArrayList<TCFNodeExecContext>();
                if (!this.searchSuspendedThreads(TCFModel.this.launch_node.getFilteredChildren(), nodes)) {
                    return;
                }
                if (nodes.size() == 0) {
                    if (!this.launch_selected) {
                        TCFModel.this.setDebugViewSelectionForProxy(this.proxy, TCFModel.this.launch_node, TCFModel.SELECT_INITIAL);
                        this.launch_selected = true;
                    }
                    return;
                }
                if (nodes.size() == 1) {
                    TCFNodeExecContext n = nodes.get(0);
                    TCFModel.this.setDebugViewSelectionForProxy(this.proxy, n, TCFModel.SELECT_INITIAL);
                } else {
                    boolean node_selected = false;
                    for (TCFNodeExecContext n : nodes) {
                        String reason = ((TCFContextState)n.getState().getData()).suspend_reason;
                        node_selected |= TCFModel.this.setDebugViewSelectionForProxy(this.proxy, n, reason);
                    }
                    if (!node_selected) {
                        TCFModel.this.setDebugViewSelectionForProxy(this.proxy, nodes.get(0), TCFModel.SELECT_INITIAL);
                    }
                }
            }
            TCFModel.this.initial_selection = null;
            this.done = true;
        }

        private boolean searchSuspendedThreads(TCFChildren c, ArrayList<TCFNodeExecContext> nodes) {
            if (!c.validate(this)) {
                return false;
            }
            TCFNode[] tCFNodeArray = c.toArray();
            int n = tCFNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TCFNode n3 = tCFNodeArray[n2];
                if (!this.searchSuspendedThreads((TCFNodeExecContext)n3, nodes)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private boolean searchSuspendedThreads(TCFNodeExecContext n, ArrayList<TCFNodeExecContext> nodes) {
            TCFDataCache<IRunControl.RunControlContext> run_context = n.getRunContext();
            if (!run_context.validate((Runnable)this)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)run_context.getData();
            if (ctx != null && ctx.hasState()) {
                TCFDataCache<TCFContextState> state = n.getState();
                if (!state.validate((Runnable)this)) {
                    return false;
                }
                TCFContextState s = (TCFContextState)state.getData();
                if (s != null && s.is_suspended) {
                    nodes.add(n);
                }
                return true;
            }
            return this.searchSuspendedThreads(n.getChildren(), nodes);
        }
    }

    private class MemoryBlocksUpdate
    extends TCFDataCache<Map<String, TCFMemoryBlockRetrieval>> {
        final Set<String> changeset;
        final Set<String> suspended;

        MemoryBlocksUpdate(IChannel channel) {
            super(channel);
            this.changeset = new HashSet<String>();
            this.suspended = new HashSet<String>();
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!MemoryBlocksUpdate.this.validate(this)) {
                        return;
                    }
                    Map map = (Map)MemoryBlocksUpdate.this.getData();
                    if (map != null) {
                        for (TCFMemoryBlockRetrieval r : map.values()) {
                            r.onMemoryChanged(MemoryBlocksUpdate.this.suspended.contains(r.getMemoryID()));
                        }
                    }
                    TCFModel.this.launch.removePendingClient((Object)TCFModel.this.mem_blocks_update);
                    TCFModel.this.mem_blocks_update = null;
                }
            });
        }

        void add(String id, boolean suspended) {
            this.changeset.add(id);
            if (suspended) {
                this.suspended.add(id);
            }
        }

        public boolean startDataRetrieval() {
            HashMap<String, TCFMemoryBlockRetrieval> map = new HashMap<String, TCFMemoryBlockRetrieval>();
            for (String id : this.changeset) {
                TCFMemoryBlockRetrieval r;
                if (map.get(id) != null) continue;
                TCFNode node = (TCFNode)TCFModel.this.id2node.get(id);
                if (node == null) {
                    if (!TCFModel.this.createNode(id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (this.isValid()) {
                        Activator.log("Cannot create debug model node", this.getError());
                        this.reset();
                        continue;
                    }
                    node = (TCFNode)TCFModel.this.id2node.get(id);
                }
                if (!(node instanceof TCFNodeExecContext)) continue;
                TCFDataCache<TCFNodeExecContext> c = ((TCFNodeExecContext)node).getMemoryNode();
                if (!c.validate((Runnable)((Object)this))) {
                    return false;
                }
                node = (TCFNode)c.getData();
                if (node == null || (r = (TCFMemoryBlockRetrieval)TCFModel.this.mem_retrieval.get(node.id)) == null) continue;
                map.put(node.id, r);
                if (!this.suspended.contains(id)) continue;
                this.suspended.add(node.id);
            }
            this.set(null, null, map);
            return true;
        }
    }

    public static interface ProfilerDataListener {
        public void onDataReceived(String var1, Map<String, Object>[] var2);
    }
}

