/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.List;
import org.eclipse.statet.internal.rj.renv.core.REnvCoreInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RLibPaths;

@NonNullByDefault
public class BasicRLibPaths
implements RLibPaths {
    private final ImList<? extends RLibGroup> libGroups;
    private final ImList<? extends RLibLocation> libLocations;

    public BasicRLibPaths(ImList<? extends RLibGroup> libGroups, ImList<? extends RLibLocation> libLocations) {
        this.libGroups = (ImList)ObjectUtils.nonNullAssert(libGroups);
        this.libLocations = (ImList)ObjectUtils.nonNullAssert(libLocations);
    }

    public BasicRLibPaths(List<? extends RLibGroup> libGroups) {
        this.libGroups = ImCollections.toList(libGroups);
        this.libLocations = REnvCoreInternals.listRLibLocations(this.libGroups);
    }

    @Override
    public ImList<? extends RLibGroup> getRLibGroups() {
        return this.libGroups;
    }

    @Override
    public ImList<? extends RLibLocation> getRLibLocations() {
        return this.libLocations;
    }
}

