/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab2;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.ui.config.InputArgumentsComposite;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigUtils;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.launching.ExtJavaStandardVMCommonTab;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleMainTab;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ExtJavaJRETab
extends JavaJRETab
implements PreferenceSetService.ChangeListener {
    private final ImIdentitySet<String> PREF_QUALIFIERS = ImCollections.newIdentitySet((Object)"org.eclipse.statet.r.core/r.environments");
    private final RConsoleMainTab mainTab;
    private final REnvTab rEnvTab;
    private InputArgumentsComposite vmArgsControl;
    private final boolean enableVMArchCheck;
    private IVMInstall lastCheckedVM;
    private int lastCheckedVMBits;
    private int lastCheckedRBits;
    private boolean validInBackground;

    private boolean is32(String arch) {
        return arch.equals("x86_32") || arch.equals("i386") || arch.equals("i586") || arch.equals("i686");
    }

    private boolean is64(String arch) {
        return arch.equals("x86_64") || arch.equals("amd64");
    }

    public ExtJavaJRETab(RConsoleMainTab mainTab, REnvTab renvTab) {
        this.mainTab = mainTab;
        this.rEnvTab = renvTab;
        EPreferences.getInstancePrefs().addPreferenceSetListener((PreferenceSetService.ChangeListener)this, this.PREF_QUALIFIERS);
        this.enableVMArchCheck = !(SystemUtils.getLocalOs() != 1 && !Platform.getOS().equals("linux") || SystemUtils.getLocalArch() != "x86_32" && SystemUtils.getLocalArch() != "x86_64");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite tabHolder = this.getDynamicTabHolder();
        Composite composite = tabHolder.getParent();
        GridLayout layout = (GridLayout)composite.getLayout();
        tabHolder.setLayoutData((Object)new GridData(4, 4, false, false, layout.numColumns, 1));
        Composite extComposite = new Composite(composite, 0);
        GridLayout extLayout = new GridLayout();
        extLayout.marginHeight = 0;
        extComposite.setLayout((Layout)extLayout);
        extComposite.setLayoutData((Object)new GridData(4, 4, true, false, layout.numColumns, 1));
        Group group = new Group(extComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        group.setText(Messages.JavaJRE_Tab_VMConfig_group);
        this.vmArgsControl = new InputArgumentsComposite((Composite)group, Messages.JavaJRE_Tab_VMArguments_label);
        this.vmArgsControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.vmArgsControl.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtJavaJRETab.this.updateLaunchConfigurationDialog();
            }
        });
        Label note = new Label((Composite)group, 64);
        note.setText(this.vmArgsControl.getNoteText());
        note.setLayoutData((Object)new GridData(4, 4, false, false));
        Dialog.applyDialogFont((Control)extComposite);
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        if (tab instanceof ILaunchConfigurationTab2 && SystemUtils.getLocalOs() == 1 && ObjectUtils.isInstanceOfClass((Object)tab, (Pattern)ExtJavaStandardVMCommonTab.STANDARD_VM_TAB_CLASS_PATTERN)) {
            tab = new ExtJavaStandardVMCommonTab((ILaunchConfigurationTab2)tab);
        }
        super.setDynamicTab(tab);
    }

    protected void loadDynamicJREArea() {
        super.loadDynamicJREArea();
        Composite tabHolder = this.getDynamicTabHolder();
        tabHolder.getParent().layout(new Control[]{tabHolder});
    }

    public void onPreferenceChanged(PreferenceSetService.ChangeEvent event) {
        if (event.contains("org.eclipse.statet.r.core/r.environments")) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    int previous = ExtJavaJRETab.this.lastCheckedRBits;
                    ExtJavaJRETab.this.updateRBits();
                    if (previous != ExtJavaJRETab.this.lastCheckedRBits && UIAccess.isOkToUse((Control)ExtJavaJRETab.this.getControl()) && LaunchConfigUtils.isActiveTabGroup((ILaunchConfigurationDialog)ExtJavaJRETab.this.getLaunchConfigurationDialog(), (ILaunchConfigurationTab)ExtJavaJRETab.this)) {
                        ExtJavaJRETab.this.getLaunchConfigurationDialog().updateMessage();
                        ExtJavaJRETab.this.getLaunchConfigurationDialog().updateButtons();
                    }
                }
            });
        }
    }

    public void dispose() {
        EPreferences.getInstancePrefs().removePreferenceSetListener((PreferenceSetService.ChangeListener)this);
        super.dispose();
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (this.enableVMArchCheck) {
            if (this.validInBackground) {
                this.scheduleUpdateJob();
                return false;
            }
            RConsoleType type = this.mainTab.getType();
            if (type == null || !type.requireJRE()) {
                this.setErrorMessage(null);
                this.setMessage(null);
                return true;
            }
            if (!super.isValid(config)) {
                return false;
            }
            this.updateRBits();
            if (this.lastCheckedRBits == -1) {
                return true;
            }
            IVMInstall jre = null;
            try {
                jre = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (jre instanceof VMStandin) {
                jre = ((VMStandin)jre).convertToRealVM();
            }
            if (jre != null && this.lastCheckedVM != jre) {
                this.lastCheckedVM = jre;
                this.updateVMBits();
            }
            if (jre == null || this.lastCheckedVMBits == -1) {
                return true;
            }
            if (this.lastCheckedVMBits == this.lastCheckedRBits) {
                return true;
            }
            this.setErrorMessage(NLS.bind((String)Messages.JavaJRE_RCompatibility_error_DifferentBits_message, (Object)this.lastCheckedRBits, (Object)this.lastCheckedVMBits));
            return false;
        }
        return true;
    }

    private void updateRBits() {
        this.lastCheckedRBits = -1;
        REnv rEnv = this.rEnvTab.getSelectedEnv();
        if (rEnv == null) {
            return;
        }
        REnvConfiguration rEnvConfig = (REnvConfiguration)rEnv.get(REnvConfiguration.class);
        if (rEnvConfig == null) {
            return;
        }
        String arch = rEnvConfig.getRArch();
        if (arch != null && arch.length() > 0) {
            if (this.is32(arch)) {
                this.lastCheckedRBits = 32;
            } else if (this.is64(arch)) {
                this.lastCheckedRBits = 64;
            }
        }
    }

    private void updateVMBits() {
        this.lastCheckedVMBits = -1;
        if (this.lastCheckedVM instanceof IVMInstall3) {
            this.validInBackground = true;
            try {
                try {
                    this.getLaunchConfigurationDialog().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            String[] propertyNames = new String[]{"os.arch", "java.vm.name", "sun.arch.data.model", "com.ibm.vm.bitmode"};
                            try {
                                Map properties = ((IVMInstall3)ExtJavaJRETab.this.lastCheckedVM).evaluateSystemProperties(propertyNames, monitor);
                                String p = (String)properties.get("os.arch");
                                if (p != null && p.length() > 0) {
                                    if (ExtJavaJRETab.this.is32(p)) {
                                        ExtJavaJRETab.this.lastCheckedVMBits = 32;
                                        return;
                                    }
                                    if (ExtJavaJRETab.this.is64(p)) {
                                        ExtJavaJRETab.this.lastCheckedVMBits = 64;
                                        return;
                                    }
                                }
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    RConsoleUIPlugin.logError("An error when trying to fetch VM properties for JRE validation.", e.getTargetException());
                    this.validInBackground = false;
                }
                catch (InterruptedException interruptedException) {
                    this.validInBackground = false;
                }
            }
            finally {
                this.validInBackground = false;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        String vmArgs = null;
        try {
            vmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.vmArgsControl.getTextControl().setText(vmArgs != null ? vmArgs : "");
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String vmArgs = this.vmArgsControl.getTextControl().getText();
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.length() > 0 ? vmArgs : null);
    }

    protected long getUpdateJobDelay() {
        return 400L;
    }
}

