/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class SubmitTypeSelectionComposite
extends Composite
implements ICheckStateListener {
    public static final Preference.EnumSetPref<SubmitType> SOURCE_ENCODER = new Preference.EnumSetPref(null, null, SubmitType.class);
    private final SubmitType[] types = SubmitType.values();
    private final EnumSet<SubmitType> editableTypes = EnumSet.allOf(SubmitType.class);
    private final EnumSet<SubmitType> selectedTypes = EnumSet.noneOf(SubmitType.class);
    private TableViewer viewer;
    private Observable observable;

    public SubmitTypeSelectionComposite(Composite parent) {
        super(parent, 0);
        this.create();
    }

    protected void create() {
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Table table = new Table((Composite)this, 67604);
        TableViewer viewer = new TableViewer(table);
        TableViewerColumn column = new TableViewerColumn(viewer, 0x1000000);
        ViewerUtils.CheckboxColumnControl columnControl = new ViewerUtils.CheckboxColumnControl(viewer, this.selectedTypes, this.editableTypes);
        column.setLabelProvider((CellLabelProvider)columnControl);
        columnControl.configureAsMainColumn();
        columnControl.addCheckStateListener((ICheckStateListener)this);
        column = new TableViewerColumn(viewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                SubmitType type = (SubmitType)cell.getElement();
                cell.setText(type.getLabel());
                cell.setForeground(SubmitTypeSelectionComposite.this.editableTypes.contains(type) ? null : cell.getItem().getDisplay().getSystemColor(18));
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)this.types);
        table.getColumn(0).pack();
        table.getColumn(1).pack();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = viewer;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.observable != null) {
            this.observable.doValueChanged(this.selectedTypes);
        }
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    public void setEditable(EnumSet<SubmitType> editableTypes) {
        if (editableTypes == null) {
            throw new NullPointerException();
        }
        this.editableTypes.clear();
        this.editableTypes.addAll(editableTypes);
        this.viewer.update((Object[])this.types, null);
    }

    public void setSelection(EnumSet<SubmitType> selectedTypes) {
        if (selectedTypes == null) {
            throw new NullPointerException();
        }
        this.selectedTypes.clear();
        this.selectedTypes.addAll(selectedTypes);
        this.viewer.update((Object[])this.types, null);
    }

    public EnumSet<SubmitType> getSelection() {
        return EnumSet.copyOf(this.selectedTypes);
    }

    public IObservableValue<EnumSet<SubmitType>> getObservable() {
        if (this.observable == null) {
            this.observable = new Observable();
        }
        return this.observable;
    }

    private class Observable
    extends AbstractSWTObservableValue<EnumSet<SubmitType>> {
        private EnumSet<SubmitType> lastValue;

        public Observable() {
            super((Widget)SubmitTypeSelectionComposite.this.viewer.getTable());
        }

        public Object getValueType() {
            return EnumSet.class;
        }

        protected EnumSet<SubmitType> doGetValue() {
            return SubmitTypeSelectionComposite.this.selectedTypes;
        }

        protected void doSetValue(EnumSet<SubmitType> value) {
            if (value instanceof EnumSet) {
                this.lastValue = value;
                SubmitTypeSelectionComposite.this.setSelection(this.lastValue);
            }
        }

        void doValueChanged(EnumSet<SubmitType> newValue) {
            if (!Objects.equals(newValue, this.lastValue)) {
                this.lastValue = EnumSet.copyOf(newValue);
                this.fireValueChange(Diffs.createValueDiff(this.lastValue, this.lastValue));
            }
        }
    }
}

