/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.issues.core.Issue;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.Task;

@NonNullByDefault
public abstract class BasicIssueRequestor
implements IssueRequestor {
    private static final int STATE_OPEN = 1;
    private static final int STATE_FINISHING = 2;
    private static final int STATE_FINISHED = 3;
    private final IssueTypeSet issueTypeSet;
    private final @Nullable TaskBatch taskCollector;
    private final ImList<ProblemBatch> problemCollectors;
    private int state = 1;

    public BasicIssueRequestor(IssueTypeSet issueTypeSet, WorkingContext workingContext) {
        this.issueTypeSet = issueTypeSet;
        this.taskCollector = this.createTaskCollector(issueTypeSet.getTaskCategory(), workingContext);
        this.problemCollectors = this.createProblemCollectors(issueTypeSet.getProblemCategories(), workingContext);
    }

    protected @Nullable TaskBatch createTaskCollector(@Nullable IssueTypeSet.TaskCategory category, WorkingContext requiredContext) {
        if (category != null && category.getType(requiredContext) != null) {
            return new TaskBatch(category, this.shouldAccept(category));
        }
        return null;
    }

    protected boolean shouldAccept(IssueTypeSet.TaskCategory category) {
        return true;
    }

    protected ImList<ProblemBatch> createProblemCollectors(ImList<IssueTypeSet.ProblemCategory> categories, WorkingContext requiredContext) {
        ArrayList<ProblemBatch> list = new ArrayList<ProblemBatch>(categories.size());
        for (IssueTypeSet.ProblemCategory category : categories) {
            if (category.getTypes(requiredContext) == null) continue;
            list.add(new ProblemBatch(category, this.shouldAccept(category)));
        }
        return ImCollections.toList(list);
    }

    protected boolean shouldAccept(IssueTypeSet.ProblemCategory category) {
        return true;
    }

    public IssueTypeSet getIssueTypeSet() {
        return this.issueTypeSet;
    }

    protected final @Nullable TaskBatch getTaskCollector() {
        return this.taskCollector;
    }

    protected final ImList<ProblemBatch> getProblemCollector() {
        return this.problemCollectors;
    }

    protected final @Nullable ProblemBatch getProblemCollector(String id) {
        for (ProblemBatch collector : this.problemCollectors) {
            if (collector.id != id) continue;
            return collector;
        }
        return null;
    }

    @Override
    public boolean isInterestedInTasks() {
        TaskBatch collector = this.getTaskCollector();
        return collector != null && collector.isEnabled;
    }

    @Override
    public void acceptTask(Task task) {
        TaskBatch collector = this.getTaskCollector();
        if (collector != null && collector.isEnabled) {
            collector.acceptedIssues.add(task);
        }
    }

    @Override
    public boolean isInterestedInProblems(String id) {
        ProblemBatch collector = this.getProblemCollector(id);
        return collector != null && collector.isEnabled;
    }

    @Override
    public void acceptProblems(Problem problem) {
        ProblemBatch collector = this.getProblemCollector(problem.getCategoryId());
        if (collector != null && collector.isEnabled) {
            collector.acceptedIssues.add(problem);
        }
    }

    @Override
    public void acceptProblems(String id, List<Problem> problems) {
        ProblemBatch collector = this.getProblemCollector(id);
        if (collector != null && collector.isEnabled) {
            collector.acceptedIssues.addAll(problems);
        }
    }

    @Override
    public void finish() throws StatusException {
        if (this.state != 1) {
            throw new IllegalStateException("Already finished");
        }
        this.state = 2;
        try {
            try {
                this.reportIssues(this.taskCollector, this.problemCollectors);
            }
            catch (CoreException e) {
                throw EStatusUtils.convert((CoreException)e);
            }
        }
        finally {
            this.state = 3;
        }
    }

    protected abstract void reportIssues(@Nullable TaskBatch var1, ImList<ProblemBatch> var2) throws CoreException;

    public static class IssueBatch<TIssue extends Issue, TCategory extends IssueTypeSet.IssueCategory<TIssue>> {
        private final TCategory category;
        final boolean isEnabled;
        final List<TIssue> acceptedIssues = new ArrayList<TIssue>();

        public IssueBatch(TCategory category, boolean isEnabled) {
            this.category = category;
            this.isEnabled = isEnabled;
        }

        public final TCategory getCategory() {
            return this.category;
        }

        public final boolean isEnabled() {
            return true;
        }

        public List<TIssue> getAcceptedIssues() {
            return this.acceptedIssues;
        }
    }

    public static final class ProblemBatch
    extends IssueBatch<Problem, IssueTypeSet.ProblemCategory> {
        private final String id;

        public ProblemBatch(IssueTypeSet.ProblemCategory category, boolean isEnabled) {
            super(category, isEnabled);
            this.id = category.getId();
        }

        public String getId() {
            return this.id;
        }
    }

    public static final class TaskBatch
    extends IssueBatch<Task, IssueTypeSet.TaskCategory> {
        public TaskBatch(IssueTypeSet.TaskCategory category, boolean isEnabled) {
            super(category, isEnabled);
        }
    }
}

