/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.ScannerImpl;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AliasToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AnchorToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.CommentType;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DirectiveToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagTuple;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Token;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.yaml.core.source.ast.Alias;
import org.eclipse.statet.yaml.core.source.ast.Anchor;
import org.eclipse.statet.yaml.core.source.ast.Collection;
import org.eclipse.statet.yaml.core.source.ast.Comment;
import org.eclipse.statet.yaml.core.source.ast.Directive;
import org.eclipse.statet.yaml.core.source.ast.DocumentNode;
import org.eclipse.statet.yaml.core.source.ast.Dummy;
import org.eclipse.statet.yaml.core.source.ast.MapEntry;
import org.eclipse.statet.yaml.core.source.ast.Marker;
import org.eclipse.statet.yaml.core.source.ast.NContainer;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.NodeWithProperties;
import org.eclipse.statet.yaml.core.source.ast.Scalar;
import org.eclipse.statet.yaml.core.source.ast.SeqEntry;
import org.eclipse.statet.yaml.core.source.ast.SourceComponent;
import org.eclipse.statet.yaml.core.source.ast.Tag;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;

@NonNullByDefault
public class YamlParser {
    public static final int COLLECT_COMMENTS = 1;
    private static final int DOC_NONE = 0;
    private static final int DOC_DIRECTIVES = 1;
    private static final int DOC_CONTENT = 2;
    private final ScannerImpl lexer = new ScannerImpl(true, false, false){

        @Override
        protected void handleComment(CommentType type, int startIndex, int endIndex) {
            if (YamlParser.this.commentsLevel != 0) {
                YamlParser.this.comments.add(new Comment(startIndex, endIndex));
            }
        }
    };
    private String parseInput;
    private int parseStartOffset;
    private int parseEndOffset;
    private @Nullable AstNode parseParent;
    private @Nullable YamlAstNode currentNode;
    private int depth;
    private final List<NContainerBuilder> containerStack = new ArrayList<NContainerBuilder>();
    private int docState;
    private int commentsLevel;
    private final List<Comment> comments = new ArrayList<Comment>();

    public void setScalarText(boolean create) {
        this.lexer.setCreateContentText(create);
    }

    public void setCommentLevel(int level) {
        level = (level & 1) == 0 ? 0 : (level &= 1);
        this.commentsLevel = level;
    }

    private void init0(String input, int inputOffset, @Nullable AstNode parent) {
        this.parseInput = (String)ObjectUtils.nonNullAssert((Object)input);
        this.parseStartOffset = inputOffset;
        this.parseEndOffset = inputOffset + input.length();
        this.parseParent = parent;
    }

    private void clear0() {
        this.parseInput = null;
        this.parseParent = null;
    }

    private void logParseError(Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.yaml.core", "An error occured while parsing R source code. Input:\n" + this.parseInput.toString(), (Throwable)e));
    }

    private void init() {
        this.depth = -1;
        if (this.commentsLevel != 0) {
            this.comments.clear();
        }
        this.docState = 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceComponent parseSourceUnit(String input, int inputOffset, @Nullable AstNode parent) {
        this.init0(input, inputOffset, parent);
        try {
            this.init();
            this.lexer.reset(input, inputOffset);
            sourceNode = new SourceComponent(parent, this.parseStartOffset, this.parseEndOffset);
            this.enterNode(sourceNode);
            this.processTokens();
            while (true) {
                if (this.depth < 0) {
                    if (this.commentsLevel != 0) {
                        sourceNode.comments = ImCollections.toList(this.comments);
                    }
                    var6_6 = sourceNode;
                    return var6_6;
                }
                this.exit(-2147483648);
            }
        }
        catch (Exception e) {
            this.logParseError(e);
            var6_7 = this.createErrorSourceComponent();
            return var6_7;
        }
        finally {
            this.clear0();
            ** while (this.depth >= 0)
        }
lbl-1000:
        // 1 sources

        {
            if (this.depth < this.containerStack.size()) {
                builder = this.containerStack.get(this.depth);
                builder.clear();
            }
            --this.depth;
            continue;
        }
lbl28:
        // 1 sources

        return var6_7;
    }

    public SourceComponent parseSourceUnit(String text) {
        return this.parseSourceUnit(text, 0, null);
    }

    private SourceComponent createErrorSourceComponent() {
        int endOffset = this.parseEndOffset;
        int startOffset = this.parseStartOffset;
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        SourceComponent dummy = new SourceComponent(this.parseParent, startOffset, endOffset);
        dummy.status = 3840;
        if (this.commentsLevel != 0) {
            dummy.comments = ImCollections.emptyList();
        }
        return dummy;
    }

    private void addChildTerm(YamlAstNode node) {
        this.addChild(node);
        this.checkExit();
    }

    private void addChild(YamlAstNode node) {
        YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case MAP_ENTRY: {
                MapEntry entryNode = (MapEntry)currentNode;
                if (entryNode.keyChild == null && entryNode.valueIndicatorOffset == Integer.MIN_VALUE) {
                    entryNode.keyChild = node;
                } else {
                    entryNode.valueChild = node;
                }
                return;
            }
            case SEQ_ENTRY: {
                SeqEntry entryNode = (SeqEntry)currentNode;
                entryNode.valueChild = node;
                return;
            }
            case PROPERTIES_CONTAINER: {
                NodeWithProperties propertiesNode = (NodeWithProperties)currentNode;
                if (YamlAsts.isNodeProperty(node)) {
                    propertiesNode.properties = ImCollections.addElement(propertiesNode.properties, (Object)((Object)node));
                } else {
                    propertiesNode.nodeChild = node;
                }
                return;
            }
        }
        NContainer container = (NContainer)currentNode;
        NContainerBuilder builder = this.containerStack.get(this.depth);
        container.add(builder, node);
    }

    private void finish(int endOffset) {
        YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case PROPERTIES_CONTAINER: 
            case SEQ_ENTRY: 
            case MAP_ENTRY: {
                currentNode.finish(endOffset);
                return;
            }
            case DOCUMENT: {
                this.docState = 0;
            }
        }
        NContainer container = (NContainer)this.currentNode;
        if (endOffset != Integer.MIN_VALUE) {
            container.endOffset = endOffset;
        }
        NContainerBuilder builder = this.containerStack.get(this.depth);
        container.finish(endOffset, builder);
        builder.clear();
    }

    private void enterNode(NContainer node) {
        if (this.depth >= 0) {
            this.addChild(node);
        }
        ++this.depth;
        this.currentNode = node;
        while (this.depth >= this.containerStack.size()) {
            this.containerStack.add(new NContainerBuilder());
        }
    }

    private void enterNode(NodeWithProperties node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    private void enterNode(MapEntry node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    private void enterNode(SeqEntry node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    private boolean exitTo(Class<?> type1) {
        while (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    private boolean exitTo(Class<?> type1, Class<?> type2) {
        while (this.depth > 1) {
            if (((Object)((Object)this.currentNode)).getClass() == type1 || ((Object)((Object)this.currentNode)).getClass() == type2) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    private boolean exitTo1(Class<?> type1, Class<?> type2) {
        while (this.depth > 1) {
            YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
            if (((Object)((Object)currentNode)).getClass() == type1 || ((Object)((Object)currentNode)).getClass() == type2) {
                return true;
            }
            if (currentNode.getNodeType() != NodeType.MAP_ENTRY) break;
            this.exit(Integer.MIN_VALUE);
        }
        int checkDepth = this.depth - 1;
        YamlAstNode node = this.currentNode.getYamlParent();
        while (checkDepth > 1) {
            if (((Object)((Object)node)).getClass() == type1 || ((Object)((Object)node)).getClass() == type2) {
                while (this.depth > checkDepth) {
                    this.exit(Integer.MIN_VALUE);
                }
                return true;
            }
            --checkDepth;
            node = node.getYamlParent();
        }
        return false;
    }

    private boolean exitTo(NodeType type1) {
        while (this.depth > 1) {
            if (this.currentNode.getNodeType() == type1) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    private boolean exitTo(NodeType type1, NodeType type2) {
        while (this.depth > 1) {
            if (this.currentNode.getNodeType() == type1 || this.currentNode.getNodeType() == type2) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    private YamlAstNode exitToSourceComponent(int offset) {
        while (this.depth > 1) {
            this.exit(Integer.MIN_VALUE);
        }
        if (this.depth > 0) {
            this.exit(offset);
        }
        return this.currentNode;
    }

    private void exit(int offset) {
        this.finish(offset);
        this.currentNode = this.currentNode.yamlParent;
        --this.depth;
        this.checkExit();
        if (this.depth == 1) {
            this.lexer.resetToRoot();
        }
    }

    private void checkExit() {
        if (this.depth > 1) {
            switch (this.currentNode.getNodeType()) {
                case PROPERTIES_CONTAINER: {
                    if (((NodeWithProperties)this.currentNode).nodeChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                    break;
                }
                case MAP_ENTRY: {
                    if (((MapEntry)this.currentNode).valueChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                    break;
                }
                case SEQ_ENTRY: {
                    if (((SeqEntry)this.currentNode).valueChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                }
            }
        }
    }

    private void ensureDocContent(int startOffset) {
        switch (this.docState) {
            case 0: {
                DocumentNode docNode = new DocumentNode((SourceComponent)this.currentNode, startOffset);
                this.enterNode(docNode);
                this.docState = 2;
                return;
            }
            case 1: {
                if (!this.containerStack.get((int)this.depth).children.isEmpty()) {
                    DocumentNode docNode = (DocumentNode)this.currentNode;
                    Dummy markerNode = new Dummy(4330256, docNode, startOffset);
                    this.addChildTerm(markerNode);
                    docNode.directivesEndChild = markerNode;
                }
                this.docState = 2;
                return;
            }
        }
    }

    private YamlAstNode checkParent(Token token) {
        this.ensureDocContent(token.getStartIndex());
        YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case SEQ: {
                if (currentNode.getOperator() == '-') {
                    SeqEntry seqEntry = new SeqEntry(currentNode, token.getStartIndex(), token.getEndIndex());
                    seqEntry.status = 0x440330;
                    this.enterNode(seqEntry);
                    return seqEntry;
                }
                return currentNode;
            }
            case MAP: {
                MapEntry mapEntry = new MapEntry(currentNode, token.getStartIndex(), token.getEndIndex());
                if (currentNode.getOperator() == '?') {
                    mapEntry.status = 0x444330;
                }
                this.enterNode(mapEntry);
                return mapEntry;
            }
        }
        return currentNode;
    }

    private void processTokens() {
        Token token;
        block42: while ((token = this.lexer.nextToken()) != null) {
            switch (token.getTokenId()) {
                case StreamEnd: 
                case StreamStart: {
                    continue block42;
                }
                case Directive: {
                    DocumentNode docNode;
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    switch (this.docState) {
                        case 0: {
                            docNode = new DocumentNode((SourceComponent)currentNode, token.getStartIndex());
                            this.enterNode(docNode);
                            this.docState = 1;
                            break;
                        }
                        case 1: {
                            docNode = (DocumentNode)currentNode;
                            break;
                        }
                        default: {
                            currentNode = this.exitToSourceComponent(token.getStartIndex());
                            docNode = null;
                        }
                    }
                    YamlAstNode node = new Directive(currentNode, token.getStartIndex(), token.getEndIndex(), ((DirectiveToken)token).getName());
                    this.addChildTerm(node);
                    if (docNode != null) {
                        this.attachProblem(node, token);
                        continue block42;
                    }
                    ((Directive)node).status = 0x400200;
                    continue block42;
                }
                case DocumentStart: {
                    DocumentNode docNode;
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    switch (this.docState) {
                        case 1: {
                            docNode = (DocumentNode)currentNode;
                            this.docState = 2;
                            break;
                        }
                        default: {
                            currentNode = this.exitToSourceComponent(token.getStartIndex());
                            docNode = new DocumentNode((SourceComponent)currentNode, token.getStartIndex());
                            this.enterNode(docNode);
                            this.docState = 2;
                        }
                    }
                    YamlAstNode node = new Marker.DirectivesEnd(docNode, token.getStartIndex(), token.getEndIndex());
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    docNode.directivesEndChild = node;
                    continue block42;
                }
                case DocumentEnd: {
                    DocumentNode docNode;
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    switch (this.docState) {
                        case 0: {
                            docNode = null;
                            break;
                        }
                        case 1: {
                            docNode = (DocumentNode)currentNode;
                            break;
                        }
                        default: {
                            while (this.depth > 1) {
                                this.exit(Integer.MIN_VALUE);
                            }
                            currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                            docNode = (DocumentNode)currentNode;
                        }
                    }
                    YamlAstNode node = new Marker.DocumentEnd(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    if (docNode == null) continue block42;
                    docNode.documentEndChild = node;
                    this.exit(token.getEndIndex());
                    continue block42;
                }
                case BlockSequenceStart: {
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    Collection.BlockSeq node = new Collection.BlockSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case BlockMappingStart: {
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    Collection.BlockMap node = new Collection.BlockMap(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case BlockEnd: {
                    boolean found = this.exitTo(Collection.BlockSeq.class, Collection.BlockMap.class);
                    if (!found) continue block42;
                    this.exit(token.getEndIndex());
                    continue block42;
                }
                case FlowSequenceStart: {
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    Collection.FlowSeq node = new Collection.FlowSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case FlowSequenceEnd: {
                    boolean found = this.exitTo(Collection.FlowSeq.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        Collection.FlowSeq collection = (Collection.FlowSeq)currentNode;
                        collection.closeIndicatorOffset = token.getStartIndex();
                        this.exit(token.getEndIndex());
                        continue block42;
                    }
                    this.addChildTerm(new Dummy(0x400200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case FlowMappingStart: {
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    Collection.FlowMap node = new Collection.FlowMap(currentNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case FlowMappingEnd: {
                    YamlAstNode node;
                    boolean found = this.exitTo(Collection.FlowMap.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        node = (Collection.FlowMap)currentNode;
                        node.closeIndicatorOffset = token.getStartIndex();
                        this.exit(token.getEndIndex());
                        continue block42;
                    }
                    this.addChildTerm(new Dummy(0x400200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case BlockEntry: {
                    Collection.BlockSeq seqNode;
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (currentNode instanceof NodeWithProperties && currentNode.yamlParent instanceof SeqEntry) {
                        this.exit(Integer.MIN_VALUE);
                        currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    }
                    if (currentNode instanceof Collection.BlockSeq) {
                        seqNode = (Collection.BlockSeq)currentNode;
                    } else if (currentNode instanceof SeqEntry) {
                        this.exit(Integer.MIN_VALUE);
                        seqNode = (Collection.BlockSeq)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    } else {
                        seqNode = new Collection.BlockSeq(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(seqNode);
                    }
                    YamlAstNode node = new SeqEntry(seqNode, token.getStartIndex(), token.getEndIndex());
                    this.enterNode((SeqEntry)node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case FlowEntry: {
                    YamlAstNode node;
                    this.ensureDocContent(token.getStartIndex());
                    boolean found = this.exitTo1(Collection.FlowSeq.class, Collection.FlowMap.class);
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (found) {
                        NContainerBuilder builder = this.containerStack.get(this.depth);
                        if (currentNode.status == 0 && builder.sepOffsets.size() == builder.children.size()) {
                            switch (currentNode.getNodeType()) {
                                case SEQ: {
                                    node = new Dummy(4457248, currentNode, token.getStartIndex());
                                    break;
                                }
                                case MAP: {
                                    node = new Dummy(4465440, currentNode, token.getStartIndex());
                                    break;
                                }
                                default: {
                                    throw new RuntimeException();
                                }
                            }
                            this.addChildTerm(node);
                        }
                        builder.sepOffsets.add(token.getStartIndex());
                        continue block42;
                    }
                    this.addChildTerm(new Dummy(0x440200, currentNode, token.getStartIndex(), token.getEndIndex()));
                    continue block42;
                }
                case Anchor: {
                    NodeWithProperties propertiesNode;
                    YamlAstNode currentNode = this.checkParent(token);
                    if (currentNode.getNodeType() == NodeType.PROPERTIES_CONTAINER) {
                        propertiesNode = (NodeWithProperties)currentNode;
                    } else {
                        propertiesNode = new NodeWithProperties(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(propertiesNode);
                    }
                    YamlAstNode node = new Anchor(propertiesNode, token.getStartIndex(), token.getEndIndex(), ((AnchorToken)token).getValue());
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case Alias: {
                    YamlAstNode currentNode = this.checkParent(token);
                    Alias node = new Alias(currentNode, token.getStartIndex(), token.getEndIndex(), ((AliasToken)token).getValue());
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case Tag: {
                    NodeWithProperties propertiesNode;
                    TagTuple tagTuple = ((TagToken)token).getValue();
                    YamlAstNode currentNode = this.checkParent(token);
                    if (currentNode instanceof NodeWithProperties) {
                        propertiesNode = (NodeWithProperties)currentNode;
                    } else {
                        propertiesNode = new NodeWithProperties(currentNode, token.getStartIndex(), token.getEndIndex());
                        this.enterNode(propertiesNode);
                    }
                    YamlAstNode node = new Tag(propertiesNode, token.getStartIndex(), token.getEndIndex(), tagTuple.getHandle(), tagTuple.getSuffix());
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
                case Key: {
                    boolean found;
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (currentNode instanceof Collection.FlowSeq) {
                        found = true;
                    } else {
                        found = this.exitTo(NodeType.MAP);
                        currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    }
                    MapEntry entryNode = new MapEntry(currentNode, token.getStartIndex(), token.getEndIndex());
                    if (!found) {
                        entryNode.status |= 0x444200;
                    }
                    this.enterNode(entryNode);
                    this.attachProblem(entryNode, token);
                    if (token.getLength() <= 0) continue block42;
                    entryNode.keyIndicatorOffset = entryNode.startOffset;
                    continue block42;
                }
                case Value: {
                    boolean found;
                    MapEntry entryNode;
                    this.ensureDocContent(token.getStartIndex());
                    YamlAstNode currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    if (currentNode instanceof Collection.FlowSeq) {
                        found = true;
                    } else {
                        found = this.exitTo(NodeType.MAP_ENTRY, NodeType.MAP);
                        currentNode = (YamlAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
                    }
                    if (currentNode.getNodeType() == NodeType.MAP_ENTRY) {
                        entryNode = (MapEntry)currentNode;
                        entryNode.endOffset = token.getEndIndex();
                    } else {
                        entryNode = new MapEntry(currentNode, token.getStartIndex(), token.getEndIndex());
                        if (!found) {
                            entryNode.status |= 0x445200;
                        }
                        this.enterNode(entryNode);
                    }
                    this.attachProblem(entryNode, token);
                    if (token.getLength() <= 0) continue block42;
                    entryNode.valueIndicatorOffset = token.getStartIndex();
                    continue block42;
                }
                case Scalar: {
                    YamlAstNode node;
                    ScalarToken scalarToken = (ScalarToken)token;
                    YamlAstNode currentNode = this.checkParent(token);
                    switch (scalarToken.getStyle()) {
                        case DOUBLE_QUOTED: {
                            node = new Scalar.DQuoted(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                            break;
                        }
                        case SINGLE_QUOTED: {
                            node = new Scalar.SQuoated(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                            break;
                        }
                        case LITERAL: {
                            node = new Scalar.Literal(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                            break;
                        }
                        case FOLDED: {
                            node = new Scalar.Folded(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                            break;
                        }
                        default: {
                            node = new Scalar.Plain(currentNode, token.getStartIndex(), token.getEndIndex(), scalarToken.getValue());
                        }
                    }
                    this.addChildTerm(node);
                    this.attachProblem(node, token);
                    continue block42;
                }
            }
        }
    }

    private void attachProblem(YamlAstNode node, Token token) {
        if ((node.getStatusCode() & 0x400000) != 0) {
            return;
        }
        SyntaxProblem problem = token.getProblem();
        if (problem != null) {
            node.status = problem.getStatus();
            StatusDetail statusDetail = problem.getStatusDetail();
            if (statusDetail != null) {
                node.addAttachment(statusDetail);
            }
        }
    }

    static final class NContainerBuilder {
        final List<YamlAstNode> children = new ArrayList<YamlAstNode>(8);
        final IntList sepOffsets = new IntArrayList(8);

        NContainerBuilder() {
        }

        void clear() {
            this.children.clear();
            this.sepOffsets.clear();
        }
    }
}

